/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.AbstractClustering;
import dragon.ir.clustering.Clustering;
import dragon.ir.clustering.clustermodel.ClusterModel;
import dragon.ir.clustering.clustermodel.MultinomialClusterModel;
import dragon.ir.index.IRDoc;
import dragon.matrix.DoubleDenseMatrix;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.matrix.vector.DoubleVector;
import dragon.util.MathUtil;
import java.util.Date;

public class LinkKMean
extends AbstractClustering {
    private Clustering initClustering;
    private SparseMatrix inLinks;
    private SparseMatrix outLinks;
    private ClusterModel distMetric;
    private int maxIteration;
    private boolean useWeight;

    public LinkKMean(Clustering initClustering, SparseMatrix links) {
        this(initClustering, links, null);
    }

    public LinkKMean(Clustering initClustering, SparseMatrix outLinks, SparseMatrix inLinks) {
        super(initClustering.getIndexReader());
        this.initClustering = initClustering;
        this.inLinks = inLinks;
        this.outLinks = outLinks;
        this.clusterNum = initClustering.getClusterNum();
        this.distMetric = new MultinomialClusterModel(this.clusterNum, this.indexReader, 0.5);
    }

    public void setUseWeight(boolean useWeight) {
        this.useWeight = useWeight;
    }

    public boolean getUseWeight() {
        return this.useWeight;
    }

    protected boolean initialize(IRDoc[] arrDoc) {
        this.initClustering.setRandomSeed(this.randomSeed);
        this.initClustering.cluster(arrDoc);
        this.distMetric.setFeatureFilter(this.initClustering.getFeatureFilter());
        this.clusterSet = this.initClustering.getClusterSet();
        return true;
    }

    @Override
    public boolean cluster(IRDoc[] arrDoc) {
        DoubleVector probVector = new DoubleVector(this.clusterNum);
        int movingObj = arrDoc.length;
        int iteration = 0;
        int[] arrDocLabel = new int[this.indexReader.getCollection().getDocNum()];
        double[] outNeighbor = new double[this.clusterNum];
        double[] inNeighbor = this.inLinks != null ? new double[this.clusterNum] : null;
        if (!this.initialize(arrDoc)) {
            return false;
        }
        while (movingObj > 0 && iteration < this.maxIteration) {
            int i;
            if (this.showProgress) {
                System.out.print(new Date().toString() + " " + iteration++);
                System.out.print(" ");
                System.out.println(movingObj);
            }
            this.distMetric.setDocClusters(this.clusterSet);
            MathUtil.initArray(arrDocLabel, -1);
            for (i = 0; i < arrDoc.length; ++i) {
                arrDocLabel[arrDoc[i].getIndex()] = arrDoc[i].getCategory();
            }
            DoubleDenseMatrix transMatrix = this.estimateClassTransferProb(arrDoc, arrDocLabel);
            movingObj = 0;
            for (i = 0; i < arrDoc.length; ++i) {
                int oldCluster;
                int label;
                int j;
                MathUtil.initArray(outNeighbor, 0.0);
                int[] arrIndex = this.outLinks.getNonZeroColumnsInRow(arrDoc[i].getIndex());
                Object arrScore = this.useWeight ? this.outLinks.getNonZeroDoubleScoresInRow(arrDoc[i].getIndex()) : null;
                if (arrIndex != null) {
                    for (j = 0; j < arrIndex.length; ++j) {
                        label = arrDocLabel[arrIndex[j]];
                        if (label < 0) continue;
                        if (!this.useWeight) {
                            int n = label;
                            outNeighbor[n] = outNeighbor[n] + 1.0;
                            continue;
                        }
                        int n = label;
                        outNeighbor[n] = outNeighbor[n] + arrScore[j];
                    }
                }
                if (this.inLinks != null) {
                    MathUtil.initArray(inNeighbor, 0.0);
                    arrIndex = this.inLinks.getNonZeroColumnsInRow(arrDoc[i].getIndex());
                    arrScore = this.useWeight ? this.inLinks.getNonZeroDoubleScoresInRow(arrDoc[i].getIndex()) : null;
                    if (arrIndex != null) {
                        for (j = 0; j < arrIndex.length; ++j) {
                            label = arrDocLabel[arrIndex[j]];
                            if (label < 0) continue;
                            if (!this.useWeight) {
                                int n = label;
                                inNeighbor[n] = inNeighbor[n] + 1.0;
                                continue;
                            }
                            int n = label;
                            inNeighbor[n] = inNeighbor[n] + arrScore[j];
                        }
                    }
                }
                for (j = 0; j < this.clusterNum; ++j) {
                    probVector.set(j, this.getLogLikelihood(arrDoc[i], j, transMatrix, outNeighbor, inNeighbor));
                }
                int curCluster = probVector.getDimWithMaxValue();
                if (curCluster == (oldCluster = arrDoc[i].getCategory())) continue;
                this.clusterSet.removeDoc(oldCluster, arrDoc[i]);
                this.clusterSet.addDoc(curCluster, arrDoc[i]);
                ++movingObj;
            }
        }
        return true;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public void setMaxIteration(int iteration) {
        this.maxIteration = iteration;
    }

    protected double getLogLikelihood(IRDoc doc, int clusterID, DoubleDenseMatrix transMatrix, double[] arrOutLinks, double[] arrInLinks) {
        int i;
        double sum = -this.distMetric.getDistance(doc, clusterID);
        for (i = 0; i < this.clusterNum; ++i) {
            sum += arrOutLinks[i] * transMatrix.getDouble(clusterID, i);
        }
        if (arrInLinks != null) {
            for (i = 0; i < this.clusterNum; ++i) {
                sum += arrInLinks[i] * transMatrix.getDouble(i, clusterID);
            }
        }
        return sum;
    }

    protected DoubleDenseMatrix estimateClassTransferProb(IRDoc[] arrDoc, int[] arrDocLabel) {
        int j;
        int i;
        DoubleFlatDenseMatrix matrix = new DoubleFlatDenseMatrix(this.clusterNum, this.clusterNum);
        matrix.assign(1.0);
        for (i = 0; i < arrDoc.length; ++i) {
            int startLabel = arrDocLabel[arrDoc[i].getIndex()];
            int[] arrIndex = this.outLinks.getNonZeroColumnsInRow(arrDoc[i].getIndex());
            if (arrIndex == null) continue;
            double[] arrScore = this.useWeight ? this.outLinks.getNonZeroDoubleScoresInRow(arrDoc[i].getIndex()) : null;
            for (j = 0; j < arrIndex.length; ++j) {
                int endLabel = arrDocLabel[arrIndex[j]];
                if (endLabel < 0) continue;
                if (!this.useWeight) {
                    matrix.add(startLabel, endLabel, 1.0);
                    continue;
                }
                matrix.add(startLabel, endLabel, arrScore[j]);
            }
        }
        for (i = 0; i < this.clusterNum; ++i) {
            double sum = matrix.getRowSum(i);
            for (j = 0; j < this.clusterNum; ++j) {
                matrix.setDouble(i, j, Math.log(matrix.getDouble(i, j) / sum));
            }
        }
        return matrix;
    }
}

