/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.index.IRDoc;
import dragon.nlp.compare.IndexComparator;
import dragon.util.SortedArray;
import java.util.ArrayList;

public class DocCluster {
    private int clusterID;
    private String clusterName;
    private SortedArray list;

    public DocCluster(int clusterID) {
        this.clusterID = clusterID;
        this.clusterName = String.valueOf(clusterID);
        this.list = new SortedArray(new IndexComparator());
    }

    public boolean addDoc(IRDoc doc) {
        doc.setCategory(this.clusterID);
        return this.list.add(doc);
    }

    public boolean removeDoc(IRDoc doc) {
        int pos = this.list.binarySearch(doc);
        if (pos < 0) {
            return false;
        }
        this.list.remove(pos);
        doc.setCategory(-1);
        return true;
    }

    public void removeAll() {
        this.list.clear();
    }

    public int getDocNum() {
        return this.list.size();
    }

    public IRDoc getDoc(int index) {
        return (IRDoc)this.list.get(index);
    }

    public boolean containDoc(IRDoc doc) {
        return this.list.contains(doc);
    }

    public ArrayList getDocSet() {
        return this.list;
    }

    public int getClusterID() {
        return this.clusterID;
    }

    public void setClusterID(int clusterID) {
        this.clusterID = clusterID;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }
}

