/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.DocClusterSet;

public class ClusteringEva {
    private double entropyScore;
    private double fScore;
    private double purityScore;
    private double nmiScore;
    private double geoNmiScore;
    private double miScore;
    private DocClusterSet human;
    private DocClusterSet machine;
    private double[][] matchMatrix;
    private double[][] recallMatrix;
    private double[][] precMatrix;
    private double docSum;
    private int clusterNum;
    private int classNum;

    public boolean evaluate(DocClusterSet machine, DocClusterSet human) {
        this.human = this.preprocessDocClusterSet(human);
        this.machine = this.preprocessDocClusterSet(machine);
        this.stat();
        this.matchMatrix = this.compClassMatch();
        this.compPrecRecall();
        this.compEntropy();
        this.compFScore();
        this.compPurityScore();
        this.compNMI();
        return true;
    }

    public double[][] getMatchMatrix() {
        return this.matchMatrix;
    }

    public double getMI() {
        return this.miScore;
    }

    public double getEntropy() {
        return this.entropyScore;
    }

    public double getFScore() {
        return this.fScore;
    }

    public double getPurity() {
        return this.purityScore;
    }

    public double getGeometryNMI() {
        return this.geoNmiScore;
    }

    public double getNMI() {
        return this.nmiScore;
    }

    private void stat() {
        int docSum = 0;
        for (int i = 0; i < this.machine.getClusterNum(); ++i) {
            docSum += this.machine.getDocCluster(i).getDocNum();
        }
        this.docSum = docSum;
        this.clusterNum = this.machine.getClusterNum();
        this.classNum = this.machine.getClusterNum();
    }

    private void compFScore() {
        double max = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.recallMatrix.length; ++i) {
            max = 0.0;
            for (int j = 0; j < this.recallMatrix[0].length; ++j) {
                if (!(max < this.compFScore(i, j))) continue;
                max = this.compFScore(i, j);
            }
            sum += (double)this.human.getDocCluster(i).getDocNum() / this.docSum * max;
        }
        this.fScore = sum;
    }

    private double compFScore(int i, int j) {
        if (this.recallMatrix[i][j] == 0.0 && this.recallMatrix[i][j] == 0.0) {
            return 0.0;
        }
        return 2.0 * this.recallMatrix[i][j] * this.precMatrix[i][j] / (this.precMatrix[i][j] + this.recallMatrix[i][j]);
    }

    private void compPurityScore() {
        double sum = 0.0;
        for (int i = 0; i < this.machine.getClusterNum(); ++i) {
            sum += this.compPurityScore(this.machine.getDocCluster(i).getClusterID()) * ((double)this.machine.getDocCluster(i).getDocNum() / this.docSum);
        }
        this.purityScore = sum;
    }

    private double compPurityScore(int clusterID) {
        if (this.machine.getDocCluster(clusterID).getDocNum() == 0) {
            return 0.0;
        }
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.classNum; ++i) {
            if (!(max < this.matchMatrix[clusterID][i])) continue;
            max = this.matchMatrix[clusterID][i];
        }
        return max / (double)this.machine.getDocCluster(clusterID).getDocNum();
    }

    private void compEntropy() {
        double sum = 0.0;
        for (int i = 0; i < this.clusterNum; ++i) {
            sum += (double)this.machine.getDocCluster(i).getDocNum() * this.compEntropy(i) / this.docSum;
        }
        this.entropyScore = sum;
    }

    private double compEntropy(int clusterID) {
        double sum = 0.0;
        for (int j = 0; j < this.clusterNum; ++j) {
            if (this.precMatrix[clusterID][j] == 0.0) {
                sum += -Math.log(1.0 / this.docSum) * (1.0 / this.docSum);
                continue;
            }
            sum += -Math.log(this.precMatrix[clusterID][j]) * this.precMatrix[clusterID][j];
        }
        return sum;
    }

    private double[][] compClassMatch() {
        double[][] match = new double[this.clusterNum][this.classNum];
        for (int i = 0; i < this.clusterNum; ++i) {
            DocCluster dc1 = this.machine.getDocCluster(i);
            for (int j = 0; j < this.classNum; ++j) {
                DocCluster dc2 = this.human.getDocCluster(j);
                for (int k = 0; k < dc2.getDocNum(); ++k) {
                    if (!dc1.containDoc(dc2.getDoc(k))) continue;
                    double[] dArray = match[i];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
        }
        return match;
    }

    private void compPrecRecall() {
        this.precMatrix = new double[this.matchMatrix.length][this.matchMatrix[0].length];
        this.recallMatrix = new double[this.matchMatrix.length][this.matchMatrix[0].length];
        for (int i = 0; i < this.clusterNum; ++i) {
            DocCluster dc1 = this.machine.getDocCluster(i);
            for (int j = 0; j < this.classNum; ++j) {
                DocCluster dc2 = this.human.getDocCluster(j);
                this.precMatrix[i][j] = this.matchMatrix[i][j] / (double)dc1.getDocNum();
                this.recallMatrix[i][j] = this.matchMatrix[i][j] / (double)dc2.getDocNum();
            }
        }
    }

    private void compNMI() {
        double yProb;
        double xProb;
        int i;
        double sumJoint = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        for (i = 0; i < this.clusterNum; ++i) {
            for (int j = 0; j < this.classNum; ++j) {
                double jointProb = this.matchMatrix[i][j] == 0.0 ? 1.0 / this.docSum : this.matchMatrix[i][j] / this.docSum;
                xProb = (double)this.machine.getDocCluster(i).getDocNum() / this.docSum;
                yProb = (double)this.human.getDocCluster(j).getDocNum() / this.docSum;
                sumJoint += jointProb * Math.log(jointProb / (xProb * yProb));
            }
        }
        for (i = 0; i < this.clusterNum; ++i) {
            xProb = (double)this.machine.getDocCluster(i).getDocNum() / this.docSum;
            sumX += xProb * Math.log(1.0 / xProb);
        }
        for (i = 0; i < this.clusterNum; ++i) {
            yProb = (double)this.human.getDocCluster(i).getDocNum() / this.docSum;
            sumY += yProb * Math.log(1.0 / yProb);
        }
        this.miScore = sumJoint;
        this.nmiScore = 2.0 * sumJoint / (Math.log(this.clusterNum) + Math.log(this.classNum));
        this.geoNmiScore = sumJoint / Math.sqrt(sumX * sumY);
    }

    private DocClusterSet preprocessDocClusterSet(DocClusterSet oldSet) {
        int i;
        int count = 0;
        for (i = 0; i < oldSet.getClusterNum(); ++i) {
            if (oldSet.getDocCluster(i).getDocNum() <= 0) continue;
            ++count;
        }
        DocClusterSet newSet = new DocClusterSet(count);
        count = 0;
        for (i = 0; i < oldSet.getClusterNum(); ++i) {
            if (oldSet.getDocCluster(i).getDocNum() <= 0) continue;
            newSet.setDocCluster(oldSet.getDocCluster(i), count);
            ++count;
        }
        return newSet;
    }
}

