/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.AbstractClustering;
import dragon.ir.clustering.BasicKMean;
import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.DocClusterSet;
import dragon.ir.clustering.clustermodel.ClusterModel;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;

public class BisectKMean
extends AbstractClustering {
    protected ClusterModel distMetric;
    protected boolean refine;
    protected int maxIteration;
    protected DocClusterSet clusterSet;
    private boolean initAllObjs;

    public BisectKMean(IndexReader indexReader, ClusterModel distMetric, int clusterNum) {
        this(indexReader, distMetric, clusterNum, false);
    }

    public BisectKMean(IndexReader indexReader, ClusterModel distMetric, int clusterNum, boolean initAllObjs) {
        super(indexReader);
        this.clusterNum = clusterNum;
        this.distMetric = distMetric;
        this.refine = false;
        this.maxIteration = 200;
        this.randomSeed = 0L;
        this.initAllObjs = initAllObjs;
    }

    public void setUseAllObjectForInitialization(boolean option) {
        this.initAllObjs = option;
    }

    public boolean getUseAllObjectForInitialization() {
        return this.initAllObjs;
    }

    @Override
    public boolean cluster(IRDoc[] arrDoc) {
        if (this.featureFilter != null) {
            this.featureFilter.initialize(this.indexReader, arrDoc);
            this.distMetric.setFeatureFilter(this.featureFilter);
        }
        return this.cluster(arrDoc, 2);
    }

    public void setRefine(boolean refine) {
        this.refine = refine;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public void setMaxIteration(int iteration) {
        this.maxIteration = iteration;
    }

    private boolean cluster(IRDoc[] arrDoc, int secNum) {
        int i;
        if (this.clusterNum < secNum) {
            return false;
        }
        this.distMetric.setClusterNum(secNum);
        BasicKMean bkm = new BasicKMean(this.indexReader, this.distMetric, secNum, this.initAllObjs);
        bkm.setFeatureFilter(this.featureFilter);
        bkm.setMaxIteration(this.maxIteration);
        bkm.setRandomSeed(this.randomSeed);
        bkm.setShowProgress(this.showProgress);
        int id = 0;
        DocClusterSet mainDcs = new DocClusterSet(this.clusterNum);
        bkm.cluster(arrDoc);
        DocClusterSet dcs = bkm.getClusterSet();
        for (i = 0; i < secNum; ++i) {
            mainDcs.setDocCluster(dcs.getDocCluster(i), id++);
        }
        while (id < this.clusterNum) {
            DocCluster dc;
            int max = Integer.MIN_VALUE;
            int index = -1;
            for (i = 0; i < id; ++i) {
                dc = mainDcs.getDocCluster(i);
                if (max >= dc.getDocNum()) continue;
                max = dc.getDocNum();
                index = i;
            }
            dc = mainDcs.getDocCluster(index);
            arrDoc = new IRDoc[dc.getDocNum()];
            for (i = 0; i < dc.getDocNum(); ++i) {
                arrDoc[i] = dc.getDoc(i);
                arrDoc[i].setCategory(-1);
            }
            this.distMetric.setClusterNum(secNum);
            bkm = new BasicKMean(this.indexReader, this.distMetric, secNum, this.initAllObjs);
            bkm.setMaxIteration(this.maxIteration);
            bkm.setRandomSeed(this.randomSeed);
            bkm.setShowProgress(this.showProgress);
            bkm.cluster(arrDoc);
            mainDcs.setDocCluster(bkm.getClusterSet().getDocCluster(0), index);
            for (i = 1; i < bkm.getClusterNum(); ++i) {
                mainDcs.setDocCluster(bkm.getClusterSet().getDocCluster(i), id++);
            }
        }
        if (this.refine) {
            this.distMetric.setClusterNum(this.clusterNum);
            bkm = new BasicKMean(this.indexReader, this.distMetric, mainDcs);
            bkm.setMaxIteration(this.maxIteration);
            bkm.setRandomSeed(this.randomSeed);
            bkm.setShowProgress(this.showProgress);
            arrDoc = new IRDoc[this.indexReader.getCollection().getDocNum()];
            bkm.cluster(arrDoc);
        }
        this.clusterSet = mainDcs;
        return true;
    }

    @Override
    public DocClusterSet getClusterSet() {
        return this.clusterSet;
    }
}

