/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.AbstractClustering;
import dragon.ir.clustering.DocClusterSet;
import dragon.ir.clustering.clustermodel.ClusterModel;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import java.util.Date;
import java.util.Random;

public class BasicKMean
extends AbstractClustering {
    protected ClusterModel distMetric;
    protected boolean initialized;
    protected int maxIteration;
    private boolean initAllObjs;

    public BasicKMean(IndexReader indexReader, ClusterModel distMetric, int clusterNum) {
        this(indexReader, distMetric, clusterNum, false);
    }

    public BasicKMean(IndexReader indexReader, ClusterModel distMetric, int clusterNum, boolean initAllObjs) {
        super(indexReader);
        this.clusterNum = clusterNum;
        this.distMetric = distMetric;
        this.initialized = false;
        this.maxIteration = 200;
        this.randomSeed = 0L;
        this.initAllObjs = initAllObjs;
    }

    public BasicKMean(IndexReader indexReader, ClusterModel distMetric, DocClusterSet initClusterSet) {
        super(indexReader);
        this.clusterNum = initClusterSet.getClusterNum();
        this.distMetric = distMetric;
        this.clusterSet = initClusterSet;
        distMetric.setDocClusters(initClusterSet);
        this.initialized = true;
        this.maxIteration = 200;
    }

    public void setUseAllObjectForInitialization(boolean option) {
        this.initAllObjs = option;
    }

    public boolean getUseAllObjectForInitialization() {
        return this.initAllObjs;
    }

    protected boolean initialize(IRDoc[] arrDoc) {
        int i;
        Random random = new Random();
        if (this.randomSeed > 0L) {
            random.setSeed(this.randomSeed);
        }
        this.clusterSet = new DocClusterSet(this.clusterNum);
        for (i = 0; i < arrDoc.length; ++i) {
            arrDoc[i].setCategory(-1);
        }
        i = 0;
        while (i < this.clusterNum) {
            int curDocNo = (int)(random.nextDouble() * (double)arrDoc.length);
            if (arrDoc[curDocNo].getCategory() != -1) continue;
            this.clusterSet.addDoc(i, arrDoc[curDocNo]);
            ++i;
        }
        for (i = 0; this.initAllObjs && i < arrDoc.length; ++i) {
            if (arrDoc[i].getCategory() != -1) continue;
            this.clusterSet.addDoc(random.nextInt(this.clusterNum), arrDoc[i]);
        }
        this.distMetric.setDocClusters(this.clusterSet);
        return true;
    }

    @Override
    public boolean cluster(IRDoc[] arrDoc) {
        int docNum;
        if (this.featureFilter != null) {
            this.featureFilter.initialize(this.indexReader, arrDoc);
            this.distMetric.setFeatureFilter(this.featureFilter);
        }
        Random random = new Random();
        if (this.randomSeed > 0L) {
            random.setSeed(this.randomSeed);
        }
        int[] arrCanCluster = new int[this.clusterNum];
        int movingObj = docNum = arrDoc.length;
        int iteration = 0;
        if (!this.initialized && !this.initialize(arrDoc)) {
            return false;
        }
        while (movingObj > 0 && iteration < this.maxIteration) {
            if (this.showProgress) {
                System.out.print(new Date().toString() + " " + iteration++);
                System.out.print(" ");
                System.out.println(movingObj);
            }
            movingObj = 0;
            for (int i = 0; i < docNum; ++i) {
                int oldCluster;
                int curCluster;
                double minDist = Double.MAX_VALUE;
                int candidateNum = 0;
                for (int j = 0; j < this.clusterNum; ++j) {
                    double curDist = this.distMetric.getDistance(arrDoc[i], j);
                    if (curDist <= minDist - 1.0E-5) {
                        minDist = curDist;
                        arrCanCluster[0] = j;
                        candidateNum = 1;
                        continue;
                    }
                    if (!(Math.abs(curDist - minDist) < 1.0E-5)) continue;
                    if (curDist < minDist) {
                        minDist = curDist;
                    }
                    arrCanCluster[candidateNum] = j;
                    ++candidateNum;
                }
                curCluster = candidateNum == 1 ? arrCanCluster[0] : ((curCluster = (int)(random.nextDouble() * (double)candidateNum)) == candidateNum ? arrCanCluster[curCluster - 1] : arrCanCluster[curCluster]);
                if (curCluster == (oldCluster = arrDoc[i].getCategory())) continue;
                this.clusterSet.removeDoc(arrDoc[i].getCategory(), arrDoc[i]);
                this.clusterSet.addDoc(curCluster, arrDoc[i]);
                ++movingObj;
            }
            if (movingObj == 0) break;
            this.distMetric.setDocClusters(this.clusterSet);
        }
        return true;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public void setMaxIteration(int iteration) {
        this.maxIteration = iteration;
    }
}

