/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.clustering;

import dragon.ir.clustering.Clustering;
import dragon.ir.clustering.DocCluster;
import dragon.ir.clustering.DocClusterSet;
import dragon.ir.clustering.featurefilter.FeatureFilter;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;

public abstract class AbstractClustering
implements Clustering {
    protected IndexReader indexReader;
    protected FeatureFilter featureFilter;
    protected int clusterNum;
    protected DocClusterSet clusterSet;
    protected boolean showProgress;
    protected long randomSeed;

    public AbstractClustering(IndexReader indexReader) {
        this.indexReader = indexReader;
        this.showProgress = true;
    }

    @Override
    public int getClusterNum() {
        return this.clusterNum;
    }

    @Override
    public long getRandomSeed() {
        return this.randomSeed;
    }

    @Override
    public void setRandomSeed(long seed) {
        this.randomSeed = seed;
    }

    @Override
    public DocClusterSet getClusterSet() {
        return this.clusterSet;
    }

    @Override
    public DocCluster getCluster(int index) {
        return this.clusterSet.getDocCluster(index);
    }

    @Override
    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    @Override
    public boolean cluster() {
        IRDoc[] arrDoc = new IRDoc[this.indexReader.getCollection().getDocNum()];
        for (int i = 0; i < arrDoc.length; ++i) {
            arrDoc[i] = this.indexReader.getDoc(i);
        }
        return this.cluster(arrDoc);
    }

    @Override
    public FeatureFilter getFeatureFilter() {
        return this.featureFilter;
    }

    @Override
    public void setFeatureFilter(FeatureFilter selector) {
        this.featureFilter = selector;
    }

    public void setShowProgress(boolean option) {
        this.showProgress = option;
    }
}

