/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.classification.multiclass;

import dragon.ir.classification.multiclass.CodeMatrix;
import dragon.ir.classification.multiclass.LossFunction;
import dragon.ir.classification.multiclass.MultiClassDecoder;
import dragon.matrix.vector.DoubleVector;
import java.io.Serializable;

public class LossMultiClassDecoder
implements MultiClassDecoder,
Serializable {
    private static final long serialVersionUID = 1L;
    private LossFunction lossFunc;
    private DoubleVector lossVector;
    private int[] rankings;

    public LossMultiClassDecoder(LossFunction lossFunc) {
        this.lossFunc = lossFunc;
    }

    @Override
    public int decode(CodeMatrix matrix, double[] binClassifierResults) {
        if (binClassifierResults.length != matrix.getClassifierNum()) {
            System.out.println("The input data are not valid. Number of binary classifiers is not consistent.");
            return -1;
        }
        this.lossVector = new DoubleVector(matrix.getClassNum());
        for (int i = 0; i < matrix.getClassNum(); ++i) {
            for (int j = 0; j < matrix.getClassifierNum(); ++j) {
                this.lossVector.add(i, this.lossFunc.loss((double)matrix.getCode(i, j) * binClassifierResults[j]));
            }
        }
        this.rankings = this.lossVector.rank(false);
        return this.rankings[0];
    }

    @Override
    public int[] rank() {
        return this.rankings;
    }
}

