/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.classification.featureselection;

import dragon.ir.classification.DocClassSet;
import dragon.ir.classification.featureselection.AbstractFeatureSelector;
import dragon.ir.index.IRTerm;
import dragon.ir.index.IndexReader;
import dragon.matrix.IntDenseMatrix;
import dragon.matrix.SparseMatrix;
import java.io.Serializable;
import java.util.ArrayList;

public class DocFrequencySelector
extends AbstractFeatureSelector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int minDocFrequency;

    public DocFrequencySelector(int minDocFrequency) {
        this.minDocFrequency = minDocFrequency;
    }

    @Override
    protected int[] getSelectedFeatures(SparseMatrix doctermMatrix, DocClassSet trainingSet) {
        int i;
        int[] featureMap = this.getTermDocFrequency(doctermMatrix, trainingSet);
        int termNum = featureMap.length;
        ArrayList<Integer> list = new ArrayList<Integer>(termNum);
        for (i = 0; i < termNum; ++i) {
            if (featureMap[i] < this.minDocFrequency) continue;
            list.add(new Integer(i));
        }
        featureMap = new int[list.size()];
        for (i = 0; i < featureMap.length; ++i) {
            featureMap[i] = (Integer)list.get(i);
        }
        return featureMap;
    }

    @Override
    protected int[] getSelectedFeatures(IndexReader indexReader, DocClassSet trainingSet) {
        int i;
        IntDenseMatrix termDistri = this.getTermDistribution(indexReader, trainingSet);
        int termNum = termDistri.columns();
        ArrayList<IRTerm> list = new ArrayList<IRTerm>(termNum);
        for (i = 0; i < termNum; ++i) {
            IRTerm curTerm;
            if (termDistri.getColumnSum(i) <= 0L || (curTerm = indexReader.getIRTerm(i)).getDocFrequency() < this.minDocFrequency) continue;
            list.add(curTerm);
        }
        int[] featureMap = new int[list.size()];
        for (i = 0; i < featureMap.length; ++i) {
            featureMap[i] = ((IRTerm)list.get(i)).getIndex();
        }
        return featureMap;
    }
}

