/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.classification.featureselection;

import dragon.ir.classification.DocClass;
import dragon.ir.classification.DocClassSet;
import dragon.ir.classification.featureselection.FeatureSelector;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.matrix.IntDenseMatrix;
import dragon.matrix.IntFlatDenseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.matrix.vector.DoubleVector;
import dragon.util.MathUtil;
import java.io.Serializable;

public abstract class AbstractFeatureSelector
implements FeatureSelector,
Serializable {
    protected int[] featureMap;
    protected int selectedFeatureNum;

    protected abstract int[] getSelectedFeatures(IndexReader var1, DocClassSet var2);

    protected abstract int[] getSelectedFeatures(SparseMatrix var1, DocClassSet var2);

    @Override
    public void train(IndexReader indexReader, DocClassSet trainingSet) {
        this.setSelectedFeatures(this.getSelectedFeatures(indexReader, trainingSet));
    }

    @Override
    public void train(SparseMatrix doctermMatrix, DocClassSet trainingSet) {
        this.setSelectedFeatures(this.getSelectedFeatures(doctermMatrix, trainingSet));
    }

    @Override
    public void setSelectedFeatures(int[] selectedFeatures) {
        if (selectedFeatures == null) {
            return;
        }
        int oldFeatureNum = selectedFeatures[selectedFeatures.length - 1] + 1;
        this.featureMap = new int[oldFeatureNum];
        MathUtil.initArray(this.featureMap, -1);
        for (int i = 0; i < selectedFeatures.length; ++i) {
            this.featureMap[selectedFeatures[i]] = i;
        }
        this.selectedFeatureNum = selectedFeatures.length;
    }

    @Override
    public boolean isSelected(int originalFeatureIndex) {
        if (originalFeatureIndex >= this.featureMap.length) {
            return false;
        }
        return this.featureMap[originalFeatureIndex] != -1;
    }

    @Override
    public int map(int originalFeatureIndex) {
        if (originalFeatureIndex >= this.featureMap.length) {
            return -1;
        }
        return this.featureMap[originalFeatureIndex];
    }

    @Override
    public int getSelectedFeatureNum() {
        return this.selectedFeatureNum;
    }

    protected DoubleVector getClassPrior(DocClassSet docSet) {
        int i;
        int sum = docSet.getClassNum();
        DoubleVector vector = new DoubleVector(docSet.getClassNum());
        vector.assign(0.0);
        for (i = 0; i < docSet.getClassNum(); ++i) {
            vector.set(i, docSet.getDocClass(i).getDocNum());
            sum += docSet.getDocClass(i).getDocNum();
        }
        for (i = 0; i < docSet.getClassNum(); ++i) {
            vector.set(i, vector.get(i) / (double)sum);
        }
        return vector;
    }

    protected int[] getTermDocFrequency(SparseMatrix matrix, DocClassSet trainingSet) {
        int[] arrStat = new int[matrix.columns()];
        for (int i = 0; i < trainingSet.getClassNum(); ++i) {
            DocClass curClass = trainingSet.getDocClass(i);
            for (int j = 0; j < curClass.getDocNum(); ++j) {
                IRDoc curDoc = curClass.getDoc(j);
                int[] arrIndex = matrix.getNonZeroColumnsInRow(curDoc.getIndex());
                if (arrIndex == null || arrIndex.length == 0) continue;
                for (int k = 0; k < arrIndex.length; ++k) {
                    int n = arrIndex[k];
                    arrStat[n] = arrStat[n] + 1;
                }
            }
        }
        return arrStat;
    }

    protected IntDenseMatrix getTermDistribution(IndexReader indexReader, DocClassSet trainingSet) {
        IntFlatDenseMatrix matrix = new IntFlatDenseMatrix(trainingSet.getClassNum(), indexReader.getCollection().getTermNum());
        matrix.assign(0);
        for (int i = 0; i < trainingSet.getClassNum(); ++i) {
            DocClass curClass = trainingSet.getDocClass(i);
            for (int j = 0; j < curClass.getDocNum(); ++j) {
                IRDoc curDoc = curClass.getDoc(j);
                int[] arrIndex = indexReader.getTermIndexList(curDoc.getIndex());
                if (arrIndex == null || arrIndex.length == 0) continue;
                for (int k = 0; k < arrIndex.length; ++k) {
                    matrix.add(i, arrIndex[k], 1);
                }
            }
        }
        return matrix;
    }

    protected IntDenseMatrix getTermDistribution(SparseMatrix doctermMatrix, DocClassSet trainingSet) {
        IntFlatDenseMatrix matrix = new IntFlatDenseMatrix(trainingSet.getClassNum(), doctermMatrix.columns());
        matrix.assign(0);
        for (int i = 0; i < trainingSet.getClassNum(); ++i) {
            DocClass curClass = trainingSet.getDocClass(i);
            for (int j = 0; j < curClass.getDocNum(); ++j) {
                IRDoc curDoc = curClass.getDoc(j);
                int[] arrIndex = doctermMatrix.getNonZeroColumnsInRow(curDoc.getIndex());
                if (arrIndex == null || arrIndex.length == 0) continue;
                for (int k = 0; k < arrIndex.length; ++k) {
                    matrix.add(i, arrIndex[k], 1);
                }
            }
        }
        return matrix;
    }
}

