/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.classification;

import dragon.ir.classification.AbstractClassifier;
import dragon.ir.classification.DocClass;
import dragon.ir.classification.DocClassSet;
import dragon.ir.classification.featureselection.FeatureSelector;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.Row;
import dragon.matrix.SparseMatrix;
import dragon.matrix.vector.DoubleVector;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class NBClassifier
extends AbstractClassifier {
    protected DoubleFlatDenseMatrix model;
    protected DoubleVector classPrior;
    protected DoubleVector lastClassProb;
    private int[] rank;

    public NBClassifier(String modelFile) {
        try {
            ObjectInputStream oin = new ObjectInputStream(new FileInputStream(modelFile));
            this.model = (DoubleFlatDenseMatrix)oin.readObject();
            this.classPrior = (DoubleVector)oin.readObject();
            this.classNum = this.classPrior.size();
            this.featureSelector = (FeatureSelector)oin.readObject();
            this.arrLabel = new String[this.model.rows()];
            for (int i = 0; i < this.arrLabel.length; ++i) {
                this.arrLabel[i] = (String)oin.readObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public NBClassifier(IndexReader indexReader) {
        super(indexReader);
    }

    public NBClassifier(SparseMatrix doctermMatrix) {
        super(doctermMatrix);
    }

    @Override
    public void train(DocClassSet trainingDocSet) {
        int i;
        if (this.indexReader == null && this.doctermMatrix == null) {
            return;
        }
        this.classNum = trainingDocSet.getClassNum();
        this.classPrior = this.getClassPrior(trainingDocSet);
        this.trainFeatureSelector(trainingDocSet);
        this.arrLabel = new String[this.classNum];
        for (i = 0; i < this.classNum; ++i) {
            this.arrLabel[i] = trainingDocSet.getDocClass(i).getClassName();
        }
        this.model = new DoubleFlatDenseMatrix(this.classNum, this.featureSelector.getSelectedFeatureNum());
        this.model.assign(1.0);
        for (i = 0; i < this.classNum; ++i) {
            int k;
            int classSum = this.featureSelector.getSelectedFeatureNum();
            DocClass cur = trainingDocSet.getDocClass(i);
            for (int j = 0; j < cur.getDocNum(); ++j) {
                IRDoc curDoc = cur.getDoc(j);
                Row row = this.getRow(curDoc.getIndex());
                for (k = 0; k < row.getNonZeroNum(); ++k) {
                    int newTermIndex = this.featureSelector.map(row.getNonZeroColumn(k));
                    if (newTermIndex < 0) continue;
                    classSum = (int)((double)classSum + row.getNonZeroDoubleScore(k));
                    this.model.add(i, newTermIndex, row.getNonZeroDoubleScore(k));
                }
            }
            double rate = 1.0 / (double)classSum;
            for (k = 0; k < this.model.columns(); ++k) {
                this.model.setDouble(i, k, Math.log(this.model.getDouble(i, k) * rate));
            }
        }
    }

    protected DoubleVector getClassPrior(DocClassSet docSet) {
        int i;
        int sum = docSet.getClassNum();
        DoubleVector vector = new DoubleVector(docSet.getClassNum());
        vector.assign(1.0);
        for (i = 0; i < docSet.getClassNum(); ++i) {
            vector.set(i, docSet.getDocClass(i).getDocNum());
            sum += docSet.getDocClass(i).getDocNum();
        }
        for (i = 0; i < docSet.getClassNum(); ++i) {
            vector.set(i, Math.log(vector.get(i) / (double)sum));
        }
        return vector;
    }

    @Override
    public int classify(IRDoc doc) {
        int label = this.classify(this.getRow(doc.getIndex()));
        doc.setWeight(this.lastClassProb.get(label));
        return label;
    }

    @Override
    public int classify(Row doc) {
        this.lastClassProb = this.classPrior.copy();
        int classNum = this.model.rows();
        for (int k = 0; k < doc.getNonZeroNum(); ++k) {
            int newTermIndex = this.featureSelector.map(doc.getNonZeroColumn(k));
            if (newTermIndex < 0) continue;
            for (int j = 0; j < classNum; ++j) {
                this.lastClassProb.add(j, doc.getNonZeroDoubleScore(k) * this.model.getDouble(j, newTermIndex));
            }
        }
        this.rank = this.lastClassProb.rank(true);
        return this.rank[0];
    }

    @Override
    public int[] rank() {
        return this.rank;
    }

    @Override
    public void saveModel(String modelFile) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(modelFile));
            out.writeObject(this.model);
            out.writeObject(this.classPrior);
            out.writeObject(this.featureSelector);
            for (int i = 0; i < this.model.rows(); ++i) {
                out.writeObject(this.getClassLabel(i));
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

