/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.classification;

import dragon.ir.classification.Classifier;
import dragon.ir.classification.DocClass;
import dragon.ir.classification.DocClassSet;
import dragon.ir.classification.featureselection.DocFrequencySelector;
import dragon.ir.classification.featureselection.FeatureSelector;
import dragon.ir.classification.featureselection.NullFeatureSelector;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.matrix.DoubleRow;
import dragon.matrix.IntRow;
import dragon.matrix.Row;
import dragon.matrix.SparseMatrix;

public abstract class AbstractClassifier
implements Classifier {
    protected IndexReader indexReader;
    protected SparseMatrix doctermMatrix;
    protected DocClassSet validatingDocSet;
    protected FeatureSelector featureSelector;
    protected String[] arrLabel;
    protected int classNum;

    public AbstractClassifier(IndexReader indexReader) {
        this.featureSelector = new DocFrequencySelector(1);
        this.indexReader = indexReader;
        this.doctermMatrix = null;
        this.validatingDocSet = null;
        this.arrLabel = null;
    }

    public AbstractClassifier(SparseMatrix doctermMatrix) {
        this.featureSelector = new DocFrequencySelector(1);
        this.indexReader = null;
        this.doctermMatrix = doctermMatrix;
        this.validatingDocSet = null;
        this.arrLabel = null;
    }

    public AbstractClassifier() {
        this.featureSelector = new NullFeatureSelector();
        this.indexReader = null;
        this.doctermMatrix = null;
        this.validatingDocSet = null;
        this.arrLabel = null;
    }

    @Override
    public String getClassLabel(int index) {
        if (this.arrLabel == null || index >= this.arrLabel.length) {
            return null;
        }
        return this.arrLabel[index];
    }

    @Override
    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public SparseMatrix getDocTermMatrix() {
        return this.doctermMatrix;
    }

    @Override
    public FeatureSelector getFeatureSelector() {
        return this.featureSelector;
    }

    @Override
    public void setFeatureSelector(FeatureSelector selector) {
        this.featureSelector = selector;
    }

    @Override
    public DocClassSet classify(DocClassSet trainingDocSet, DocClass testingDocs) {
        this.train(trainingDocSet);
        return this.classify(testingDocs);
    }

    @Override
    public DocClassSet classify(DocClassSet trainingDocSet, DocClassSet validatingDocSet, DocClass testingDocs) {
        this.validatingDocSet = validatingDocSet;
        return this.classify(trainingDocSet, testingDocs);
    }

    @Override
    public void train(DocClassSet trainingDocSet, DocClassSet validatingDocSet) {
        this.validatingDocSet = validatingDocSet;
        this.train(trainingDocSet);
    }

    @Override
    public DocClassSet classify(DocClass testingDocs) {
        if (this.indexReader == null && this.doctermMatrix == null) {
            return null;
        }
        try {
            int i;
            DocClassSet docSet = new DocClassSet(this.classNum);
            for (i = 0; i < this.classNum; ++i) {
                docSet.getDocClass(i).setClassName(this.getClassLabel(i));
            }
            for (i = 0; i < testingDocs.getDocNum(); ++i) {
                int label = this.classify(testingDocs.getDoc(i));
                if (label < 0) continue;
                docSet.addDoc(label, testingDocs.getDoc(i));
            }
            return docSet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int classify(IRDoc doc) {
        return this.classify(this.getRow(doc.getIndex()));
    }

    protected Row getRow(int docIndex) {
        if (this.indexReader != null) {
            int[] columns = this.indexReader.getTermIndexList(docIndex);
            if (columns == null || columns.length == 0) {
                return null;
            }
            return new IntRow(docIndex, columns.length, columns, this.indexReader.getTermFrequencyList(docIndex));
        }
        int[] columns = this.doctermMatrix.getNonZeroColumnsInRow(docIndex);
        if (columns == null || columns.length == 0) {
            return null;
        }
        return new DoubleRow(docIndex, columns.length, columns, this.doctermMatrix.getNonZeroDoubleScoresInRow(docIndex));
    }

    protected void trainFeatureSelector(DocClassSet trainingSet) {
        if (this.indexReader != null) {
            this.featureSelector.train(this.indexReader, trainingSet);
        } else {
            this.featureSelector.train(this.doctermMatrix, trainingSet);
        }
    }
}

