/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConceptExtractorConfig;
import dragon.config.ConceptFilterConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.nlp.extract.BasicTripleExtractor;
import dragon.nlp.extract.ConceptFilter;
import dragon.nlp.extract.TermExtractor;
import dragon.nlp.extract.TripleExtractor;

public class TripleExtractorConfig
extends ConfigUtil {
    public TripleExtractorConfig() {
    }

    public TripleExtractorConfig(ConfigureNode root) {
        super(root);
    }

    public TripleExtractorConfig(String configFile) {
        super(configFile);
    }

    public TripleExtractor getTripleExtractor(int tripleExtractorID) {
        return this.getTripleExtractor(this.root, tripleExtractorID);
    }

    public TripleExtractor getTripleExtractor(ConfigureNode node, int tripleExtractorID) {
        return this.loadTripleExtractor(node, tripleExtractorID);
    }

    private TripleExtractor loadTripleExtractor(ConfigureNode node, int tripleExtractorID) {
        ConfigureNode tripleExtractorNode = this.getConfigureNode(node, "tripleextractor", tripleExtractorID);
        if (tripleExtractorNode == null) {
            return null;
        }
        String tripleExtractorName = tripleExtractorNode.getNodeName();
        return this.loadTripleExtractor(tripleExtractorName, tripleExtractorNode);
    }

    protected TripleExtractor loadTripleExtractor(String tripleExtractorName, ConfigureNode tripleExtractorNode) {
        if (tripleExtractorName.equalsIgnoreCase("BasicTripleExtractor")) {
            return this.loadBasicTripleExtractor(tripleExtractorNode);
        }
        return (TripleExtractor)this.loadResource(tripleExtractorNode);
    }

    private TripleExtractor loadBasicTripleExtractor(ConfigureNode curNode) {
        int extractorID = curNode.getInt("conceptextractor", 0);
        int filterID = curNode.getInt("conceptfilter", 0);
        boolean filterOption = curNode.getBoolean("filteroption", true);
        boolean relationCheck = curNode.getBoolean("relationcheck", true);
        boolean coreference = curNode.getBoolean("coreference", false);
        boolean coordinatingCheck = curNode.getBoolean("coordinatingcheck", false);
        boolean semanticCheck = curNode.getBoolean("semanticcheck", true);
        boolean clauseIdentify = curNode.getBoolean("clauseidentify", true);
        ConceptExtractorConfig extractorConfig = new ConceptExtractorConfig();
        TermExtractor extractor = (TermExtractor)extractorConfig.getConceptExtractor(curNode, extractorID);
        ConceptFilterConfig filterConfig = new ConceptFilterConfig();
        ConceptFilter filter = filterConfig.getConceptFilter(curNode, filterID);
        BasicTripleExtractor tripleExtractor = new BasicTripleExtractor(extractor);
        tripleExtractor.setConceptFilter(filter);
        tripleExtractor.setFilteringOption(filterOption);
        tripleExtractor.setCoordinatingCheckOption(coordinatingCheck);
        tripleExtractor.setRelationCheckOption(relationCheck);
        tripleExtractor.setSemanticCheckOption(semanticCheck);
        tripleExtractor.setCoReferenceOption(coreference);
        tripleExtractor.setClauseIdentifyOption(clauseIdentify);
        return tripleExtractor;
    }
}

