/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.matrix.DoubleFlatSparseMatrix;
import dragon.matrix.DoubleGiantSparseMatrix;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.DoubleSuperSparseMatrix;
import dragon.matrix.IntFlatSparseMatrix;
import dragon.matrix.IntGiantSparseMatrix;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.IntSuperSparseMatrix;

public class SparseMatrixConfig
extends ConfigUtil {
    public SparseMatrixConfig() {
    }

    public SparseMatrixConfig(ConfigureNode root) {
        super(root);
    }

    public SparseMatrixConfig(String configFile) {
        super(configFile);
    }

    public IntSparseMatrix getIntSparseMatrix(int matrixID) {
        return this.getIntSparseMatrix(this.root, matrixID);
    }

    public IntSparseMatrix getIntSparseMatrix(ConfigureNode node, int matrixID) {
        return this.loadIntSparseMatrix(node, matrixID);
    }

    private IntSparseMatrix loadIntSparseMatrix(ConfigureNode node, int matrixID) {
        ConfigureNode matrixNode = this.getConfigureNode(node, "intsparsematrix", matrixID);
        if (matrixNode == null) {
            return null;
        }
        String matrixName = matrixNode.getNodeName();
        return this.loadIntSparseMatrix(matrixName, matrixNode);
    }

    protected IntSparseMatrix loadIntSparseMatrix(String matrixName, ConfigureNode matrixNode) {
        if (matrixName.equalsIgnoreCase("IntSuperSparseMatrix")) {
            return this.loadIntSuperSparseMatrix(matrixNode);
        }
        if (matrixName.equalsIgnoreCase("IntGiantSparseMatrix")) {
            return this.loadIntGiantSparseMatrix(matrixNode);
        }
        if (matrixName.equalsIgnoreCase("IntFlatSparseMatrix")) {
            return this.loadIntFlatSparseMatrix(matrixNode);
        }
        return (IntSparseMatrix)this.loadResource(matrixNode);
    }

    private IntSparseMatrix loadIntFlatSparseMatrix(ConfigureNode node) {
        String filename = node.getString("filename", null);
        boolean binaryMode = node.getBoolean("binaryfile", false);
        boolean mergeMode = node.getBoolean("mergemode", false);
        boolean miniMode = node.getBoolean("minimode", false);
        if (filename != null) {
            return new IntFlatSparseMatrix(filename, binaryMode);
        }
        return new IntFlatSparseMatrix(mergeMode, miniMode);
    }

    private IntSparseMatrix loadIntSuperSparseMatrix(ConfigureNode node) {
        String path = node.getString("matrixpath");
        String key = node.getString("matrixkey");
        String matrixFile = path + "/" + key + ".matrix";
        String indexFile = path + "/" + key + ".index";
        if (node.exist("mergemode")) {
            return new IntSuperSparseMatrix(indexFile, matrixFile, node.getBoolean("mergemode", false), node.getBoolean("minimode", false));
        }
        return new IntSuperSparseMatrix(indexFile, matrixFile);
    }

    private IntSparseMatrix loadIntGiantSparseMatrix(ConfigureNode node) {
        String path = node.getString("matrixpath");
        String key = node.getString("matrixkey");
        String matrixFile = path + "/" + key + ".matrix";
        String indexFile = path + "/" + key + ".index";
        if (node.exist("mergemode")) {
            return new IntGiantSparseMatrix(indexFile, matrixFile, node.getBoolean("mergemode", false), node.getBoolean("minimode", false));
        }
        return new IntGiantSparseMatrix(indexFile, matrixFile);
    }

    public DoubleSparseMatrix getDoubleSparseMatrix(int matrixID) {
        return this.getDoubleSparseMatrix(this.root, matrixID);
    }

    public DoubleSparseMatrix getDoubleSparseMatrix(ConfigureNode node, int matrixID) {
        return this.loadDoubleSparseMatrix(node, matrixID);
    }

    private DoubleSparseMatrix loadDoubleSparseMatrix(ConfigureNode node, int matrixID) {
        ConfigureNode matrixNode = this.getConfigureNode(node, "doublesparsematrix", matrixID);
        if (matrixNode == null) {
            return null;
        }
        String matrixName = matrixNode.getNodeName();
        return this.loadDoubleSparseMatrix(matrixName, matrixNode);
    }

    protected DoubleSparseMatrix loadDoubleSparseMatrix(String matrixName, ConfigureNode matrixNode) {
        if (matrixName.equalsIgnoreCase("DoubleSuperSparseMatrix")) {
            return this.loadDoubleSuperSparseMatrix(matrixNode);
        }
        if (matrixName.equalsIgnoreCase("DoubleGiantSparseMatrix")) {
            return this.loadDoubleGiantSparseMatrix(matrixNode);
        }
        if (matrixName.equalsIgnoreCase("DoubleFlatSparseMatrix")) {
            return this.loadDoubleFlatSparseMatrix(matrixNode);
        }
        return (DoubleSparseMatrix)this.loadResource(matrixNode);
    }

    private DoubleSparseMatrix loadDoubleFlatSparseMatrix(ConfigureNode node) {
        String filename = node.getString("filename", null);
        boolean binaryMode = node.getBoolean("binaryfile", false);
        boolean mergeMode = node.getBoolean("mergemode", false);
        boolean miniMode = node.getBoolean("minimode", false);
        if (filename != null) {
            return new DoubleFlatSparseMatrix(filename, binaryMode);
        }
        return new DoubleFlatSparseMatrix(mergeMode, miniMode);
    }

    private DoubleSparseMatrix loadDoubleSuperSparseMatrix(ConfigureNode node) {
        String path = node.getString("matrixpath");
        String key = node.getString("matrixkey");
        String matrixFile = path + "/" + key + ".matrix";
        String indexFile = path + "/" + key + ".index";
        if (node.exist("mergemode")) {
            return new DoubleSuperSparseMatrix(indexFile, matrixFile, node.getBoolean("mergemode", false), node.getBoolean("minimode", false));
        }
        return new DoubleSuperSparseMatrix(indexFile, matrixFile);
    }

    private DoubleSparseMatrix loadDoubleGiantSparseMatrix(ConfigureNode node) {
        String path = node.getString("matrixpath");
        String key = node.getString("matrixkey");
        String matrixFile = path + "/" + key + ".matrix";
        String indexFile = path + "/" + key + ".index";
        if (node.exist("mergemode")) {
            return new DoubleGiantSparseMatrix(indexFile, matrixFile, node.getBoolean("mergemode", false), node.getBoolean("minimode", false));
        }
        return new DoubleGiantSparseMatrix(indexFile, matrixFile);
    }
}

