/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.SearcherConfig;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.query.RelSimpleQuery;
import dragon.ir.search.Searcher;
import dragon.ir.search.evaluate.TrecEva;
import dragon.nlp.SimpleElement;
import dragon.util.FileUtil;
import dragon.util.FormatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.TreeMap;

public class RetrievalEvaAppConfig {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and retrieval evaluation id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root = new BasicConfigureNode(args[0]);
        ConfigureNode retrievalAppNode = util.getConfigureNode(root, "retrievalevaapp", Integer.parseInt(args[1]));
        if (retrievalAppNode == null) {
            return;
        }
        RetrievalEvaAppConfig retrievalApp = new RetrievalEvaAppConfig();
        retrievalApp.evaluate(retrievalAppNode);
    }

    public void evaluate(ConfigureNode node) {
        ArrayList<Integer> excludedQueries;
        SearcherConfig config = new SearcherConfig();
        int searcherID = node.getInt("searcher", 0);
        if (searcherID <= 0) {
            return;
        }
        Searcher searcher = config.getSearcher(node, searcherID);
        String judgmentFile = node.getString("judgmentfile", null);
        String queryFile = node.getString("queryfile", null);
        String resultFolder = node.getString("resultfolder", null);
        if (judgmentFile == null || queryFile == null || resultFolder == null) {
            return;
        }
        int start = node.getInt("startopic", -1);
        int end = node.getInt("endtopic", -1);
        String excludedTopics = node.getString("excludedtopics", null);
        if (excludedTopics == null || excludedTopics.trim().length() == 0) {
            excludedQueries = null;
        } else {
            String[] arrTopic = excludedTopics.trim().split(";");
            excludedQueries = new ArrayList<Integer>(arrTopic.length);
            for (int i = 0; i < arrTopic.length; ++i) {
                excludedQueries.add(new Integer(arrTopic[i]));
            }
        }
        this.evaluate(searcher, judgmentFile, queryFile, resultFolder, start, end, excludedQueries);
    }

    public void evaluate(Searcher searcher, String judgmentFile, String queryFile, String outputFolder, int start, int end, ArrayList excludedQueries) {
        try {
            int i;
            new File(outputFolder).mkdirs();
            SimpleElement[] arrQuery = this.readQuery(queryFile);
            TreeMap arrRelevant = this.loadJudgmentFile(searcher.getIndexReader(), judgmentFile);
            TrecEva eva = new TrecEva(outputFolder);
            double[] resultSum = new double[10];
            for (i = 0; i < 10; ++i) {
                resultSum[i] = 0.0;
            }
            DecimalFormat df = FormatUtil.getNumericFormat(2, 2);
            int total = 0;
            PrintWriter out = FileUtil.getPrintWriter(outputFolder + "/all.eva");
            out.write("Query\tRetrieved\tRelevant\tP@10\tR@10\tP@100\tR@100\tP\tR\tAP\r\n");
            for (i = 0; i < arrQuery.length; ++i) {
                ArrayList list;
                int queryNo = arrQuery[i].getIndex();
                if (queryNo < start && start >= 0 || queryNo > end && end >= 0 || (list = (ArrayList)arrRelevant.get(new Integer(queryNo))) == null || list.size() == 0 || excludedQueries != null && excludedQueries.contains(new Integer(queryNo))) continue;
                ++total;
                System.out.print("Processing Query #" + queryNo);
                RelSimpleQuery irQuery = new RelSimpleQuery(arrQuery[i].getKey());
                irQuery.setQueryKey(queryNo);
                searcher.search(irQuery);
                double[] result = eva.evaluateQuery(irQuery, searcher.getRankedDocumentList(), list, searcher.getIndexReader());
                this.printEvaStat(result, out);
                System.out.print(" " + df.format(result[9]) + "%\n");
                for (int j = 0; j < 10; ++j) {
                    int n = j;
                    resultSum[n] = resultSum[n] + result[j];
                }
            }
            for (i = 0; i < 10; ++i) {
                resultSum[i] = resultSum[i] / (double)total;
            }
            System.out.println("MAP:  " + df.format(resultSum[9]) + "%");
            System.out.println("P@10: " + df.format(resultSum[3]) + "%");
            System.out.println("P@100:" + df.format(resultSum[5]) + "%");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printEvaStat(double[] result, PrintWriter out) {
        try {
            int i;
            DecimalFormat df = FormatUtil.getNumericFormat(2, 2);
            DecimalFormat dfInteger = FormatUtil.getNumericFormat(0, 0);
            for (i = 0; i < 3; ++i) {
                if (i > 0) {
                    out.write(9);
                }
                out.write(dfInteger.format(result[i]));
            }
            for (i = 3; i <= 9; ++i) {
                out.write(9);
                out.write(df.format(result[i]));
            }
            out.write("\r\n");
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SimpleElement[] readQuery(String queryFile) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(queryFile)));
            String line = br.readLine();
            int total = Integer.parseInt(line);
            SimpleElement[] arrQuery = new SimpleElement[total];
            int count = 0;
            while ((line = br.readLine()) != null) {
                int j = line.indexOf(9);
                int lineNo = Integer.parseInt(line.substring(0, j));
                arrQuery[count] = new SimpleElement(line.substring(j + 1), lineNo);
                ++count;
            }
            br.close();
            return arrQuery;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private TreeMap loadJudgmentFile(IndexReader reader, String filename) {
        try {
            String line;
            TreeMap<Integer, ArrayList<IRDoc>> arrRelevant = new TreeMap<Integer, ArrayList<IRDoc>>();
            int count = 0;
            BufferedReader br = FileUtil.getTextReader(filename);
            while ((line = br.readLine()) != null) {
                IRDoc cur;
                ++count;
                int start = line.indexOf(9);
                int end = line.indexOf(9, start + 1);
                int topicID = Integer.parseInt(line.substring(0, start));
                String pmid = line.substring(start + 1, end);
                int relevance = Integer.parseInt(line.substring(end + 1));
                if (relevance <= 0 || relevance >= 3 || (cur = reader.getDoc(pmid)) == null) continue;
                ArrayList<IRDoc> list = (ArrayList<IRDoc>)arrRelevant.get(new Integer(topicID));
                if (list == null) {
                    list = new ArrayList<IRDoc>();
                    arrRelevant.put(new Integer(topicID), list);
                }
                list.add(cur);
            }
            return arrRelevant;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

