/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConceptExtractorConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.KnowledgeBaseConfig;
import dragon.config.TripleExtractorConfig;
import dragon.ir.kngbase.KnowledgeBase;
import dragon.ir.query.BasicQueryGenerator;
import dragon.ir.query.PhraseQEGenerator;
import dragon.ir.query.QueryGenerator;
import dragon.nlp.extract.PhraseExtractor;
import dragon.nlp.extract.TokenExtractor;

public class QueryGeneratorConfig
extends ConfigUtil {
    public QueryGeneratorConfig() {
    }

    public QueryGeneratorConfig(ConfigureNode root) {
        super(root);
    }

    public QueryGeneratorConfig(String configFile) {
        super(configFile);
    }

    public QueryGenerator getQueryGenerator(int queryGeneratorID) {
        return this.getQueryGenerator(this.root, queryGeneratorID);
    }

    public QueryGenerator getQueryGenerator(ConfigureNode node, int queryGeneratorID) {
        return this.loadQueryGenerator(node, queryGeneratorID);
    }

    private QueryGenerator loadQueryGenerator(ConfigureNode node, int queryGeneratorID) {
        ConfigureNode queryGeneratorNode = this.getConfigureNode(node, "queryGenerator", queryGeneratorID);
        if (queryGeneratorNode == null) {
            return null;
        }
        String queryGeneratorName = queryGeneratorNode.getNodeName();
        return this.loadQueryGenerator(queryGeneratorName, queryGeneratorNode);
    }

    protected QueryGenerator loadQueryGenerator(String queryGeneratorName, ConfigureNode queryGeneratorNode) {
        if (queryGeneratorName.equalsIgnoreCase("BasicQueryGenerator")) {
            return this.loadBasicQueryGenerator(queryGeneratorNode);
        }
        if (queryGeneratorName.equalsIgnoreCase("PhraseQEGenerator")) {
            return this.loadPhraseQEGenerator(queryGeneratorNode);
        }
        return (QueryGenerator)this.loadResource(queryGeneratorNode);
    }

    private QueryGenerator loadBasicQueryGenerator(ConfigureNode node) {
        BasicQueryGenerator generator = null;
        boolean useConcept = node.getBoolean("useconcept", false);
        int tripleExtractorID = node.getInt("tripleextractor", 0);
        if (tripleExtractorID <= 0) {
            int conceptExtractorID = node.getInt("conceptextractor");
            generator = new BasicQueryGenerator(new ConceptExtractorConfig().getConceptExtractor(node, conceptExtractorID), useConcept);
        } else {
            generator = new BasicQueryGenerator(new TripleExtractorConfig().getTripleExtractor(node, tripleExtractorID), useConcept);
        }
        double title = node.getDouble("titleweight", 0.0);
        double body = node.getDouble("bodyweight", 0.0);
        double abt = node.getDouble("abstractweight", 0.0);
        double meta = node.getDouble("metaweight", 0.0);
        double subterm = node.getDouble("subterm", 1.0);
        generator.initialize(title, abt, body, meta, subterm);
        return generator;
    }

    private QueryGenerator loadPhraseQEGenerator(ConfigureNode node) {
        PhraseQEGenerator generator;
        boolean useTitle = node.getBoolean("usetitle", true);
        boolean useAbstract = node.getBoolean("useabstract", false);
        boolean useBody = node.getBoolean("usebody", false);
        boolean useMeta = node.getBoolean("usemeta", false);
        int expandTermNum = node.getInt("expandtermnum", 10);
        double transCoefficient = node.getDouble("transcoefficient", 0.5);
        int tokenExtractorID = node.getInt("tokenextractor");
        int phraseExtractorID = node.getInt("phraseextractor");
        int kngBaseID = node.getInt("knowledgebase");
        KnowledgeBase kngBase = new KnowledgeBaseConfig().getKnowledgeBase(node, kngBaseID);
        TokenExtractor tokenExtractor = (TokenExtractor)new ConceptExtractorConfig().getConceptExtractor(node, tokenExtractorID);
        if (phraseExtractorID > 0) {
            PhraseExtractor phraseExtractor = (PhraseExtractor)new ConceptExtractorConfig().getConceptExtractor(node, phraseExtractorID);
            generator = new PhraseQEGenerator(kngBase, phraseExtractor, tokenExtractor, transCoefficient, expandTermNum);
        } else {
            generator = new PhraseQEGenerator(kngBase, tokenExtractor, transCoefficient, expandTermNum);
        }
        generator.initialize(useTitle, useAbstract, useBody, useMeta);
        return generator;
    }
}

