/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.LemmatiserConfig;
import dragon.nlp.ontology.BasicOntology;
import dragon.nlp.ontology.Ontology;
import dragon.nlp.ontology.umls.UmlsAmbiguityOntology;
import dragon.nlp.ontology.umls.UmlsFileBackedOntology;
import dragon.nlp.tool.Lemmatiser;

public class OntologyConfig
extends ConfigUtil {
    public OntologyConfig() {
    }

    public OntologyConfig(ConfigureNode root) {
        super(root);
    }

    public OntologyConfig(String configFile) {
        super(configFile);
    }

    public Ontology getOntology(int taggerID) {
        return this.getOntology(this.root, taggerID);
    }

    public Ontology getOntology(ConfigureNode node, int ontologyID) {
        return this.loadOntology(node, ontologyID);
    }

    private Ontology loadOntology(ConfigureNode node, int ontologyID) {
        ConfigureNode ontologyNode = this.getConfigureNode(node, "ontology", ontologyID);
        if (ontologyNode == null) {
            return null;
        }
        String ontologyName = ontologyNode.getNodeName();
        return this.loadOntology(ontologyName, node, ontologyNode);
    }

    protected Ontology loadOntology(String ontologyName, ConfigureNode node, ConfigureNode ontologyNode) {
        if (ontologyName.equalsIgnoreCase("BasicOntology")) {
            return this.loadBasicOntology(ontologyNode);
        }
        if (ontologyName.equalsIgnoreCase("UmlsExactOntology")) {
            return this.loadUmlsExactOntology(ontologyNode);
        }
        if (ontologyName.equalsIgnoreCase("UmlsAmbiguityOntology")) {
            return this.loadUmlsAmbiguityOntology(ontologyNode);
        }
        return (Ontology)this.loadResource(ontologyNode);
    }

    private Ontology loadBasicOntology(ConfigureNode curNode) {
        String termFile = curNode.getString("termfile");
        int lemmatiserID = curNode.getInt("lemmatiser", 0);
        boolean lemmaOption = curNode.getBoolean("lemmaoption", false);
        boolean nppOption = curNode.getBoolean("nppoption", false);
        boolean coordinateOption = curNode.getBoolean("coordinateoption", false);
        boolean adjtermOption = curNode.getBoolean("adjtermoption", false);
        boolean senseOption = curNode.getBoolean("sensedisambiguation", false);
        String nonBoundaryPunc = curNode.getString("nonboundarypunctuation", "");
        LemmatiserConfig lemmaConfig = new LemmatiserConfig();
        Lemmatiser lemmatiser = lemmaConfig.getLemmatiser(curNode, lemmatiserID);
        BasicOntology ontology = new BasicOntology(termFile, lemmatiser);
        ontology.setLemmaOption(lemmaOption);
        ontology.setAdjectiveTermOption(adjtermOption);
        ontology.setCoordinateOption(coordinateOption);
        ontology.setNPPOption(nppOption);
        ontology.setSenseDisambiguationOption(senseOption);
        ontology.setNonBoundaryPunctuation(nonBoundaryPunc);
        return ontology;
    }

    private Ontology loadUmlsExactOntology(ConfigureNode vobNode) {
        String directory = vobNode.getString("directory", null);
        int lemmatiserID = vobNode.getInt("lemmatiser", 0);
        boolean lemmaOption = vobNode.getBoolean("lemmaoption", false);
        boolean nppOption = vobNode.getBoolean("nppoption", false);
        boolean coordinateOption = vobNode.getBoolean("coordinateoption", false);
        boolean adjtermOption = vobNode.getBoolean("adjtermoption", false);
        boolean senseOption = vobNode.getBoolean("sensedisambiguation", false);
        String nonBoundaryPunc = vobNode.getString("nonboundarypunctuation", "");
        LemmatiserConfig lemmaConfig = new LemmatiserConfig();
        Lemmatiser lemmatiser = lemmaConfig.getLemmatiser(vobNode, lemmatiserID);
        UmlsFileBackedOntology ontology = directory == null ? new UmlsFileBackedOntology(lemmatiser) : new UmlsFileBackedOntology(directory, lemmatiser);
        ontology.setLemmaOption(lemmaOption);
        ontology.setAdjectiveTermOption(adjtermOption);
        ontology.setCoordinateOption(coordinateOption);
        ontology.setNPPOption(nppOption);
        ontology.setSenseDisambiguationOption(senseOption);
        ontology.setNonBoundaryPunctuation(nonBoundaryPunc);
        return ontology;
    }

    private Ontology loadUmlsAmbiguityOntology(ConfigureNode vobNode) {
        String directory = vobNode.getString("directory", null);
        int lemmatiserID = vobNode.getInt("lemmatiser", 0);
        boolean lemmaOption = vobNode.getBoolean("lemmaoption", false);
        boolean nppOption = vobNode.getBoolean("nppoption", false);
        boolean coordinateOption = vobNode.getBoolean("coordinateoption", false);
        boolean adjtermOption = vobNode.getBoolean("adjtermoption", false);
        boolean senseOption = vobNode.getBoolean("sensedisambiguation", false);
        String nonBoundaryPunc = vobNode.getString("nonboundarypunctuation", "");
        double minScore = vobNode.getDouble("minscore", 0.95);
        double minSelectivity = vobNode.getDouble("minselectivity", 0.0);
        int maxSkippedWord = vobNode.getInt("maxskippedword", 1);
        LemmatiserConfig lemmaConfig = new LemmatiserConfig();
        Lemmatiser lemmatiser = lemmaConfig.getLemmatiser(vobNode, lemmatiserID);
        UmlsAmbiguityOntology ontology = directory == null ? new UmlsAmbiguityOntology(lemmatiser) : new UmlsAmbiguityOntology(directory, lemmatiser);
        ontology.setLemmaOption(lemmaOption);
        ontology.setAdjectiveTermOption(adjtermOption);
        ontology.setCoordinateOption(coordinateOption);
        ontology.setNPPOption(nppOption);
        ontology.setSenseDisambiguationOption(senseOption);
        ontology.setNonBoundaryPunctuation(nonBoundaryPunc);
        ontology.setMinScore(minScore);
        ontology.setMinSelectivity(minSelectivity);
        ontology.setMaxSkippedWords(maxSkippedWord);
        return ontology;
    }
}

