/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.nlp.tool.Annie;
import dragon.nlp.tool.NER;

public class NERConfig
extends ConfigUtil {
    public NERConfig() {
    }

    public NERConfig(ConfigureNode root) {
        super(root);
    }

    public NERConfig(String configFile) {
        super(configFile);
    }

    public NER getNER(int taggerID) {
        return this.getNER(this.root, taggerID);
    }

    public NER getNER(ConfigureNode node, int nerID) {
        return this.loadNER(node, nerID);
    }

    private NER loadNER(ConfigureNode node, int nerID) {
        ConfigureNode nerNode = this.getConfigureNode(node, "ner", nerID);
        if (nerNode == null) {
            return null;
        }
        String nerName = nerNode.getNodeName();
        return this.loadNER(nerName, nerNode);
    }

    protected NER loadNER(String nerName, ConfigureNode nerNode) {
        if (nerName.equalsIgnoreCase("Annie")) {
            return this.loadAnnie(nerNode);
        }
        return (NER)this.loadResource(nerNode);
    }

    private Annie loadAnnie(ConfigureNode curNode) {
        try {
            String gateHome = curNode.getString("gatehome", null);
            String annotationTypes = curNode.getString("entitytypes", "Person;Location;Organization");
            Annie ner = gateHome == null ? new Annie() : new Annie(gateHome);
            ner.setAnnotationTypes(annotationTypes.split(";"));
            return ner;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

