/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.PorterStemmer;
import dragon.nlp.tool.WordNetDidion;
import dragon.nlp.tool.lemmatiser.EngLemmatiser;

public class LemmatiserConfig
extends ConfigUtil {
    public LemmatiserConfig() {
    }

    public LemmatiserConfig(ConfigureNode root) {
        super(root);
    }

    public LemmatiserConfig(String configFile) {
        super(configFile);
    }

    public Lemmatiser getLemmatiser(int lemmatiserID) {
        return this.getLemmatiser(this.root, lemmatiserID);
    }

    public Lemmatiser getLemmatiser(ConfigureNode node, int lemmatiserID) {
        return this.loadLemmatiser(node, lemmatiserID);
    }

    private Lemmatiser loadLemmatiser(ConfigureNode node, int lemmatiserID) {
        ConfigureNode lemmatiserNode = this.getConfigureNode(node, "lemmatiser", lemmatiserID);
        if (lemmatiserNode == null) {
            return null;
        }
        String lemmatiserName = lemmatiserNode.getNodeName();
        return this.loadLemmatiser(lemmatiserName, lemmatiserNode);
    }

    protected Lemmatiser loadLemmatiser(String lemmatiserName, ConfigureNode lemmatiserNode) {
        if (lemmatiserName.equalsIgnoreCase("PorterStemmer")) {
            return new PorterStemmer();
        }
        if (lemmatiserName.equalsIgnoreCase("WordNetDidion")) {
            return this.loadWordNetDidion(lemmatiserNode);
        }
        if (lemmatiserName.equalsIgnoreCase("EngLemmatiser")) {
            return this.loadEngLemmatiser(lemmatiserNode);
        }
        return (Lemmatiser)this.loadResource(lemmatiserNode);
    }

    private Lemmatiser loadEngLemmatiser(ConfigureNode node) {
        boolean indexLookupOption = false;
        boolean disableVerbAdjective = true;
        String directory = node.getString("directory", null);
        indexLookupOption = node.getBoolean("indexlookupoption", indexLookupOption);
        disableVerbAdjective = node.getBoolean("disableverbadjective", disableVerbAdjective);
        if (directory == null) {
            return new EngLemmatiser(indexLookupOption, disableVerbAdjective);
        }
        return new EngLemmatiser(directory, indexLookupOption, disableVerbAdjective);
    }

    private Lemmatiser loadWordNetDidion(ConfigureNode node) {
        String directory = node.getString("directory", null);
        if (directory == null) {
            return new WordNetDidion();
        }
        return new WordNetDidion(directory);
    }
}

