/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConceptExtractorConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.DualConceptExtractorConfig;
import dragon.config.TripleExtractorConfig;
import dragon.ir.index.BasicIndexer;
import dragon.ir.index.DualIndexer;
import dragon.ir.index.Indexer;
import dragon.ir.index.OnlineIndexer;
import dragon.ir.index.sentence.BasicSentenceIndexer;
import dragon.ir.index.sentence.DualSentenceIndexer;
import dragon.ir.index.sentence.OnlineSentenceIndexer;
import dragon.ir.index.sequence.BasicSequenceIndexer;
import dragon.ir.index.sequence.OnlineSequenceIndexer;
import dragon.nlp.extract.ConceptExtractor;
import dragon.nlp.extract.DualConceptExtractor;
import dragon.nlp.extract.TokenExtractor;
import dragon.nlp.extract.TripleExtractor;

public class IndexerConfig
extends ConfigUtil {
    public IndexerConfig() {
    }

    public IndexerConfig(ConfigureNode root) {
        super(root);
    }

    public IndexerConfig(String configFile) {
        super(configFile);
    }

    public Indexer getIndexer(int indexerID) {
        return this.getIndexer(this.root, indexerID);
    }

    public Indexer getIndexer(ConfigureNode node, int indexerID) {
        return this.loadIndexer(node, indexerID);
    }

    private Indexer loadIndexer(ConfigureNode node, int indexerID) {
        ConfigureNode indexerNode = this.getConfigureNode(node, "indexer", indexerID);
        if (indexerNode == null) {
            return null;
        }
        String indexerName = indexerNode.getNodeName();
        return this.loadIndexer(indexerName, indexerNode);
    }

    protected Indexer loadIndexer(String indexerName, ConfigureNode indexerNode) {
        if (indexerName.equalsIgnoreCase("BasicIndexer")) {
            return this.loadBasicIndexer(indexerNode);
        }
        if (indexerName.equalsIgnoreCase("OnlineIndexer")) {
            return this.loadOnlineIndexer(indexerNode);
        }
        if (indexerName.equalsIgnoreCase("BasicSequenceIndexer")) {
            return this.loadBasicSequenceIndexer(indexerNode);
        }
        if (indexerName.equalsIgnoreCase("OnlineSequenceIndexer")) {
            return this.loadOnlineSequenceIndexer(indexerNode);
        }
        if (indexerName.equalsIgnoreCase("OnlineSentenceIndexer")) {
            return this.loadOnlineSentenceIndexer(indexerNode);
        }
        if (indexerName.equalsIgnoreCase("BasicSentenceIndexer")) {
            return this.loadBasicSentenceIndexer(indexerNode);
        }
        if (indexerName.equalsIgnoreCase("DualSentenceIndexer")) {
            return this.loadDualSentenceIndexer(indexerNode);
        }
        if (indexerName.equalsIgnoreCase("DualIndexer")) {
            return this.loadDualIndexer(indexerNode);
        }
        return (Indexer)this.loadResource(indexerNode);
    }

    private Indexer loadBasicIndexer(ConfigureNode curNode) {
        BasicIndexer indexer;
        String charIndexFolder = curNode.getString("characterindexfolder", null);
        String cptIndexFolder = curNode.getString("conceptindexfolder", null);
        int extractorID = curNode.getInt("conceptextractor", -1);
        if (extractorID >= 0) {
            ConceptExtractorConfig cptConfig = new ConceptExtractorConfig();
            ConceptExtractor ce = cptConfig.getConceptExtractor(curNode, extractorID);
            indexer = new BasicIndexer(ce, charIndexFolder, cptIndexFolder);
        } else {
            extractorID = curNode.getInt("tripleextractor", -1);
            if (extractorID < 0) {
                return null;
            }
            TripleExtractorConfig tripleConfig = new TripleExtractorConfig();
            TripleExtractor te = tripleConfig.getTripleExtractor(curNode, extractorID);
            indexer = new BasicIndexer(te, charIndexFolder, cptIndexFolder);
        }
        String logFile = curNode.getString("logfile", null);
        if (logFile != null) {
            indexer.setLog(logFile);
        }
        boolean indexAll = curNode.getBoolean("indexall", true);
        boolean indexTitle = curNode.getBoolean("indextitle", false);
        boolean indexAbstract = curNode.getBoolean("indexabstract", false);
        boolean indexBody = curNode.getBoolean("indexbody", false);
        boolean indexMeta = curNode.getBoolean("indexmeta", false);
        indexer.setSectionIndexOption(indexAll, indexTitle, indexAbstract, indexBody, indexMeta);
        indexer.initialize();
        return indexer;
    }

    private Indexer loadOnlineIndexer(ConfigureNode curNode) {
        OnlineIndexer indexer;
        boolean useConcept = curNode.getBoolean("indexconceptentry", false);
        int extractorID = curNode.getInt("conceptextractor", -1);
        if (extractorID >= 0) {
            ConceptExtractorConfig cptConfig = new ConceptExtractorConfig();
            ConceptExtractor ce = cptConfig.getConceptExtractor(curNode, extractorID);
            indexer = new OnlineIndexer(ce, useConcept);
        } else {
            extractorID = curNode.getInt("tripleextractor", -1);
            if (extractorID < 0) {
                return null;
            }
            TripleExtractorConfig tripleConfig = new TripleExtractorConfig();
            TripleExtractor te = tripleConfig.getTripleExtractor(curNode, extractorID);
            indexer = new OnlineIndexer(te, useConcept);
        }
        boolean indexTitle = curNode.getBoolean("indextitle", true);
        boolean indexAbstract = curNode.getBoolean("indexabstract", true);
        boolean indexBody = curNode.getBoolean("indexbody", true);
        boolean indexMeta = curNode.getBoolean("indexmeta", true);
        indexer.screenArticleContent(indexTitle, indexAbstract, indexBody, indexMeta);
        indexer.initialize();
        return indexer;
    }

    private Indexer loadDualIndexer(ConfigureNode curNode) {
        String firstIndexFolder = curNode.getString("firstindexfolder");
        String secondIndexFolder = curNode.getString("secondindexfolder");
        int extractorID = curNode.getInt("dualconceptextractor");
        DualConceptExtractor ce = new DualConceptExtractorConfig().getDualConceptExtractor(curNode, extractorID);
        boolean firstUseConcept = curNode.getBoolean("firstindexconceptentry", false);
        boolean secondUseConcept = curNode.getBoolean("secondindexconceptentry", false);
        DualIndexer indexer = new DualIndexer(ce, firstUseConcept, firstIndexFolder, secondUseConcept, secondIndexFolder);
        String logFile = curNode.getString("logfile", null);
        if (logFile != null) {
            indexer.setLog(logFile);
        }
        indexer.initialize();
        return indexer;
    }

    private Indexer loadBasicSentenceIndexer(ConfigureNode curNode) {
        BasicSentenceIndexer indexer;
        boolean useConcept;
        String indexFolder = curNode.getString("characterindexfolder", null);
        if (indexFolder != null) {
            useConcept = false;
        } else {
            indexFolder = curNode.getString("conceptindexfolder", null);
            if (indexFolder == null) {
                return null;
            }
            useConcept = true;
        }
        int extractorID = curNode.getInt("conceptextractor", -1);
        if (extractorID >= 0) {
            ConceptExtractorConfig cptConfig = new ConceptExtractorConfig();
            ConceptExtractor ce = cptConfig.getConceptExtractor(curNode, extractorID);
            indexer = new BasicSentenceIndexer(ce, useConcept, indexFolder);
        } else {
            extractorID = curNode.getInt("tripleextractor", -1);
            if (extractorID < 0) {
                return null;
            }
            TripleExtractorConfig tripleConfig = new TripleExtractorConfig();
            TripleExtractor te = tripleConfig.getTripleExtractor(curNode, extractorID);
            indexer = new BasicSentenceIndexer(te, useConcept, indexFolder);
        }
        String logFile = curNode.getString("logfile", null);
        if (logFile != null) {
            indexer.setLog(logFile);
        }
        boolean indexTitle = curNode.getBoolean("indextitle", true);
        boolean indexAbstract = curNode.getBoolean("indexabstract", true);
        boolean indexBody = curNode.getBoolean("indexbody", true);
        indexer.screenArticleContent(indexTitle, indexAbstract, indexBody);
        indexer.initialize();
        indexer.setMinSentenceLength(curNode.getInt("minsentencelength", 1));
        return indexer;
    }

    private Indexer loadOnlineSentenceIndexer(ConfigureNode curNode) {
        OnlineSentenceIndexer indexer;
        boolean useConcept = curNode.getBoolean("indexconceptentry", false);
        int extractorID = curNode.getInt("conceptextractor", -1);
        if (extractorID >= 0) {
            ConceptExtractorConfig cptConfig = new ConceptExtractorConfig();
            ConceptExtractor ce = cptConfig.getConceptExtractor(curNode, extractorID);
            indexer = new OnlineSentenceIndexer(ce, useConcept);
        } else {
            extractorID = curNode.getInt("tripleextractor", -1);
            if (extractorID < 0) {
                return null;
            }
            TripleExtractorConfig tripleConfig = new TripleExtractorConfig();
            TripleExtractor te = tripleConfig.getTripleExtractor(curNode, extractorID);
            indexer = new OnlineSentenceIndexer(te, useConcept);
        }
        boolean indexTitle = curNode.getBoolean("indextitle", true);
        boolean indexAbstract = curNode.getBoolean("indexabstract", true);
        boolean indexBody = curNode.getBoolean("indexbody", true);
        indexer.screenArticleContent(indexTitle, indexAbstract, indexBody);
        indexer.initialize();
        indexer.setMinSentenceLength(curNode.getInt("minsentencelength", 1));
        return indexer;
    }

    private Indexer loadDualSentenceIndexer(ConfigureNode curNode) {
        String firstIndexFolder = curNode.getString("firstindexfolder");
        String secondIndexFolder = curNode.getString("secondindexfolder");
        int extractorID = curNode.getInt("dualconceptextractor");
        DualConceptExtractor ce = new DualConceptExtractorConfig().getDualConceptExtractor(curNode, extractorID);
        boolean firstUseConcept = curNode.getBoolean("firstindexconceptentry", false);
        boolean secondUseConcept = curNode.getBoolean("secondindexconceptentry", false);
        DualSentenceIndexer indexer = new DualSentenceIndexer(ce, firstUseConcept, firstIndexFolder, secondUseConcept, secondIndexFolder);
        String logFile = curNode.getString("logfile", null);
        if (logFile != null) {
            indexer.setLog(logFile);
        }
        indexer.initialize();
        return indexer;
    }

    private Indexer loadBasicSequenceIndexer(ConfigureNode curNode) {
        int extractorID = curNode.getInt("conceptextractor");
        ConceptExtractorConfig cptConfig = new ConceptExtractorConfig();
        TokenExtractor te = (TokenExtractor)cptConfig.getConceptExtractor(curNode, extractorID);
        String indexFolder = curNode.getString("characterindexfolder");
        BasicSequenceIndexer indexer = new BasicSequenceIndexer(te, indexFolder);
        String logFile = curNode.getString("logfile", null);
        if (logFile != null) {
            indexer.setLog(logFile);
        }
        boolean indexTitle = curNode.getBoolean("indextitle", false);
        boolean indexAbstract = curNode.getBoolean("indexabstract", false);
        boolean indexBody = curNode.getBoolean("indexbody", false);
        boolean indexMeta = curNode.getBoolean("indexmeta", false);
        indexer.setSectionIndexOption(indexTitle, indexAbstract, indexBody, indexMeta);
        indexer.initialize();
        return indexer;
    }

    private Indexer loadOnlineSequenceIndexer(ConfigureNode curNode) {
        int extractorID = curNode.getInt("conceptextractor");
        ConceptExtractorConfig cptConfig = new ConceptExtractorConfig();
        TokenExtractor te = (TokenExtractor)cptConfig.getConceptExtractor(curNode, extractorID);
        OnlineSequenceIndexer indexer = new OnlineSequenceIndexer(te);
        boolean indexTitle = curNode.getBoolean("indextitle", false);
        boolean indexAbstract = curNode.getBoolean("indexabstract", false);
        boolean indexBody = curNode.getBoolean("indexbody", false);
        boolean indexMeta = curNode.getBoolean("indexmeta", false);
        indexer.setSectionIndexOption(indexTitle, indexAbstract, indexBody, indexMeta);
        indexer.initialize();
        return indexer;
    }
}

