/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.CollectionReaderConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.IndexerConfig;
import dragon.ir.index.Indexer;
import dragon.onlinedb.Article;
import dragon.onlinedb.CollectionReader;
import java.util.Date;

public class IndexAppConfig {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and indexing applicaiton id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root = new BasicConfigureNode(args[0]);
        ConfigureNode indexAppNode = util.getConfigureNode(root, "indexapp", Integer.parseInt(args[1]));
        if (indexAppNode == null) {
            return;
        }
        IndexAppConfig indexApp = new IndexAppConfig();
        indexApp.indexCollection(indexAppNode);
    }

    public void indexCollection(ConfigureNode indexAppNode) {
        CollectionReaderConfig collectionConfig = new CollectionReaderConfig();
        IndexerConfig indexerConfig = new IndexerConfig();
        boolean useMeta = indexAppNode.getBoolean("usemeta", false);
        int indexerID = indexAppNode.getInt("indexer", -1);
        if (indexerID < 0) {
            return;
        }
        Indexer indexer = indexerConfig.getIndexer(indexAppNode, indexerID);
        if (indexer == null) {
            return;
        }
        String collectionIDs = indexAppNode.getString("collectionreader", null);
        if (collectionIDs == null) {
            return;
        }
        String[] arrCollection = collectionIDs.split(";");
        CollectionReader[] arrCollectionReader = new CollectionReader[arrCollection.length];
        for (int i = 0; i < arrCollection.length; ++i) {
            arrCollectionReader[i] = collectionConfig.getCollectionReader(indexAppNode, Integer.parseInt(arrCollection[i]));
        }
        this.indexCollection(indexer, arrCollectionReader, useMeta);
    }

    public void indexCollection(Indexer indexer, CollectionReader[] arrCollectionReader, boolean useMeta) {
        try {
            for (int i = 0; i < arrCollectionReader.length; ++i) {
                Article article = arrCollectionReader[i].getNextArticle();
                while (article != null) {
                    if (!indexer.indexed(article.getKey())) {
                        System.out.print(new Date().toString() + " Indexing article #" + article.getKey() + ": ");
                        if (!useMeta) {
                            article.setMeta(null);
                        }
                        if (!indexer.index(article)) {
                            System.out.println("failed");
                        } else {
                            System.out.println("successful");
                        }
                    }
                    article = arrCollectionReader[i].getNextArticle();
                }
                arrCollectionReader[i].close();
            }
            indexer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            indexer.close();
        }
    }
}

