/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConceptExtractorConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.IndexReaderConfig;
import dragon.config.SearcherConfig;
import dragon.config.SparseMatrixConfig;
import dragon.ir.index.IndexReader;
import dragon.ir.search.Searcher;
import dragon.ir.search.feedback.Feedback;
import dragon.ir.search.feedback.GenerativeFeedback;
import dragon.ir.search.feedback.InformationFlowFeedback;
import dragon.ir.search.feedback.PhraseTransFeedback;
import dragon.ir.search.feedback.RelationTransFeedback;
import dragon.ir.search.feedback.RocchioFeedback;
import dragon.matrix.DoubleSparseMatrix;
import dragon.nlp.extract.TokenExtractor;

public class FeedbackConfig
extends ConfigUtil {
    public FeedbackConfig() {
    }

    public FeedbackConfig(ConfigureNode root) {
        super(root);
    }

    public FeedbackConfig(String configFile) {
        super(configFile);
    }

    public Feedback getFeedback(int feedbackID) {
        return this.getFeedback(this.root, feedbackID);
    }

    public Feedback getFeedback(ConfigureNode node, int feedbackID) {
        return this.loadFeedback(node, feedbackID);
    }

    private Feedback loadFeedback(ConfigureNode node, int feedbackID) {
        ConfigureNode feedbackNode = this.getConfigureNode(node, "feedback", feedbackID);
        if (feedbackNode == null) {
            return null;
        }
        String feedbackName = feedbackNode.getNodeName();
        return this.loadFeedback(feedbackName, feedbackNode);
    }

    protected Feedback loadFeedback(String feedbackName, ConfigureNode feedbackNode) {
        if (feedbackName.equalsIgnoreCase("GenerativeFeedback")) {
            return this.loadGenerativeFeedback(feedbackNode);
        }
        if (feedbackName.equalsIgnoreCase("MinDivergence")) {
            return this.loadMinDivergenceFeedback(feedbackNode);
        }
        if (feedbackName.equalsIgnoreCase("RocchioFeedback")) {
            return this.loadRocchioFeedback(feedbackNode);
        }
        if (feedbackName.equalsIgnoreCase("InformationFlowFeedback")) {
            return this.loadInformationFlowFeedback(feedbackNode);
        }
        if (feedbackName.equalsIgnoreCase("RelationTransFeedback")) {
            return this.loadRelationTransFeedback(feedbackNode);
        }
        if (feedbackName.equalsIgnoreCase("PhraseTransFeedback")) {
            return this.loadPhraseTransFeedback(feedbackNode);
        }
        return (Feedback)this.loadResource(feedbackNode);
    }

    private Feedback loadGenerativeFeedback(ConfigureNode node) {
        int feedbackDocNum = node.getInt("feedbackdocnum", 10);
        int expandTermNum = node.getInt("expandtermnum", 10);
        double feedbackCoefficient = node.getDouble("feedbackcoefficient", 0.6);
        double bkgCoefficient = node.getDouble("bkgcoefficient", 0.5);
        return new GenerativeFeedback(this.getSearcher(node), feedbackDocNum, expandTermNum, feedbackCoefficient, bkgCoefficient);
    }

    private Feedback loadMinDivergenceFeedback(ConfigureNode node) {
        int feedbackDocNum = node.getInt("feedbackdocnum", 10);
        int expandTermNum = node.getInt("expandtermnum", 10);
        double feedbackCoefficient = node.getDouble("feedbackcoefficient", 0.6);
        double bkgCoefficient = node.getDouble("bkgcoefficient", 0.5);
        return new GenerativeFeedback(this.getSearcher(node), feedbackDocNum, expandTermNum, feedbackCoefficient, bkgCoefficient);
    }

    private Feedback loadRocchioFeedback(ConfigureNode node) {
        int feedbackDocNum = node.getInt("feedbackdocnum", 10);
        int expandTermNum = node.getInt("expandtermnum", 10);
        double feedbackCoefficient = node.getDouble("feedbackcoefficient", 0.6);
        boolean useBM25 = node.getBoolean("usebm25", false);
        if (useBM25) {
            double bm25k1 = node.getDouble("bm25k1", 2.0);
            double bm25b = node.getDouble("bm25b", 0.75);
            return new RocchioFeedback(this.getSearcher(node), feedbackDocNum, expandTermNum, feedbackCoefficient, bm25k1, bm25b);
        }
        return new RocchioFeedback(this.getSearcher(node), feedbackDocNum, expandTermNum, feedbackCoefficient);
    }

    private Feedback loadInformationFlowFeedback(ConfigureNode node) {
        int teID = node.getInt("tokenextractor", 0);
        if (teID <= 0) {
            return null;
        }
        ConceptExtractorConfig ceConfig = new ConceptExtractorConfig();
        TokenExtractor te = (TokenExtractor)ceConfig.getConceptExtractor(node, teID);
        int feedbackDocNum = node.getInt("feedbackdocnum", 10);
        int expandTermNum = node.getInt("expandtermnum", 10);
        double feedbackCoefficient = node.getDouble("feedbackcoefficient", 0.6);
        InformationFlowFeedback feedback = new InformationFlowFeedback(te, this.getSearcher(node), feedbackDocNum, expandTermNum, feedbackCoefficient);
        feedback.setHALWindowSize(node.getInt("windowsize", 8));
        feedback.setInfrequentTermThreshold(node.getInt("minfrequency", 25));
        feedback.setDominantVectorWeight(node.getDouble("dominance1", 0.5));
        feedback.setDominantVectorThreshold(node.getDouble("threshold1", 0.0));
        feedback.setSubordinateVectorWeight(node.getDouble("dominance1", 0.3));
        feedback.setSubordinateVectorThreshold(node.getDouble("threshold1", 0.0));
        feedback.setMultiplier(node.getDouble("multiplier", 2.0));
        return feedback;
    }

    private Feedback loadRelationTransFeedback(ConfigureNode node) {
        int feedbackDocNum = node.getInt("feedbackdocnum", 10);
        int expandTermNum = node.getInt("expandtermnum", 10);
        double feedbackCoefficient = node.getDouble("feedbackcoefficient", 0.6);
        double bkgCoefficient = node.getDouble("bkgcoefficient", 0.5);
        boolean selfTranslation = node.getBoolean("selftranslation", true);
        boolean generativeModel = node.getBoolean("generativemodel", false);
        Searcher searcher = this.getSearcher(node);
        if (selfTranslation) {
            if (generativeModel) {
                return new RelationTransFeedback(searcher, feedbackDocNum, expandTermNum, feedbackCoefficient, bkgCoefficient);
            }
            return new RelationTransFeedback(searcher, feedbackDocNum, expandTermNum, feedbackCoefficient);
        }
        int transMatrixID = node.getInt("transmatrix");
        DoubleSparseMatrix transMatrix = new SparseMatrixConfig().getDoubleSparseMatrix(node, transMatrixID);
        if (generativeModel) {
            return new RelationTransFeedback(searcher, feedbackDocNum, expandTermNum, feedbackCoefficient, bkgCoefficient, transMatrix);
        }
        return new RelationTransFeedback(searcher, feedbackDocNum, expandTermNum, feedbackCoefficient, transMatrix);
    }

    private Feedback loadPhraseTransFeedback(ConfigureNode node) {
        int feedbackDocNum = node.getInt("feedbackdocnum", 10);
        int expandTermNum = node.getInt("expandtermnum", 10);
        double feedbackCoefficient = node.getDouble("feedbackcoefficient", 0.6);
        double bkgCoefficient = node.getDouble("bkgcoefficient", 0.5);
        boolean selfTranslation = node.getBoolean("selftranslation", true);
        int phraseIndexReaderID = node.getInt("phraseindexreader");
        IndexReader phraseIndexReader = new IndexReaderConfig().getIndexReader(node, phraseIndexReaderID);
        Searcher searcher = this.getSearcher(node);
        if (selfTranslation) {
            return new PhraseTransFeedback(searcher, feedbackDocNum, expandTermNum, feedbackCoefficient, phraseIndexReader, bkgCoefficient);
        }
        int transMatrixID = node.getInt("transmatrix");
        DoubleSparseMatrix transMatrix = new SparseMatrixConfig().getDoubleSparseMatrix(node, transMatrixID);
        return new PhraseTransFeedback(searcher, feedbackDocNum, expandTermNum, feedbackCoefficient, phraseIndexReader, bkgCoefficient, transMatrix);
    }

    private Searcher getSearcher(ConfigureNode node) {
        SearcherConfig config = new SearcherConfig();
        int searcherID = node.getInt("searcher");
        return config.getSearcher(node, searcherID);
    }
}

