/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.ir.classification.featureselection.ChiFeatureSelector;
import dragon.ir.classification.featureselection.DocFrequencySelector;
import dragon.ir.classification.featureselection.FeatureSelector;
import dragon.ir.classification.featureselection.InfoGainFeatureSelector;
import dragon.ir.classification.featureselection.MutualInfoFeatureSelector;
import dragon.ir.classification.featureselection.NullFeatureSelector;

public class FeatureSelectorConfig
extends ConfigUtil {
    public FeatureSelectorConfig() {
    }

    public FeatureSelectorConfig(ConfigureNode root) {
        super(root);
    }

    public FeatureSelectorConfig(String configFile) {
        super(configFile);
    }

    public FeatureSelector getFeatureSelector(int selectorID) {
        return this.getFeatureSelector(this.root, selectorID);
    }

    public FeatureSelector getFeatureSelector(ConfigureNode node, int selectorID) {
        return this.loadFeatureSelector(node, selectorID);
    }

    private FeatureSelector loadFeatureSelector(ConfigureNode node, int selectorID) {
        ConfigureNode selectorNode = this.getConfigureNode(node, "featureselector", selectorID);
        if (selectorNode == null) {
            return null;
        }
        String selectorName = selectorNode.getNodeName();
        return this.loadFeatureSelector(selectorName, selectorNode);
    }

    protected FeatureSelector loadFeatureSelector(String selectorName, ConfigureNode selectorNode) {
        if (selectorName.equalsIgnoreCase("NullFeatureSelector")) {
            return new NullFeatureSelector();
        }
        if (selectorName.equalsIgnoreCase("ChiFeatureSelector")) {
            return this.loadChiFeatureSelector(selectorNode);
        }
        if (selectorName.equalsIgnoreCase("DocFrequencySelector")) {
            return this.loadDocFrequencySelector(selectorNode);
        }
        if (selectorName.equalsIgnoreCase("MutualInfoSelector")) {
            return this.loadMutualInfoFeatureSelector(selectorNode);
        }
        if (selectorName.equalsIgnoreCase("InfoGainFeatureSelector")) {
            return this.loadInfoGainFeatureSelector(selectorNode);
        }
        return (FeatureSelector)this.loadResource(selectorNode);
    }

    private FeatureSelector loadChiFeatureSelector(ConfigureNode node) {
        return new ChiFeatureSelector(node.getDouble("toppercentage", 0.1), node.getBoolean("avgmode", true));
    }

    private FeatureSelector loadMutualInfoFeatureSelector(ConfigureNode node) {
        return new MutualInfoFeatureSelector(node.getDouble("toppercentage", 0.1), node.getBoolean("avgmode", true));
    }

    private FeatureSelector loadInfoGainFeatureSelector(ConfigureNode node) {
        return new InfoGainFeatureSelector(node.getDouble("toppercentage", 0.1));
    }

    private FeatureSelector loadDocFrequencySelector(ConfigureNode node) {
        return new DocFrequencySelector(node.getInt("mindocfrequency", 5));
    }
}

