/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.IndexReaderConfig;
import dragon.config.SparseMatrixConfig;
import dragon.ir.index.IndexReader;
import dragon.ir.kngbase.DocRepresentation;
import dragon.matrix.DoubleSparseMatrix;

public class DocRepresentationAppConfig {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and document representation id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root = new BasicConfigureNode(args[0]);
        ConfigureNode appNode = util.getConfigureNode(root, "docrepresentationapp", Integer.parseInt(args[1]));
        if (appNode == null) {
            return;
        }
        DocRepresentationAppConfig app = new DocRepresentationAppConfig();
        String appName = appNode.getNodeName();
        if (appName.equalsIgnoreCase("ModelDocRepresentationApp")) {
            app.genModelMatrix(appNode);
        } else if (appName.equalsIgnoreCase("TFIDFDocRepresentationApp")) {
            app.genTFIDFMatrix(appNode);
        } else if (appName.equalsIgnoreCase("NormTFDocRepresentationApp")) {
            app.genNormTFMatrix(appNode);
        } else {
            return;
        }
    }

    public void genModelMatrix(ConfigureNode node) {
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        DocRepresentation docRepresentation = new DocRepresentation(indexReader);
        int topicIndexReaderID = node.getInt("topicindexreader");
        IndexReader topicIndexReader = new IndexReaderConfig().getIndexReader(node, topicIndexReaderID);
        int transMatrixID = node.getInt("transmatrix");
        DoubleSparseMatrix transMatrix = new SparseMatrixConfig().getDoubleSparseMatrix(node, transMatrixID);
        double bkgCoefficient = node.getDouble("bkgcoefficient");
        double transCoefficient = node.getDouble("transcoefficient");
        double probThreshold = node.getDouble("probthreshold");
        boolean isPhraseSignature = node.getBoolean("phrasesignature", true);
        String matrixKey = node.getString("matrixkey", "doctermtrans");
        String matrixPath = node.getString("matrixpath");
        docRepresentation.genModelMatrix(topicIndexReader, transMatrix, transCoefficient, bkgCoefficient, isPhraseSignature, probThreshold, matrixPath, matrixKey);
    }

    public void genTFIDFMatrix(ConfigureNode node) {
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        DocRepresentation docRepresentation = new DocRepresentation(indexReader);
        String matrixPath = node.getString("matrixpath");
        String matrixKey = node.getString("matrixkey", "doctermtfidf");
        docRepresentation.genTFIDFMatrix(matrixPath, matrixKey);
    }

    public void genNormTFMatrix(ConfigureNode node) {
        int indexReaderID = node.getInt("indexreader");
        IndexReader indexReader = new IndexReaderConfig().getIndexReader(node, indexReaderID);
        DocRepresentation docRepresentation = new DocRepresentation(indexReader);
        String matrixKey = node.getString("matrixkey", "doctermnormtf");
        String matrixPath = node.getString("matrixpath");
        docRepresentation.genNormTFMatrix(matrixPath, matrixKey);
    }
}

