/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ConfigureNode;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ConfigUtil {
    protected ConfigureNode root;

    public ConfigUtil() {
        this.root = null;
    }

    public ConfigUtil(ConfigureNode root) {
        this.root = root;
    }

    public ConfigUtil(String configFile) {
        this.root = new BasicConfigureNode(configFile);
    }

    public ConfigureNode getConfigureNode(ConfigureNode curNode, String nodeType, int nodeID) {
        ConfigureNode nextNode;
        if (curNode.getNodeType().equalsIgnoreCase(nodeType) && curNode.getNodeID() == nodeID) {
            return curNode;
        }
        for (nextNode = curNode.getFirstChild(); nextNode != null; nextNode = nextNode.getNextSibling()) {
            if (!nextNode.getNodeType().equalsIgnoreCase(nodeType) || nextNode.getNodeID() != nodeID) continue;
            return nextNode;
        }
        nextNode = curNode.getParentNode();
        if (nextNode != null) {
            for (nextNode = nextNode.getFirstChild(); nextNode != null; nextNode = nextNode.getNextSibling()) {
                if (!nextNode.getNodeType().equalsIgnoreCase(nodeType) || nextNode.getNodeID() != nodeID) continue;
                return nextNode;
            }
        }
        if (this.root == null) {
            nextNode = curNode.getParentNode();
            if (nextNode == null) {
                return null;
            }
            while (nextNode != null) {
                this.root = nextNode;
                nextNode = nextNode.getParentNode();
            }
        }
        for (nextNode = this.root.getFirstChild(); nextNode != null; nextNode = nextNode.getNextSibling()) {
            if (!nextNode.getNodeType().equalsIgnoreCase(nodeType) || nextNode.getNodeID() != nodeID) continue;
            return nextNode;
        }
        return null;
    }

    public Object loadResource(ConfigureNode node) {
        try {
            Class[] params;
            String methodName;
            Method method;
            Class curClass = node.getNodeClass();
            if (curClass == null) {
                return null;
            }
            String shortClassName = curClass.getName();
            if (shortClassName.lastIndexOf(46) > 0) {
                shortClassName = shortClassName.substring(shortClassName.lastIndexOf(46) + 1);
            }
            if ((method = curClass.getMethod(methodName = "get" + shortClassName, params = new Class[]{Class.forName("dragon.config.ConfigureNode")})) == null) {
                System.out.println("Please define the method in class " + curClass.getName() + ": public static " + shortClassName + " " + methodName + "(ConfigureNode node)");
                return null;
            }
            int modifierCode = method.getModifiers();
            if (!Modifier.isPublic(modifierCode) || !Modifier.isStatic(modifierCode)) {
                System.out.println("The method " + methodName + " should be defined as public and static");
                return null;
            }
            Object[] objParams = new Object[]{node};
            return method.invoke((Object)curClass, objParams);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

