/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.nlp.extract.BasicConceptFilter;
import dragon.nlp.extract.ConceptFilter;

public class ConceptFilterConfig
extends ConfigUtil {
    public ConceptFilterConfig() {
    }

    public ConceptFilterConfig(ConfigureNode root) {
        super(root);
    }

    public ConceptFilterConfig(String configFile) {
        super(configFile);
    }

    public ConceptFilter getConceptFilter(int taggerID) {
        return this.getConceptFilter(this.root, taggerID);
    }

    public ConceptFilter getConceptFilter(ConfigureNode node, int conceptFilterID) {
        return this.loadConceptFilter(node, conceptFilterID);
    }

    private ConceptFilter loadConceptFilter(ConfigureNode node, int conceptFilterID) {
        ConfigureNode conceptFilterNode = this.getConfigureNode(node, "conceptFilter", conceptFilterID);
        if (conceptFilterNode == null) {
            return null;
        }
        String conceptFilterName = conceptFilterNode.getNodeName();
        if (conceptFilterName.equalsIgnoreCase("BasicConceptFilter")) {
            return this.loadBasicConceptFilter(conceptFilterNode);
        }
        return (ConceptFilter)this.loadResource(conceptFilterNode);
    }

    private ConceptFilter loadBasicConceptFilter(ConfigureNode curNode) {
        String stoplistFile = curNode.getString("stoplistfile", null);
        String excludedSTYFile = curNode.getString("excludedstyfile", null);
        String supportedSTYFile = curNode.getString("supportedstyfile", null);
        String excludedSTY = curNode.getString("excludedsty", null);
        String supportedSTY = curNode.getString("supportedsty", null);
        BasicConceptFilter conceptFilter = new BasicConceptFilter(stoplistFile, supportedSTYFile, excludedSTYFile);
        if (excludedSTY != null && excludedSTY.trim().length() > 0) {
            conceptFilter.addMultiExcludedSTY(excludedSTY.trim());
        }
        if (supportedSTY != null && supportedSTY.trim().length() > 0) {
            conceptFilter.addMultiSupportedSTY(supportedSTY.trim());
        }
        return conceptFilter;
    }
}

