/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConceptFilterConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.config.DocumentParserConfig;
import dragon.config.LemmatiserConfig;
import dragon.config.OntologyConfig;
import dragon.config.TaggerConfig;
import dragon.config.VocabularyConfig;
import dragon.nlp.DocumentParser;
import dragon.nlp.Phrase;
import dragon.nlp.Term;
import dragon.nlp.extract.BasicPhraseExtractor;
import dragon.nlp.extract.BasicTermExtractor;
import dragon.nlp.extract.BasicTokenExtractor;
import dragon.nlp.extract.ConceptExtractor;
import dragon.nlp.extract.ConceptFilter;
import dragon.nlp.extract.EngDocumentParser;
import dragon.nlp.ontology.Ontology;
import dragon.nlp.ontology.Vocabulary;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;

public class ConceptExtractorConfig
extends ConfigUtil {
    public ConceptExtractorConfig() {
    }

    public ConceptExtractorConfig(ConfigureNode root) {
        super(root);
    }

    public ConceptExtractorConfig(String configFile) {
        super(configFile);
    }

    public ConceptExtractor getConceptExtractor(int extractorID) {
        return this.loadConceptExtractor(this.root, extractorID);
    }

    public ConceptExtractor getConceptExtractor(ConfigureNode node, int extractorID) {
        return this.loadConceptExtractor(node, extractorID);
    }

    private ConceptExtractor loadConceptExtractor(ConfigureNode node, int extractorID) {
        ConfigureNode extractorNode = this.getConfigureNode(node, "conceptextractor", extractorID);
        if (extractorNode == null) {
            return null;
        }
        String extractorName = extractorNode.getNodeName();
        return this.loadConceptExtractor(extractorName, extractorNode);
    }

    protected ConceptExtractor loadConceptExtractor(String extractorName, ConfigureNode extractorNode) {
        if (extractorName.equalsIgnoreCase("BasicTokenExtractor")) {
            return this.loadBasicTokenExtractor(extractorNode);
        }
        if (extractorName.equalsIgnoreCase("BasicPhraseExtractor")) {
            return this.loadBasicPhraseExtractor(extractorNode);
        }
        if (extractorName.equalsIgnoreCase("BasicTermExtractor")) {
            return this.loadBasicTermExtractor(extractorNode);
        }
        return (ConceptExtractor)this.loadResource(extractorNode);
    }

    private ConceptExtractor loadBasicTokenExtractor(ConfigureNode curNode) {
        int parserID = curNode.getInt("documentparser", 0);
        int lemmatiserID = curNode.getInt("lemmatiser", 0);
        int filterID = curNode.getInt("conceptfilter", 0);
        boolean filterOption = curNode.getBoolean("filteroption", true);
        boolean subtermOption = curNode.getBoolean("subconceptoption", false);
        String wordDelimitor = this.getWordDelimitor(curNode.getString("notworddelimitor", ""));
        DocumentParser parser = parserID > 0 ? new DocumentParserConfig().getDocumentParser(curNode, parserID) : new EngDocumentParser(wordDelimitor);
        LemmatiserConfig lemmaConfig = new LemmatiserConfig();
        Lemmatiser lemmatiser = lemmaConfig.getLemmatiser(curNode, lemmatiserID);
        ConceptFilterConfig filterConfig = new ConceptFilterConfig();
        ConceptFilter filter = filterConfig.getConceptFilter(curNode, filterID);
        BasicTokenExtractor extractor = new BasicTokenExtractor(lemmatiser);
        extractor.setConceptFilter(filter);
        extractor.setSubConceptOption(subtermOption);
        extractor.setFilteringOption(filterOption);
        extractor.setDocumentParser(parser);
        return extractor;
    }

    private ConceptExtractor loadBasicPhraseExtractor(ConfigureNode curNode) {
        int parserID = curNode.getInt("documentparser", 0);
        int lemmatiserID = curNode.getInt("lemmatiser", 0);
        int filterID = curNode.getInt("conceptfilter", 0);
        int vobID = curNode.getInt("vocabulary", 0);
        int taggerID = curNode.getInt("tagger", 0);
        boolean filterOption = curNode.getBoolean("filteroption", true);
        boolean subtermOption = curNode.getBoolean("subconceptoption", false);
        boolean overlappedPhrase = curNode.getBoolean("overlappedphrase", false);
        String wordDelimitor = this.getWordDelimitor(curNode.getString("notworddelimitor", ""));
        String nameMode = curNode.getString("conceptnamemode", "asis");
        boolean singleNoun = curNode.getBoolean("singlenounoption", true);
        boolean singleAdj = curNode.getBoolean("singleadjoption", true);
        boolean singleVerb = curNode.getBoolean("singleverboption", false);
        DocumentParser parser = parserID > 0 ? new DocumentParserConfig().getDocumentParser(curNode, parserID) : new EngDocumentParser(wordDelimitor);
        LemmatiserConfig lemmaConfig = new LemmatiserConfig();
        Lemmatiser lemmatiser = lemmaConfig.getLemmatiser(curNode, lemmatiserID);
        VocabularyConfig vobConfig = new VocabularyConfig();
        Vocabulary vob = vobConfig.getVocabulary(curNode, vobID);
        TaggerConfig taggerConfig = new TaggerConfig();
        Tagger tagger = taggerConfig.getTagger(curNode, taggerID);
        ConceptFilterConfig filterConfig = new ConceptFilterConfig();
        ConceptFilter filter = filterConfig.getConceptFilter(curNode, filterID);
        BasicPhraseExtractor extractor = new BasicPhraseExtractor(vob, lemmatiser, tagger, overlappedPhrase);
        extractor.setDocumentParser(parser);
        if (nameMode.equalsIgnoreCase("lemma")) {
            Phrase.setNameMode(1);
        } else {
            Phrase.setNameMode(0);
        }
        extractor.setConceptFilter(filter);
        extractor.setSubConceptOption(subtermOption);
        extractor.setFilteringOption(filterOption);
        extractor.setSingleAdjectiveOption(singleAdj);
        extractor.setSingleNounOption(singleNoun);
        extractor.setSingleVerbOption(singleVerb);
        return extractor;
    }

    private ConceptExtractor loadBasicTermExtractor(ConfigureNode curNode) {
        int parserID = curNode.getInt("documentparser", 0);
        int lemmatiserID = curNode.getInt("lemmatiser", 0);
        int filterID = curNode.getInt("conceptfilter", 0);
        int ontologyID = curNode.getInt("ontology", 0);
        int taggerID = curNode.getInt("tagger", 0);
        boolean filterOption = curNode.getBoolean("filteroption", true);
        boolean subtermOption = curNode.getBoolean("subconceptoption", false);
        String wordDelimitor = this.getWordDelimitor(curNode.getString("notworddelimitor", ""));
        String nameMode = curNode.getString("conceptnamemode", "asis");
        boolean abbr = curNode.getBoolean("abbreviation", true);
        boolean semanticCheck = curNode.getBoolean("semanticcheck", true);
        boolean attributeCheck = curNode.getBoolean("attributecheck", false);
        boolean coordinatingCheck = curNode.getBoolean("coordinatingcheck", false);
        boolean compoundTermPrediction = curNode.getBoolean("compoundtermprediction", false);
        boolean coordinatingTermPrediction = curNode.getBoolean("coordinatingtermprediction", false);
        DocumentParser parser = parserID > 0 ? new DocumentParserConfig().getDocumentParser(curNode, parserID) : new EngDocumentParser(wordDelimitor);
        LemmatiserConfig lemmaConfig = new LemmatiserConfig();
        Lemmatiser lemmatiser = lemmaConfig.getLemmatiser(curNode, lemmatiserID);
        OntologyConfig ontologyConfig = new OntologyConfig();
        Ontology ontology = ontologyConfig.getOntology(curNode, ontologyID);
        TaggerConfig taggerConfig = new TaggerConfig();
        Tagger tagger = taggerConfig.getTagger(curNode, taggerID);
        ConceptFilterConfig filterConfig = new ConceptFilterConfig();
        ConceptFilter filter = filterConfig.getConceptFilter(curNode, filterID);
        BasicTermExtractor extractor = new BasicTermExtractor(ontology, lemmatiser, tagger);
        extractor.setDocumentParser(parser);
        if (nameMode.equalsIgnoreCase("norm")) {
            Term.setNameMode(2);
        } else if (nameMode.equalsIgnoreCase("lemma")) {
            Term.setNameMode(1);
        } else {
            Term.setNameMode(0);
        }
        extractor.setConceptFilter(filter);
        extractor.setSubConceptOption(subtermOption);
        extractor.setFilteringOption(filterOption);
        extractor.setAbbreviationOption(abbr);
        extractor.setSemanticCheckOption(semanticCheck);
        extractor.setAttributeCheckOption(attributeCheck);
        extractor.setCoordinatingCheckOption(coordinatingCheck);
        extractor.setCompoundTermPredictOption(compoundTermPrediction);
        extractor.setCoordinatingTermPredictOption(coordinatingTermPrediction);
        return extractor;
    }

    private String getWordDelimitor(String notWordDelimitor) {
        StringBuffer sb = new StringBuffer();
        String delimitors = " \r\n\t_-.;,?/\"'`:(){}!+[]><=%$#*@&^~|\\";
        if (notWordDelimitor == null && notWordDelimitor.length() == 0) {
            return delimitors;
        }
        for (int i = 0; i < delimitors.length(); ++i) {
            if (notWordDelimitor.indexOf(delimitors.charAt(i)) >= 0) continue;
            sb.append(delimitors.charAt(i));
        }
        return sb.toString();
    }
}

