/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.onlinedb.ArticleParser;
import dragon.onlinedb.BasicCollectionReader;
import dragon.onlinedb.CollectionReader;
import dragon.onlinedb.SimpleCollectionReader;
import dragon.onlinedb.trec.EarlyTrecTopicReader;
import dragon.onlinedb.trec.Genomics2004TopicReader;
import dragon.onlinedb.trec.Genomics2005TopicReader;
import dragon.onlinedb.trec.TrecCollectionReader;

public class CollectionReaderConfig
extends ConfigUtil {
    public CollectionReaderConfig() {
    }

    public CollectionReaderConfig(ConfigureNode root) {
        super(root);
    }

    public CollectionReaderConfig(String configFile) {
        super(configFile);
    }

    public CollectionReader getCollectionReader(int collectionID) {
        return this.loadCollectionReader(this.root, collectionID);
    }

    public CollectionReader getCollectionReader(ConfigureNode node, int extractorID) {
        return this.loadCollectionReader(node, extractorID);
    }

    private CollectionReader loadCollectionReader(ConfigureNode node, int extractorID) {
        ConfigureNode extractorNode = this.getConfigureNode(node, "collectionreader", extractorID);
        if (extractorNode == null) {
            return null;
        }
        String extractorName = extractorNode.getNodeName();
        return this.loadCollectionReader(extractorName, extractorNode);
    }

    protected CollectionReader loadCollectionReader(String collectionName, ConfigureNode collectionNode) {
        if (collectionName.equalsIgnoreCase("BasicCollectionReader")) {
            return this.loadBasicCollectionReader(collectionNode);
        }
        if (collectionName.equalsIgnoreCase("SimpleCollectionReader")) {
            return this.loadSimpleCollectionReader(collectionNode);
        }
        if (collectionName.equalsIgnoreCase("TrecCollectionReader")) {
            return this.loadTrecCollectionReader(collectionNode);
        }
        if (collectionName.equalsIgnoreCase("EarlyTrecTopicReader")) {
            return new EarlyTrecTopicReader(collectionNode.getString("topicfile"));
        }
        if (collectionName.equalsIgnoreCase("Genomics2005TopicReader")) {
            return new Genomics2005TopicReader(collectionNode.getString("topicfile"));
        }
        if (collectionName.equalsIgnoreCase("Genomics2004TopicReader")) {
            return new Genomics2004TopicReader(collectionNode.getString("topicfile"));
        }
        return (CollectionReader)this.loadResource(collectionNode);
    }

    private CollectionReader loadBasicCollectionReader(ConfigureNode curNode) {
        try {
            BasicCollectionReader reader;
            String collectionPath = curNode.getString("collectionpath");
            String collectionName = curNode.getString("collectionname");
            String collectionFile = curNode.getString("collectionfile");
            String indexFile = curNode.getString("indexfile");
            String articleParser = curNode.getString("articleparser", "dragon.onlinedb.BasicArticleParser");
            if (collectionFile == null) {
                collectionFile = collectionPath + "/" + collectionName + ".collection";
                indexFile = collectionPath + "/" + collectionName + ".index";
                reader = new BasicCollectionReader(collectionFile, indexFile);
            } else {
                reader = new BasicCollectionReader(collectionFile, indexFile);
            }
            ArticleParser parser = this.getArticleParser(articleParser);
            if (parser == null) {
                System.out.println("Can not load the article parser.");
                return null;
            }
            reader.setArticleParser(parser);
            return reader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private CollectionReader loadSimpleCollectionReader(ConfigureNode curNode) {
        try {
            String collectionPath = curNode.getString("collectionpath", null);
            String articleParser = curNode.getString("articleparser", "dragon.onlinedb.SimpleArticleParser");
            ArticleParser parser = this.getArticleParser(articleParser);
            if (parser == null) {
                System.out.println("Can not load the article parser.");
                return null;
            }
            SimpleCollectionReader reader = collectionPath == null ? new SimpleCollectionReader(parser) : new SimpleCollectionReader(collectionPath, parser);
            return reader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private CollectionReader loadTrecCollectionReader(ConfigureNode curNode) {
        try {
            String collectionPath = curNode.getString("collectionpath", null);
            String indexFile = curNode.getString("indexfile", null);
            String articleParser = curNode.getString("articleparser", "dragon.onlinedb.BasicArticleParser");
            ArticleParser parser = this.getArticleParser(articleParser);
            if (parser == null) {
                System.out.println("Can not load the article parser.");
                return null;
            }
            TrecCollectionReader reader = collectionPath == null && indexFile == null ? new TrecCollectionReader(parser) : (indexFile == null ? new TrecCollectionReader(collectionPath, parser) : new TrecCollectionReader(collectionPath, indexFile, parser));
            return reader;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected ArticleParser getArticleParser(String className) {
        try {
            Class<?> myClass = Class.forName(className);
            return (ArticleParser)myClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

