/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.ir.classification.multiclass.AllPairCodeMatrix;
import dragon.ir.classification.multiclass.CodeMatrix;
import dragon.ir.classification.multiclass.OVACodeMatrix;

public class CodeMatrixConfig
extends ConfigUtil {
    public CodeMatrixConfig() {
    }

    public CodeMatrixConfig(ConfigureNode root) {
        super(root);
    }

    public CodeMatrixConfig(String configFile) {
        super(configFile);
    }

    public CodeMatrix getCodeMatrix(int codeMatrixID) {
        return this.getCodeMatrix(this.root, codeMatrixID);
    }

    public CodeMatrix getCodeMatrix(ConfigureNode node, int codeMatrixID) {
        return this.loadCodeMatrix(node, codeMatrixID);
    }

    private CodeMatrix loadCodeMatrix(ConfigureNode node, int codeMatrixID) {
        ConfigureNode codeMatrixNode = this.getConfigureNode(node, "CodeMatrix", codeMatrixID);
        if (codeMatrixNode == null) {
            return null;
        }
        String codeMatrixName = codeMatrixNode.getNodeName();
        return this.loadCodeMatrix(codeMatrixName, codeMatrixNode);
    }

    protected CodeMatrix loadCodeMatrix(String codeMatrixName, ConfigureNode codeMatrixNode) {
        if (codeMatrixName.equalsIgnoreCase("OVACodeMatrix")) {
            return new OVACodeMatrix(codeMatrixNode.getInt("classnum", 1));
        }
        if (codeMatrixName.equalsIgnoreCase("AllPairCodeMatrix")) {
            return new AllPairCodeMatrix(codeMatrixNode.getInt("classnum", 1));
        }
        return (CodeMatrix)this.loadResource(codeMatrixNode);
    }
}

