/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.BasicConfigureNode;
import dragon.config.ClusteringConfig;
import dragon.config.ConfigUtil;
import dragon.config.ConfigureNode;
import dragon.ir.clustering.Clustering;
import dragon.ir.clustering.ClusteringEva;
import dragon.ir.clustering.DocClusterSet;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.nlp.SimpleElementList;
import dragon.nlp.compare.IndexComparator;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.TreeMap;

public class ClusteringEvaAppConfig {
    private TreeMap map = new TreeMap();
    private ArrayList labelList = new ArrayList();
    private int maxCategory = 0;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Please input two parameters: configuration xml file and clustering evaluation id");
            return;
        }
        ConfigUtil util = new ConfigUtil();
        BasicConfigureNode root = new BasicConfigureNode(args[0]);
        ConfigureNode clusteringAppNode = util.getConfigureNode(root, "clusteringevaapp", Integer.parseInt(args[1]));
        if (clusteringAppNode == null) {
            return;
        }
        ClusteringEvaAppConfig clusteringApp = new ClusteringEvaAppConfig();
        String appName = clusteringAppNode.getNodeName();
        if (appName.equalsIgnoreCase("AgglomerativeEvaApp")) {
            clusteringApp.evaAgglomerativeClustering(clusteringAppNode);
        } else if (appName.equalsIgnoreCase("PartitionEvaApp")) {
            clusteringApp.evaPartitionClustering(clusteringAppNode);
        } else {
            return;
        }
    }

    public void evaAgglomerativeClustering(ConfigureNode node) {
        String docKeyFile = node.getString("dockeyfile");
        SimpleElementList docKeyList = docKeyFile == null ? null : new SimpleElementList(docKeyFile, false);
        int clusteringID = node.getInt("clustering");
        Clustering clusteringMethod = new ClusteringConfig().getClustering(node, clusteringID);
        String answerKey = node.getString("answerkey");
        String outputFile = node.getString("outputfile");
        String runName = node.getString("runname");
        this.evaAgglomerativeClustering(clusteringMethod, docKeyList, answerKey, runName, outputFile);
    }

    public void evaAgglomerativeClustering(Clustering clusterMethod, String answerKeyFile, String runName, String outFile) {
        this.evaAgglomerativeClustering(clusterMethod, null, answerKeyFile, runName, outFile);
    }

    public void evaAgglomerativeClustering(Clustering clusterMethod, SimpleElementList docKeyList, String answerKeyFile, String runName, String outFile) {
        this.map.clear();
        this.maxCategory = 0;
        this.labelList.clear();
        IRDoc[] arrDoc = this.getValidDocs(clusterMethod.getIndexReader(), docKeyList, answerKeyFile);
        DocClusterSet human = this.readHumanClusterSet(arrDoc, this.maxCategory);
        clusterMethod.cluster(arrDoc);
        DocClusterSet machine = clusterMethod.getClusterSet();
        for (int i = 0; i < machine.getClusterNum(); ++i) {
            System.out.println(machine.getDocCluster(i).getDocNum());
        }
        this.printHeader(outFile);
        this.evaluate(machine, human, runName, outFile);
    }

    public void evaPartitionClustering(ConfigureNode node) {
        String docKeyFile = node.getString("dockeyfile");
        SimpleElementList docKeyList = docKeyFile == null ? null : new SimpleElementList(docKeyFile, false);
        int clusteringID = node.getInt("clustering");
        Clustering clusteringMethod = new ClusteringConfig().getClustering(node, clusteringID);
        String answerKey = node.getString("answerkey");
        String outputFile = node.getString("outputfile");
        String runName = node.getString("runname");
        int run = node.getInt("run", 1);
        this.evaPartitionClustering(clusteringMethod, docKeyList, answerKey, run, runName, outputFile);
    }

    public void evaPartitionClustering(Clustering clusterMethod, String answerKeyFile, int run, String runName, String outFile) {
        this.evaPartitionClustering(clusterMethod, null, answerKeyFile, run, runName, outFile);
    }

    public void evaPartitionClustering(Clustering clusterMethod, SimpleElementList docKeyList, String answerKeyFile, int run, String runName, String outFile) {
        this.map.clear();
        this.maxCategory = 0;
        this.labelList.clear();
        long randomSeed = clusterMethod.getRandomSeed();
        if (randomSeed < 0L && run > 1) {
            randomSeed = 0L;
        }
        IRDoc[] arrDoc = this.getValidDocs(clusterMethod.getIndexReader(), docKeyList, answerKeyFile);
        DocClusterSet human = this.readHumanClusterSet(arrDoc, this.maxCategory);
        this.printHeader(outFile);
        for (int i = 0; i < run; ++i) {
            clusterMethod.setRandomSeed(randomSeed);
            clusterMethod.cluster(arrDoc);
            DocClusterSet machine = clusterMethod.getClusterSet();
            for (int j = 0; j < machine.getClusterNum(); ++j) {
                System.out.println(machine.getDocCluster(j).getDocNum());
            }
            String curRunName = runName.length() == 0 ? String.valueOf(randomSeed) : runName + " " + String.valueOf(randomSeed);
            this.evaluate(machine, human, curRunName, outFile);
            randomSeed += 100L;
        }
    }

    private void evaluate(DocClusterSet machine, DocClusterSet human, String runName, String outFile) {
        ClusteringEva eva = new ClusteringEva();
        eva.evaluate(machine, human);
        System.out.println("Number of Clusters: " + human.getClusterNum());
        System.out.println("Entropy: " + eva.getEntropy());
        System.out.println("FScore: " + eva.getFScore());
        System.out.println("Purity:" + eva.getPurity());
        System.out.println("MutualInformation:" + eva.getMI());
        System.out.println("NMI:" + eva.getNMI());
        System.out.println("Geometry NMI:" + eva.getGeometryNMI());
        this.printResult(eva, runName, outFile);
    }

    private void printResult(ClusteringEva ce, String runName, String outFile) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outFile), true));
            if (runName != null && runName.length() > 0) {
                bw.write(runName + "\t");
            }
            bw.write(ce.getEntropy() + "\t" + ce.getFScore() + "\t" + ce.getPurity() + "\t" + ce.getMI() + "\t" + ce.getNMI() + "\t" + ce.getGeometryNMI() + "\n");
            bw.flush();
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void printHeader(String outputFile) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outputFile), true));
            bw.write("Run\tEntropy\tFScore\tPurity\tMI\tNMI\tG-NMI\n");
            bw.flush();
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DocClusterSet readHumanClusterSet(IRDoc[] arrDoc, int clusterNum) {
        int i;
        DocClusterSet docClusterSet = new DocClusterSet(clusterNum);
        for (i = 0; i < arrDoc.length; ++i) {
            docClusterSet.addDoc(arrDoc[i].getCategory(), arrDoc[i]);
        }
        for (i = 0; i < clusterNum; ++i) {
            docClusterSet.getDocCluster(i).setClusterName((String)this.labelList.get(i));
        }
        return docClusterSet;
    }

    private IRDoc[] getValidDocs(IndexReader indexReader, SimpleElementList docKeyList, String answerKeyFile) {
        try {
            String line;
            BufferedReader br = FileUtil.getTextReader(answerKeyFile);
            SortedArray answerKeyList = new SortedArray(Integer.parseInt(br.readLine()), new IndexComparator());
            while ((line = br.readLine()) != null) {
                Integer curCategory;
                IRDoc irDoc;
                String[] arrTopic = line.split("\t");
                if (indexReader != null) {
                    irDoc = indexReader.getDoc(arrTopic[1]);
                    if (irDoc == null || irDoc.getTermNum() < 1) {
                        continue;
                    }
                } else {
                    irDoc = new IRDoc(arrTopic[1]);
                    irDoc.setIndex(docKeyList.search(arrTopic[1]));
                }
                if ((curCategory = (Integer)this.map.get(arrTopic[0])) == null) {
                    curCategory = new Integer(this.maxCategory);
                    ++this.maxCategory;
                    this.map.put(arrTopic[0], curCategory);
                    this.labelList.add(arrTopic[0]);
                }
                irDoc.setCategory(curCategory);
                answerKeyList.add(irDoc);
            }
            br.close();
            IRDoc[] arrDoc = new IRDoc[answerKeyList.size()];
            for (int i = 0; i < answerKeyList.size(); ++i) {
                arrDoc[i] = (IRDoc)answerKeyList.get(i);
            }
            return arrDoc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

