/*
 * Decompiled with CFR 0.152.
 */
package dragon.config;

import dragon.config.ConfigureNode;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BasicConfigureNode
implements ConfigureNode {
    private Node node;

    public BasicConfigureNode(String configFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(new File(configFile));
            this.node = doc.getDocumentElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.node = null;
        }
    }

    public BasicConfigureNode(Node node) {
        this.node = node.getNodeName().equalsIgnoreCase("param") ? null : node;
    }

    @Override
    public ConfigureNode getParentNode() {
        if (this.node.getParentNode() == null) {
            return null;
        }
        if (this.node.getParentNode().getParentNode() == null) {
            return null;
        }
        return new BasicConfigureNode(this.node.getParentNode());
    }

    @Override
    public ConfigureNode getFirstChild() {
        for (Node curNode = this.node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            if (curNode.getNodeName().equalsIgnoreCase("param")) {
                continue;
            }
            return new BasicConfigureNode(curNode);
        }
        return null;
    }

    @Override
    public ConfigureNode getNextSibling() {
        for (Node curNode = this.node.getNextSibling(); curNode != null; curNode = curNode.getNextSibling()) {
            if (curNode.getNodeName().equalsIgnoreCase("param")) {
                continue;
            }
            return new BasicConfigureNode(curNode);
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return this.node.getNodeName();
    }

    @Override
    public int getNodeID() {
        if (!this.node.hasAttributes()) {
            return -1;
        }
        Node curNode = this.node.getAttributes().getNamedItem("id");
        if (curNode == null) {
            return -1;
        }
        return Integer.parseInt(curNode.getNodeValue());
    }

    @Override
    public Class getNodeClass() {
        String className = null;
        try {
            if (!this.node.hasAttributes()) {
                System.out.println("Please specify the class name the resource corresponds to in the configuration flie!");
                return null;
            }
            Node curNode = this.node.getAttributes().getNamedItem("class");
            if (curNode == null) {
                System.out.println("Please specify the class name the resource corresponds to in the configuration flie!");
                return null;
            }
            className = curNode.getNodeValue();
            return Class.forName(className);
        }
        catch (Exception e) {
            if (className != null) {
                System.out.println("Can't load the class: " + className);
            }
            return null;
        }
    }

    @Override
    public String getNodeType() {
        if (!this.node.hasAttributes()) {
            return "";
        }
        Node curNode = this.node.getAttributes().getNamedItem("type");
        if (curNode == null) {
            return "";
        }
        return curNode.getNodeValue();
    }

    @Override
    public String getString(String key) {
        return this.getParam(key);
    }

    @Override
    public String getString(String key, String def) {
        String ret = this.getParam(key);
        if (ret == null) {
            return def;
        }
        return ret;
    }

    @Override
    public int getInt(String key) {
        String ret = this.getParam(key);
        if (ret == null) {
            return 0;
        }
        return Integer.parseInt(ret);
    }

    @Override
    public int getInt(String key, int def) {
        String ret = this.getParam(key);
        if (ret == null) {
            return def;
        }
        return Integer.parseInt(ret);
    }

    @Override
    public boolean getBoolean(String key) {
        String ret = this.getParam(key);
        if (ret == null) {
            return false;
        }
        return Boolean.getBoolean(ret);
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        String ret = this.getParam(key);
        if (ret == null) {
            return def;
        }
        return new Boolean(ret);
    }

    @Override
    public double getDouble(String key) {
        String ret = this.getParam(key);
        if (ret == null) {
            return 0.0;
        }
        return Double.parseDouble(ret);
    }

    @Override
    public double getDouble(String key, double def) {
        String ret = this.getParam(key);
        if (ret == null) {
            return def;
        }
        return Double.parseDouble(ret);
    }

    @Override
    public boolean exist(String key) {
        return this.getParam(key) != null;
    }

    private String getParam(String key) {
        for (Node curNode = this.node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            Node attribute;
            if (!curNode.getNodeName().equalsIgnoreCase("param") || !curNode.hasAttributes() || (attribute = curNode.getAttributes().getNamedItem("name")) == null || !attribute.getNodeValue().equalsIgnoreCase(key)) continue;
            attribute = curNode.getAttributes().getNamedItem("value");
            if (attribute == null) {
                return null;
            }
            return attribute.getNodeValue();
        }
        return null;
    }

    @Override
    public String getParameterType(String key) {
        for (Node curNode = this.node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            Node attribute;
            if (!curNode.getNodeName().equalsIgnoreCase("param") || !curNode.hasAttributes() || (attribute = curNode.getAttributes().getNamedItem("name")) == null || !attribute.getNodeValue().equalsIgnoreCase(key)) continue;
            attribute = curNode.getAttributes().getNamedItem("type");
            if (attribute == null) {
                return null;
            }
            return attribute.getNodeValue();
        }
        return null;
    }
}

