/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.cli;

import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.dbconnection.util.CoStoSysException;
import de.julielab.xml.binary.BinaryDecodingResult;
import de.julielab.xml.binary.BinaryJeDISNodeDecoder;
import de.julielab.xml.binary.BinaryXmiBuilder;
import de.julielab.xml.util.XMIBuilderException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.uima.UIMAException;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryDataHandler {
    private static final Logger log = LoggerFactory.getLogger(BinaryDataHandler.class);
    private final Map<Integer, String> reverseBinaryMapping;
    private final Map<String, Boolean> featuresToMapBinary;
    private DataBaseConnector dbc;
    private String xmiMetaSchema;
    private Set<String> annotationColumnsToLoad;
    private TypeSystem typeSystem;

    public BinaryDataHandler(DataBaseConnector dbc, String xmiMetaSchema, Set<String> annotationColumnsToLoad, List<File> typeSystemFiles) throws CoStoSysException {
        try {
            this.dbc = dbc;
            this.xmiMetaSchema = xmiMetaSchema;
            this.annotationColumnsToLoad = annotationColumnsToLoad;
            this.typeSystem = this.readTypeSystem(typeSystemFiles);
            this.reverseBinaryMapping = this.getReverseBinaryMappingFromDb();
            this.featuresToMapBinary = this.getFeaturesToMapBinaryFromDb();
        }
        catch (UIMAException e) {
            throw new CoStoSysException(e);
        }
    }

    private TypeSystem readTypeSystem(List<File> typeSystemFiles) throws UIMAException {
        ArrayList<File> concreteFiles = new ArrayList<File>();
        for (File f : typeSystemFiles) {
            if (f.isDirectory()) {
                Arrays.stream(f.listFiles((file, name) -> name.endsWith("xml"))).forEach(concreteFiles::add);
                continue;
            }
            concreteFiles.add(f);
        }
        TypeSystemDescription tsDesc = TypeSystemDescriptionFactory.createTypeSystemDescription((String[])((String[])concreteFiles.stream().map(File::getAbsolutePath).toArray(String[]::new)));
        return JCasFactory.createJCas((TypeSystemDescription)tsDesc).getTypeSystem();
    }

    public String decodeBinaryXmiData(byte[][] data, boolean makeValidXml) throws CoStoSysException {
        int[] xmiColumnIndices;
        FieldConfig fieldConfig = this.dbc.getActiveTableFieldConfiguration();
        int pkLength = fieldConfig.getPrimaryKey().length;
        LinkedHashMap<String, ByteArrayInputStream> xmiData = new LinkedHashMap<String, ByteArrayInputStream>();
        for (int i2 : xmiColumnIndices = IntStream.range(pkLength, fieldConfig.getColumnsToRetrieve().length).filter(i -> !fieldConfig.getColumnsToRetrieve()[i].equals("max_xmi_id") && !fieldConfig.getColumnsToRetrieve()[i].equals("sofa_mapping")).toArray()) {
            if (data[i2] == null) continue;
            String columnName = fieldConfig.getFields().get(i2).get("name");
            if (columnName.equals("base_document")) {
                columnName = "DOCUMENT-MODULE";
            }
            xmiData.put(columnName, new ByteArrayInputStream(data[i2]));
        }
        BinaryXmiBuilder binaryBuilder = new BinaryXmiBuilder(this.getNamespaceMap());
        BinaryJeDISNodeDecoder binaryJeDISNodeDecoder = new BinaryJeDISNodeDecoder(this.annotationColumnsToLoad, true);
        try {
            BinaryDecodingResult decodingResult = binaryJeDISNodeDecoder.decode(xmiData, this.typeSystem, this.reverseBinaryMapping, this.featuresToMapBinary, binaryBuilder.getNamespaces());
            ByteArrayOutputStream baos = binaryBuilder.buildXmi(decodingResult, makeValidXml);
            return baos.toString(StandardCharsets.UTF_8);
        }
        catch (XMIBuilderException | IOException e) {
            throw new CoStoSysException(e);
        }
    }

    public Map<String, String> getNamespaceMap() {
        String nsTable;
        HashMap<String, String> map;
        block12: {
            map = null;
            nsTable = this.xmiMetaSchema + "._xmi_namespaces";
            if (this.dbc.tableExists(nsTable)) {
                log.debug("Reading XMI namespaces from {}", (Object)nsTable);
                try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection(true);){
                    map = new HashMap<String, String>();
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s,%s FROM %s", "prefix", "ns_uri", nsTable);
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        map.put(rs.getString(1), rs.getString(2));
                    }
                    break block12;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null != ne) {
                        ne.printStackTrace();
                    }
                    break block12;
                }
            }
            throw new IllegalStateException("The table " + nsTable + " does not exist. This is an error since it is required to re-build the XMI data. Is '" + this.xmiMetaSchema + "' the correct Postgres schema for the table?");
        }
        log.debug("Got XMI namespace map from table {}: {}", (Object)nsTable, map);
        if (map.isEmpty()) {
            throw new IllegalStateException("The table " + nsTable + " is empty. This is an error since it is required to re-build the XMI data. Is '" + this.xmiMetaSchema + "' the correct Postgres schema for the table?");
        }
        return map;
    }

    private Map<String, Boolean> getFeaturesToMapBinaryFromDb() {
        HashMap<String, Boolean> map;
        block11: {
            map = null;
            String mappingTableName = this.xmiMetaSchema + "._binary_features_to_map";
            if (this.dbc.tableExists(mappingTableName)) {
                try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection(true);){
                    map = new HashMap<String, Boolean>();
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s,%s FROM %s", "feature", "map", mappingTableName);
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        map.put(rs.getString(1), rs.getBoolean(2));
                    }
                    break block11;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null != ne) {
                        ne.printStackTrace();
                    }
                    break block11;
                }
            }
            log.warn("JeDIS XMI annotation module meta table \"{}\" was not found. It is assumed that the table from which is read contains complete XMI documents.", (Object)(this.xmiMetaSchema + "._binary_features_to_map"));
        }
        return map;
    }

    public Map<Integer, String> getReverseBinaryMappingFromDb() {
        HashMap<Integer, String> map;
        block11: {
            map = null;
            String mappingTableName = this.xmiMetaSchema + "._binary_string_mapping";
            if (this.dbc.tableExists(mappingTableName)) {
                try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection(true);){
                    map = new HashMap<Integer, String>();
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s,%s FROM %s", "mapping_id", "mapping_string", mappingTableName);
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        map.put(rs.getInt(1), rs.getString(2));
                    }
                    break block11;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null != ne) {
                        ne.printStackTrace();
                    }
                    break block11;
                }
            }
            log.warn("JeDIS XMI annotation module meta table \"{}\" was not found. It is assumed that the table from which is read contains complete XMI documents.", (Object)(this.xmiMetaSchema + "._binary_string_mapping"));
        }
        return map;
    }
}

