/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.netty3.Netty3MessageChannelHandler;
import org.elasticsearch.transport.netty3.Netty3OpenChannelsHandler;
import org.elasticsearch.transport.netty3.Netty3SizeHeaderFrameDecoder;
import org.elasticsearch.transport.netty3.Netty3Utils;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.AdaptiveReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.ReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;

public class Netty3Transport
extends TcpTransport<Channel> {
    public static final Setting<Integer> WORKER_COUNT;
    public static final Setting<ByteSizeValue> NETTY_MAX_CUMULATION_BUFFER_CAPACITY;
    public static final Setting<Integer> NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_SIZE;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MIN;
    public static final Setting<ByteSizeValue> NETTY_RECEIVE_PREDICTOR_MAX;
    public static final Setting<Integer> NETTY_BOSS_COUNT;
    protected final ByteSizeValue maxCumulationBufferCapacity;
    protected final int maxCompositeBufferComponents;
    protected final ReceiveBufferSizePredictorFactory receiveBufferSizePredictorFactory;
    protected final int workerCount;
    protected final ByteSizeValue receivePredictorMin;
    protected final ByteSizeValue receivePredictorMax;
    volatile Netty3OpenChannelsHandler serverOpenChannels;
    protected volatile ClientBootstrap clientBootstrap;
    protected final Map<String, ServerBootstrap> serverBootstraps = ConcurrentCollections.newConcurrentMap();

    public Netty3Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super("netty3", settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
        this.deprecationLogger.deprecated(this.deprecationMessage(), new Object[0]);
        this.workerCount = WORKER_COUNT.get(settings);
        this.maxCumulationBufferCapacity = NETTY_MAX_CUMULATION_BUFFER_CAPACITY.get(settings);
        this.maxCompositeBufferComponents = NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.receivePredictorMin = NETTY_RECEIVE_PREDICTOR_MIN.get(settings);
        this.receivePredictorMax = NETTY_RECEIVE_PREDICTOR_MAX.get(settings);
        this.receiveBufferSizePredictorFactory = this.receivePredictorMax.getBytes() == this.receivePredictorMin.getBytes() ? new FixedReceiveBufferSizePredictorFactory((int)this.receivePredictorMax.getBytes()) : new AdaptiveReceiveBufferSizePredictorFactory((int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMin.getBytes(), (int)this.receivePredictorMax.getBytes());
    }

    protected String deprecationMessage() {
        return "transport type [netty3] is deprecated";
    }

    TransportServiceAdapter transportServiceAdapter() {
        return this.transportServiceAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        boolean success = false;
        try {
            this.clientBootstrap = this.createClientBootstrap();
            if (NetworkService.NETWORK_SERVER.get(this.settings).booleanValue()) {
                Netty3OpenChannelsHandler openChannels;
                this.serverOpenChannels = openChannels = new Netty3OpenChannelsHandler(this.logger);
                for (Map.Entry<String, Settings> entry : this.buildProfileSettings().entrySet()) {
                    Settings settings = Settings.builder().put(this.createFallbackSettings()).put(entry.getValue()).build();
                    this.createServerBootstrap(entry.getKey(), settings);
                    this.bindServer(entry.getKey(), settings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    private ClientBootstrap createClientBootstrap() {
        ByteSizeValue tcpReceiveBufferSize;
        if (this.blockingClient) {
            this.clientBootstrap = new ClientBootstrap(new OioClientSocketChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_worker"))));
        } else {
            int bossCount = NETTY_BOSS_COUNT.get(this.settings);
            this.clientBootstrap = new ClientBootstrap(new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_boss")), bossCount, new NioWorkerPool(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_worker")), this.workerCount), new HashedWheelTimer(EsExecutors.daemonThreadFactory(this.settings, "transport_client_timer"))));
        }
        this.clientBootstrap.setPipelineFactory(this.configureClientChannelPipelineFactory());
        this.clientBootstrap.setOption("connectTimeoutMillis", this.defaultConnectionProfile.getConnectTimeout().millis());
        boolean tcpNoDelay = (Boolean)TCP_NO_DELAY.get(this.settings);
        this.clientBootstrap.setOption("tcpNoDelay", tcpNoDelay);
        boolean tcpKeepAlive = (Boolean)TCP_KEEP_ALIVE.get(this.settings);
        this.clientBootstrap.setOption("keepAlive", tcpKeepAlive);
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TCP_SEND_BUFFER_SIZE.get(this.settings);
        if (tcpSendBufferSize.getBytes() > 0L) {
            this.clientBootstrap.setOption("sendBufferSize", tcpSendBufferSize.getBytes());
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            this.clientBootstrap.setOption("receiveBufferSize", tcpReceiveBufferSize.getBytes());
        }
        this.clientBootstrap.setOption("receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        boolean reuseAddress = (Boolean)TCP_REUSE_ADDRESS.get(this.settings);
        this.clientBootstrap.setOption("reuseAddress", reuseAddress);
        return this.clientBootstrap;
    }

    private Settings createFallbackSettings() {
        ByteSizeValue fallbackTcpBufferSize;
        List<String> fallbackPublishHost;
        Settings.Builder fallbackSettingsBuilder = Settings.builder();
        List<String> fallbackBindHost = TransportSettings.BIND_HOST.get(this.settings);
        if (!fallbackBindHost.isEmpty()) {
            fallbackSettingsBuilder.putArray("bind_host", fallbackBindHost);
        }
        if (!(fallbackPublishHost = TransportSettings.PUBLISH_HOST.get(this.settings)).isEmpty()) {
            fallbackSettingsBuilder.putArray("publish_host", fallbackPublishHost);
        }
        boolean fallbackTcpNoDelay = this.settings.getAsBoolean("transport.netty.tcp_no_delay", NetworkService.TcpSettings.TCP_NO_DELAY.get(this.settings));
        fallbackSettingsBuilder.put("tcp_no_delay", fallbackTcpNoDelay);
        boolean fallbackTcpKeepAlive = this.settings.getAsBoolean("transport.netty.tcp_keep_alive", NetworkService.TcpSettings.TCP_KEEP_ALIVE.get(this.settings));
        fallbackSettingsBuilder.put("tcp_keep_alive", fallbackTcpKeepAlive);
        boolean fallbackReuseAddress = this.settings.getAsBoolean("transport.netty.reuse_address", NetworkService.TcpSettings.TCP_REUSE_ADDRESS.get(this.settings));
        fallbackSettingsBuilder.put("reuse_address", fallbackReuseAddress);
        ByteSizeValue fallbackTcpSendBufferSize = this.settings.getAsBytesSize("transport.netty.tcp_send_buffer_size", (ByteSizeValue)TCP_SEND_BUFFER_SIZE.get(this.settings));
        if (fallbackTcpSendBufferSize.getBytes() >= 0L) {
            fallbackSettingsBuilder.put("tcp_send_buffer_size", fallbackTcpSendBufferSize);
        }
        if ((fallbackTcpBufferSize = this.settings.getAsBytesSize("transport.netty.tcp_receive_buffer_size", (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings))).getBytes() >= 0L) {
            fallbackSettingsBuilder.put("tcp_receive_buffer_size", fallbackTcpBufferSize);
        }
        return fallbackSettingsBuilder.build();
    }

    private void createServerBootstrap(String name, Settings settings) {
        boolean blockingServer = (Boolean)TCP_BLOCKING_SERVER.get(settings);
        String port = settings.get("port");
        String bindHost = settings.get("bind_host");
        String publishHost = settings.get("publish_host");
        String tcpNoDelay = settings.get("tcp_no_delay");
        String tcpKeepAlive = settings.get("tcp_keep_alive");
        boolean reuseAddress = settings.getAsBoolean("reuse_address", NetworkUtils.defaultReuseAddress());
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TCP_SEND_BUFFER_SIZE.getDefault(settings);
        ByteSizeValue tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.getDefault(settings);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using profile[{}], worker_count[{}], port[{}], bind_host[{}], publish_host[{}], compress[{}], connect_timeout[{}], connections_per_node[{}/{}/{}/{}/{}], receive_predictor[{}->{}]", new Object[]{name, this.workerCount, port, bindHost, publishHost, this.compress, this.defaultConnectionProfile.getConnectTimeout(), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.RECOVERY), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.BULK), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.REG), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.STATE), this.defaultConnectionProfile.getNumConnectionsPerType(TransportRequestOptions.Type.PING), this.receivePredictorMin, this.receivePredictorMax});
        }
        ThreadFactory bossFactory = EsExecutors.daemonThreadFactory(this.settings, "transport_server_boss", name);
        ThreadFactory workerFactory = EsExecutors.daemonThreadFactory(this.settings, "transport_server_worker", name);
        ServerBootstrap serverBootstrap = blockingServer ? new ServerBootstrap(new OioServerSocketChannelFactory(Executors.newCachedThreadPool(bossFactory), Executors.newCachedThreadPool(workerFactory))) : new ServerBootstrap(new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), Executors.newCachedThreadPool(workerFactory), this.workerCount));
        serverBootstrap.setPipelineFactory(this.configureServerChannelPipelineFactory(name, settings));
        if (!"default".equals(tcpNoDelay)) {
            serverBootstrap.setOption("child.tcpNoDelay", Booleans.parseBoolean(tcpNoDelay, null));
        }
        if (!"default".equals(tcpKeepAlive)) {
            serverBootstrap.setOption("child.keepAlive", Booleans.parseBoolean(tcpKeepAlive, null));
        }
        if (tcpSendBufferSize != null && tcpSendBufferSize.getBytes() > 0L) {
            serverBootstrap.setOption("child.sendBufferSize", tcpSendBufferSize.getBytes());
        }
        if (tcpReceiveBufferSize != null && tcpReceiveBufferSize.getBytes() > 0L) {
            serverBootstrap.setOption("child.receiveBufferSize", tcpReceiveBufferSize.getBytes());
        }
        serverBootstrap.setOption("receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        serverBootstrap.setOption("child.receiveBufferSizePredictorFactory", this.receiveBufferSizePredictorFactory);
        serverBootstrap.setOption("reuseAddress", reuseAddress);
        serverBootstrap.setOption("child.reuseAddress", reuseAddress);
        this.serverBootstraps.put(name, serverBootstrap);
    }

    protected final void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.onException(ctx.getChannel(), e.getCause() == null || e.getCause() instanceof Exception ? (Exception)e.getCause() : new ElasticsearchException(e.getCause()));
    }

    @Override
    public long serverOpen() {
        Netty3OpenChannelsHandler channels = this.serverOpenChannels;
        return channels == null ? 0L : channels.numberOfOpenChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TcpTransport.NodeChannels connectToChannels(DiscoveryNode node, ConnectionProfile profile) {
        Channel[] channels = new Channel[profile.getNumConnections()];
        TcpTransport.NodeChannels nodeChannels = new TcpTransport.NodeChannels(node, channels, profile);
        boolean success = false;
        try {
            TimeValue connectTimeout;
            ClientBootstrap clientBootstrap;
            TimeValue defaultConnectTimeout = this.defaultConnectionProfile.getConnectTimeout();
            if (profile.getConnectTimeout() != null && !profile.getConnectTimeout().equals(defaultConnectTimeout)) {
                clientBootstrap = new ClientBootstrap(this.clientBootstrap.getFactory());
                clientBootstrap.setPipelineFactory(this.clientBootstrap.getPipelineFactory());
                clientBootstrap.setOptions(this.clientBootstrap.getOptions());
                clientBootstrap.setOption("connectTimeoutMillis", Math.toIntExact(profile.getConnectTimeout().millis()));
                connectTimeout = profile.getConnectTimeout();
            } else {
                connectTimeout = defaultConnectTimeout;
                clientBootstrap = this.clientBootstrap;
            }
            ArrayList<ChannelFuture> connections = new ArrayList<ChannelFuture>(channels.length);
            InetSocketAddress address = ((InetSocketTransportAddress)node.getAddress()).address();
            for (int i = 0; i < channels.length; ++i) {
                connections.add(clientBootstrap.connect(address));
            }
            Iterator iterator = connections.iterator();
            try {
                for (int i = 0; i < channels.length; ++i) {
                    assert (iterator.hasNext());
                    ChannelFuture future = (ChannelFuture)iterator.next();
                    future.awaitUninterruptibly((long)((double)connectTimeout.millis() * 1.5));
                    if (!future.isSuccess()) {
                        throw new ConnectTransportException(node, "connect_timeout[" + connectTimeout + "]", future.getCause());
                    }
                    channels[i] = future.getChannel();
                    channels[i].getCloseFuture().addListener(new ChannelCloseListener(node));
                }
                assert (!iterator.hasNext()) : "not all created connection have been consumed";
            }
            catch (RuntimeException e) {
                for (ChannelFuture future : Collections.unmodifiableList(connections)) {
                    future.cancel();
                    if (future.getChannel() == null || !future.getChannel().isOpen()) continue;
                    try {
                        future.getChannel().close();
                    }
                    catch (Exception exception) {}
                }
                throw e;
            }
            success = true;
        }
        finally {
            if (!success) {
                try {
                    nodeChannels.close();
                }
                catch (IOException e) {
                    this.logger.trace("exception while closing channels", (Throwable)e);
                }
            }
        }
        return nodeChannels;
    }

    public ChannelPipelineFactory configureClientChannelPipelineFactory() {
        return new ClientChannelPipelineFactory(this);
    }

    public ChannelPipelineFactory configureServerChannelPipelineFactory(String name, Settings settings) {
        return new ServerChannelPipelineFactory(this, name, settings);
    }

    @Override
    protected void sendMessage(Channel channel, BytesReference reference, Runnable sendListener) {
        ChannelFuture future = channel.write(Netty3Utils.toChannelBuffer(reference));
        future.addListener(future1 -> sendListener.run());
    }

    @Override
    protected void closeChannels(List<Channel> channels) {
        ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
        for (Channel channel : channels) {
            try {
                if (channel == null || !channel.isOpen()) continue;
                futures.add(channel.close());
            }
            catch (Exception e) {
                this.logger.trace("failed to close channel", (Throwable)e);
            }
        }
        for (ChannelFuture future : futures) {
            future.awaitUninterruptibly();
        }
    }

    @Override
    protected InetSocketAddress getLocalAddress(Channel channel) {
        return (InetSocketAddress)channel.getLocalAddress();
    }

    @Override
    protected Channel bind(String name, InetSocketAddress address) {
        return this.serverBootstraps.get(name).bind(address);
    }

    TcpTransport.ScheduledPing getPing() {
        return this.scheduledPing;
    }

    @Override
    protected boolean isOpen(Channel channel) {
        return channel.isOpen();
    }

    @Override
    protected void stopInternal() {
        Releasables.close(this.serverOpenChannels, () -> {
            for (Map.Entry<String, ServerBootstrap> entry : this.serverBootstraps.entrySet()) {
                String name = entry.getKey();
                ServerBootstrap serverBootstrap = entry.getValue();
                try {
                    serverBootstrap.releaseExternalResources();
                }
                catch (Exception e) {
                    this.logger.debug(() -> new ParameterizedMessage("Error closing serverBootstrap for profile [{}]", (Object)name), (Throwable)e);
                }
            }
            this.serverBootstraps.clear();
            if (this.clientBootstrap != null) {
                this.clientBootstrap.releaseExternalResources();
                this.clientBootstrap = null;
            }
        });
    }

    static {
        Netty3Utils.setup();
        WORKER_COUNT = new Setting<Integer>("transport.netty.worker_count", s2 -> Integer.toString(EsExecutors.boundedNumberOfProcessors(s2) * 2), s2 -> Setting.parseInt(s2, 1, "transport.netty.worker_count"), Setting.Property.NodeScope, Setting.Property.Shared);
        NETTY_MAX_CUMULATION_BUFFER_CAPACITY = Setting.byteSizeSetting("transport.netty.max_cumulation_buffer_capacity", new ByteSizeValue(-1L), Setting.Property.NodeScope, Setting.Property.Shared);
        NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = Setting.intSetting("transport.netty.max_composite_buffer_components", -1, -1, Setting.Property.NodeScope, Setting.Property.Shared);
        NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting("transport.netty.receive_predictor_size", settings -> {
            long defaultReceiverPredictor = 524288L;
            if (JvmInfo.jvmInfo().getMem().getDirectMemoryMax().getBytes() > 0L) {
                long l = (long)(0.3 * (double)JvmInfo.jvmInfo().getMem().getDirectMemoryMax().getBytes() / (double)WORKER_COUNT.get((Settings)settings).intValue());
                defaultReceiverPredictor = Math.min(defaultReceiverPredictor, Math.max(l, 65536L));
            }
            return new ByteSizeValue(defaultReceiverPredictor).toString();
        }, Setting.Property.NodeScope, Setting.Property.Shared);
        NETTY_RECEIVE_PREDICTOR_MIN = Setting.byteSizeSetting("transport.netty.receive_predictor_min", NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope, Setting.Property.Shared);
        NETTY_RECEIVE_PREDICTOR_MAX = Setting.byteSizeSetting("transport.netty.receive_predictor_max", NETTY_RECEIVE_PREDICTOR_SIZE, Setting.Property.NodeScope, Setting.Property.Shared);
        NETTY_BOSS_COUNT = Setting.intSetting("transport.netty.boss_count", 1, 1, Setting.Property.NodeScope, Setting.Property.Shared);
    }

    protected class ChannelCloseListener
    implements ChannelFutureListener {
        private final DiscoveryNode node;

        private ChannelCloseListener(DiscoveryNode node) {
            this.node = node;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            Netty3Transport.this.onChannelClosed(future.getChannel());
            TcpTransport.NodeChannels nodeChannels = (TcpTransport.NodeChannels)Netty3Transport.this.connectedNodes.get(this.node);
            if (nodeChannels != null && nodeChannels.hasChannel(future.getChannel())) {
                Netty3Transport.this.threadPool.generic().execute(() -> Netty3Transport.this.disconnectFromNode(this.node, future.getChannel(), "channel closed event"));
            }
        }
    }

    protected static class ServerChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final Netty3Transport nettyTransport;
        protected final String name;
        protected final Settings settings;

        public ServerChannelPipelineFactory(Netty3Transport nettyTransport, String name, Settings settings) {
            this.nettyTransport = nettyTransport;
            this.name = name;
            this.settings = settings;
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline channelPipeline = Channels.pipeline();
            channelPipeline.addLast("openChannels", this.nettyTransport.serverOpenChannels);
            Netty3SizeHeaderFrameDecoder sizeHeader = new Netty3SizeHeaderFrameDecoder();
            if (this.nettyTransport.maxCumulationBufferCapacity.getBytes() > 0L) {
                if (this.nettyTransport.maxCumulationBufferCapacity.getBytes() > Integer.MAX_VALUE) {
                    sizeHeader.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    sizeHeader.setMaxCumulationBufferCapacity((int)this.nettyTransport.maxCumulationBufferCapacity.getBytes());
                }
            }
            if (this.nettyTransport.maxCompositeBufferComponents != -1) {
                sizeHeader.setMaxCumulationBufferComponents(this.nettyTransport.maxCompositeBufferComponents);
            }
            channelPipeline.addLast("size", sizeHeader);
            channelPipeline.addLast("dispatcher", new Netty3MessageChannelHandler(this.nettyTransport, this.name));
            return channelPipeline;
        }
    }

    protected static class ClientChannelPipelineFactory
    implements ChannelPipelineFactory {
        protected final Netty3Transport nettyTransport;

        public ClientChannelPipelineFactory(Netty3Transport nettyTransport) {
            this.nettyTransport = nettyTransport;
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline channelPipeline = Channels.pipeline();
            Netty3SizeHeaderFrameDecoder sizeHeader = new Netty3SizeHeaderFrameDecoder();
            if (this.nettyTransport.maxCumulationBufferCapacity.getBytes() >= 0L) {
                if (this.nettyTransport.maxCumulationBufferCapacity.getBytes() > Integer.MAX_VALUE) {
                    sizeHeader.setMaxCumulationBufferCapacity(Integer.MAX_VALUE);
                } else {
                    sizeHeader.setMaxCumulationBufferCapacity((int)this.nettyTransport.maxCumulationBufferCapacity.getBytes());
                }
            }
            if (this.nettyTransport.maxCompositeBufferComponents != -1) {
                sizeHeader.setMaxCumulationBufferComponents(this.nettyTransport.maxCompositeBufferComponents);
            }
            channelPipeline.addLast("size", sizeHeader);
            channelPipeline.addLast("dispatcher", new Netty3MessageChannelHandler(this.nettyTransport, ".client"));
            return channelPipeline;
        }
    }
}

