/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.local;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.LocalTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportSerializationException;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.TransportStatus;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.local.LocalTransportChannel;

public class LocalTransport
extends AbstractLifecycleComponent
implements Transport {
    public static final String LOCAL_TRANSPORT_THREAD_NAME_PREFIX = "local_transport";
    final ThreadPool threadPool;
    private final ThreadPoolExecutor workers;
    private volatile TransportServiceAdapter transportServiceAdapter;
    private volatile BoundTransportAddress boundAddress;
    private volatile LocalTransportAddress localAddress;
    private static final ConcurrentMap<LocalTransportAddress, LocalTransport> transports = ConcurrentCollections.newConcurrentMap();
    private static final AtomicLong transportAddressIdGenerator = new AtomicLong();
    private final ConcurrentMap<DiscoveryNode, LocalTransport> connectedNodes = ConcurrentCollections.newConcurrentMap();
    protected final NamedWriteableRegistry namedWriteableRegistry;
    private final CircuitBreakerService circuitBreakerService;
    private final AtomicLong requestIdGenerator = new AtomicLong();
    public static final String TRANSPORT_LOCAL_ADDRESS = "transport.local.address";
    public static final String TRANSPORT_LOCAL_WORKERS = "transport.local.workers";
    public static final String TRANSPORT_LOCAL_QUEUE = "transport.local.queue";

    public LocalTransport(Settings settings, ThreadPool threadPool, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super(settings);
        this.threadPool = threadPool;
        int workerCount = this.settings.getAsInt(TRANSPORT_LOCAL_WORKERS, EsExecutors.boundedNumberOfProcessors(settings));
        int queueSize = this.settings.getAsInt(TRANSPORT_LOCAL_QUEUE, -1);
        this.logger.debug("creating [{}] workers, queue_size [{}]", (Object)workerCount, (Object)queueSize);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(this.settings, LOCAL_TRANSPORT_THREAD_NAME_PREFIX);
        this.workers = EsExecutors.newFixed(LOCAL_TRANSPORT_THREAD_NAME_PREFIX, workerCount, queueSize, threadFactory, threadPool.getThreadContext());
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.circuitBreakerService = circuitBreakerService;
    }

    @Override
    public TransportAddress[] addressesFromString(String address, int perAddressLimit) {
        return new TransportAddress[]{new LocalTransportAddress(address)};
    }

    @Override
    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return LocalTransportAddress.class.equals(address);
    }

    @Override
    protected void doStart() {
        String address = this.settings.get(TRANSPORT_LOCAL_ADDRESS);
        if (address == null) {
            address = Long.toString(transportAddressIdGenerator.incrementAndGet());
        }
        this.localAddress = new LocalTransportAddress(address);
        LocalTransport previous = transports.put(this.localAddress, this);
        if (previous != null) {
            throw new ElasticsearchException("local address [" + address + "] is already bound", new Object[0]);
        }
        this.boundAddress = new BoundTransportAddress(new TransportAddress[]{this.localAddress}, this.localAddress);
    }

    @Override
    protected void doStop() {
        transports.remove(this.localAddress);
        for (LocalTransport targetTransport : transports.values()) {
            for (Map.Entry entry : targetTransport.connectedNodes.entrySet()) {
                if (entry.getValue() != this) continue;
                targetTransport.disconnectFromNode((DiscoveryNode)entry.getKey());
            }
        }
    }

    @Override
    protected void doClose() {
        ThreadPool.terminate(this.workers, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void transportServiceAdapter(TransportServiceAdapter transportServiceAdapter) {
        this.transportServiceAdapter = transportServiceAdapter;
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return Collections.emptyMap();
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, CheckedBiConsumer<Transport.Connection, ConnectionProfile, IOException> connectionValidator) throws ConnectTransportException {
        LocalTransport localTransport = this;
        synchronized (localTransport) {
            if (this.connectedNodes.containsKey(node)) {
                return;
            }
            LocalTransport targetTransport = (LocalTransport)transports.get(node.getAddress());
            if (targetTransport == null) {
                throw new ConnectTransportException(node, "Failed to connect");
            }
            this.connectedNodes.put(node, targetTransport);
            this.transportServiceAdapter.onNodeConnected(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        LocalTransport localTransport = this;
        synchronized (localTransport) {
            LocalTransport removed = (LocalTransport)this.connectedNodes.remove(node);
            if (removed != null) {
                this.transportServiceAdapter.onNodeDisconnected(node);
            }
        }
    }

    @Override
    public long serverOpen() {
        return 0L;
    }

    @Override
    public Transport.Connection getConnection(DiscoveryNode node) {
        LocalTransport targetTransport = (LocalTransport)this.connectedNodes.get(node);
        if (targetTransport == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return this.getConnectionForTransport(targetTransport, node);
    }

    @Override
    public Transport.Connection openConnection(DiscoveryNode node, ConnectionProfile profile) throws IOException {
        LocalTransport targetTransport = (LocalTransport)transports.get(node.getAddress());
        if (targetTransport == null) {
            throw new ConnectTransportException(node, "Failed to connect");
        }
        return this.getConnectionForTransport(targetTransport, node);
    }

    private Transport.Connection getConnectionForTransport(final LocalTransport targetTransport, final DiscoveryNode node) {
        return new Transport.Connection(){

            @Override
            public DiscoveryNode getNode() {
                return node;
            }

            @Override
            public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
                if (transports.get(node.getAddress()) != targetTransport) {
                    throw new NodeNotConnectedException(node, " got disconnected");
                }
                LocalTransport.this.sendRequest(targetTransport, node, requestId, action, request, options);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    protected void sendRequest(LocalTransport targetTransport, DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
        Version version2 = Version.min(node.getVersion(), this.getVersion());
        try (BytesStreamOutput stream = new BytesStreamOutput();){
            stream.setVersion(version2);
            stream.writeLong(requestId);
            byte status = 0;
            status = TransportStatus.setRequest(status);
            stream.writeByte(status);
            this.threadPool.getThreadContext().writeTo(stream);
            stream.writeString(action);
            request.writeTo(stream);
            stream.close();
            byte[] data = BytesReference.toBytes(stream.bytes());
            this.transportServiceAdapter.addBytesSent(data.length);
            this.transportServiceAdapter.onRequestSent(node, requestId, action, request, options);
            targetTransport.receiveMessage(version2, data, action, requestId, this);
        }
    }

    public void receiveMessage(Version version2, byte[] data, String action, @Nullable Long requestId, LocalTransport sourceTransport) {
        try {
            this.workers().execute(() -> {
                ThreadContext threadContext = this.threadPool.getThreadContext();
                try (ThreadContext.StoredContext context = threadContext.stashContext();){
                    this.processReceivedMessage(data, action, sourceTransport, version2, requestId);
                }
            });
        }
        catch (EsRejectedExecutionException e) {
            assert (!this.lifecycle.started());
            this.logger.trace("received request but shutting down. ignoring. action [{}], request id [{}]", (Object)action, (Object)requestId);
        }
    }

    ThreadPoolExecutor workers() {
        return this.workers;
    }

    CircuitBreaker inFlightRequestsBreaker() {
        return this.circuitBreakerService.getBreaker("in_flight_requests");
    }

    protected void processReceivedMessage(byte[] data, String action, LocalTransport sourceTransport, Version version2, @Nullable Long sendRequestId) {
        Transports.assertTransportThread();
        try {
            this.transportServiceAdapter.addBytesReceived(data.length);
            StreamInput stream = StreamInput.wrap(data);
            stream.setVersion(version2);
            long requestId = stream.readLong();
            byte status = stream.readByte();
            boolean isRequest = TransportStatus.isRequest(status);
            this.threadPool.getThreadContext().readHeaders(stream);
            if (isRequest) {
                this.handleRequest(stream, requestId, data.length, sourceTransport, version2);
            } else {
                TransportResponseHandler handler = this.transportServiceAdapter.onResponseReceived(requestId);
                if (handler != null) {
                    if (TransportStatus.isError(status)) {
                        this.handleResponseError(stream, handler);
                    } else {
                        this.handleResponse(stream, sourceTransport, handler);
                    }
                }
            }
        }
        catch (Exception e) {
            if (sendRequestId != null) {
                TransportResponseHandler handler = sourceTransport.transportServiceAdapter.onResponseReceived(sendRequestId);
                if (handler != null) {
                    RemoteTransportException error = new RemoteTransportException(this.nodeName(), this.localAddress, action, e);
                    sourceTransport.workers().execute(() -> {
                        ThreadContext threadContext = sourceTransport.threadPool.getThreadContext();
                        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                            sourceTransport.handleException(handler, error);
                        }
                    });
                }
            }
            this.logger.warn(() -> new ParameterizedMessage("Failed to receive message for action [{}]", (Object)action), (Throwable)e);
        }
    }

    private void handleRequest(StreamInput stream, long requestId, int messageLengthBytes, LocalTransport sourceTransport, Version version2) throws Exception {
        stream = new NamedWriteableAwareStreamInput(stream, this.namedWriteableRegistry);
        String action = stream.readString();
        final RequestHandlerRegistry reg = this.transportServiceAdapter.getRequestHandler(action);
        this.transportServiceAdapter.onRequestReceived(requestId, action);
        if (reg != null && reg.canTripCircuitBreaker()) {
            this.inFlightRequestsBreaker().addEstimateBytesAndMaybeBreak(messageLengthBytes, "<transport_request>");
        } else {
            this.inFlightRequestsBreaker().addWithoutBreaking(messageLengthBytes);
        }
        LocalTransportChannel transportChannel = new LocalTransportChannel(this, this.transportServiceAdapter, sourceTransport, action, requestId, version2, messageLengthBytes, this.threadPool.getThreadContext());
        try {
            if (reg == null) {
                throw new ActionNotFoundTransportException("Action [" + action + "] not found");
            }
            Object request = reg.newRequest();
            ((TransportMessage)request).remoteAddress(sourceTransport.boundAddress.publishAddress());
            ((TransportRequest)request).readFrom(stream);
            if ("same".equals(reg.getExecutor())) {
                reg.processMessageReceived(request, transportChannel);
            } else {
                this.threadPool.executor(reg.getExecutor()).execute(new AbstractRunnable((TransportRequest)request, transportChannel, action){
                    final /* synthetic */ TransportRequest val$request;
                    final /* synthetic */ LocalTransportChannel val$transportChannel;
                    final /* synthetic */ String val$action;
                    {
                        this.val$request = transportRequest;
                        this.val$transportChannel = localTransportChannel;
                        this.val$action = string;
                    }

                    @Override
                    protected void doRun() throws Exception {
                        reg.processMessageReceived(this.val$request, this.val$transportChannel);
                    }

                    @Override
                    public boolean isForceExecution() {
                        return reg.isForceExecution();
                    }

                    @Override
                    public void onFailure(Exception e) {
                        if (LocalTransport.this.lifecycleState() == Lifecycle.State.STARTED) {
                            try {
                                this.val$transportChannel.sendResponse(e);
                            }
                            catch (Exception inner) {
                                inner.addSuppressed(e);
                                LocalTransport.this.logger.warn(() -> new ParameterizedMessage("Failed to send error message back to client for action [{}]", (Object)this.val$action), (Throwable)inner);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            try {
                transportChannel.sendResponse(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.logger.warn(() -> new ParameterizedMessage("Failed to send error message back to client for action [{}]", (Object)action), (Throwable)inner);
            }
        }
    }

    protected void handleResponse(StreamInput buffer, LocalTransport sourceTransport, TransportResponseHandler handler) {
        buffer = new NamedWriteableAwareStreamInput(buffer, this.namedWriteableRegistry);
        Object response = handler.newInstance();
        ((TransportMessage)response).remoteAddress(sourceTransport.boundAddress.publishAddress());
        try {
            ((TransportMessage)response).readFrom(buffer);
        }
        catch (Exception e) {
            this.handleException(handler, new TransportSerializationException("Failed to deserialize response of type [" + response.getClass().getName() + "]", e));
            return;
        }
        this.handleParsedResponse((TransportResponse)response, handler);
    }

    protected void handleParsedResponse(TransportResponse response, TransportResponseHandler handler) {
        this.threadPool.executor(handler.executor()).execute(() -> {
            try {
                handler.handleResponse(response);
            }
            catch (Exception e) {
                this.handleException(handler, new ResponseHandlerFailureTransportException(e));
            }
        });
    }

    private void handleResponseError(StreamInput buffer, TransportResponseHandler handler) {
        Object exception;
        try {
            exception = buffer.readException();
        }
        catch (Exception e) {
            exception = new TransportSerializationException("Failed to deserialize exception response from stream", e);
        }
        this.handleException(handler, (Exception)exception);
    }

    private void handleException(TransportResponseHandler handler, Exception exception) {
        if (!(exception instanceof RemoteTransportException)) {
            exception = new RemoteTransportException("Not a remote transport exception", null, null, exception);
        }
        RemoteTransportException rtx = (RemoteTransportException)exception;
        try {
            handler.handleException(rtx);
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to handle exception response [{}]", (Object)handler), (Throwable)e);
        }
    }

    @Override
    public List<String> getLocalAddresses() {
        return Collections.singletonList("0.0.0.0");
    }

    @Override
    public long newRequestId() {
        return this.requestIdGenerator.incrementAndGet();
    }

    protected Version getVersion() {
        return Version.CURRENT;
    }
}

