/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class CollectorResult
implements ToXContentObject,
Writeable {
    public static final String REASON_SEARCH_COUNT = "search_count";
    public static final String REASON_SEARCH_TOP_HITS = "search_top_hits";
    public static final String REASON_SEARCH_TERMINATE_AFTER_COUNT = "search_terminate_after_count";
    public static final String REASON_SEARCH_POST_FILTER = "search_post_filter";
    public static final String REASON_SEARCH_MIN_SCORE = "search_min_score";
    public static final String REASON_SEARCH_MULTI = "search_multi";
    public static final String REASON_SEARCH_TIMEOUT = "search_timeout";
    public static final String REASON_SEARCH_CANCELLED = "search_cancelled";
    public static final String REASON_AGGREGATION = "aggregation";
    public static final String REASON_AGGREGATION_GLOBAL = "aggregation_global";
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    private static final ParseField TIME = new ParseField("time", new String[0]);
    private static final ParseField TIME_NANOS = new ParseField("time_in_nanos", new String[0]);
    private static final ParseField CHILDREN = new ParseField("children", new String[0]);
    private final String collectorName;
    private final String reason;
    private final Long time;
    private List<CollectorResult> children;

    public CollectorResult(String collectorName, String reason, Long time, List<CollectorResult> children) {
        this.collectorName = collectorName;
        this.reason = reason;
        this.time = time;
        this.children = children;
    }

    public CollectorResult(StreamInput in) throws IOException {
        this.collectorName = in.readString();
        this.reason = in.readString();
        this.time = in.readLong();
        int size = in.readVInt();
        this.children = new ArrayList<CollectorResult>(size);
        for (int i = 0; i < size; ++i) {
            CollectorResult child = new CollectorResult(in);
            this.children.add(child);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.collectorName);
        out.writeString(this.reason);
        out.writeLong(this.time);
        out.writeVInt(this.children.size());
        for (CollectorResult child : this.children) {
            child.writeTo(out);
        }
    }

    public long getTime() {
        return this.time;
    }

    public String getReason() {
        return this.reason;
    }

    public String getName() {
        return this.collectorName;
    }

    public List<CollectorResult> getProfiledChildren() {
        return this.children;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder = builder.startObject().field(NAME.getPreferredName(), this.getName()).field(REASON.getPreferredName(), this.getReason()).field(TIME.getPreferredName(), String.format(Locale.US, "%.10gms", (double)this.getTime() / 1000000.0)).field(TIME_NANOS.getPreferredName(), this.getTime());
        if (!this.children.isEmpty()) {
            builder = builder.startArray(CHILDREN.getPreferredName());
            for (CollectorResult child : this.children) {
                builder = child.toXContent(builder, params);
            }
            builder = builder.endArray();
        }
        builder = builder.endObject();
        return builder;
    }

    public static CollectorResult fromXContent(XContentParser parser2) throws IOException {
        XContentParser.Token token = parser2.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser2::getTokenLocation);
        String currentFieldName = null;
        String name = null;
        String reason = null;
        long time = -1L;
        ArrayList<CollectorResult> children = new ArrayList<CollectorResult>();
        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser2.currentName();
                continue;
            }
            if (token.isValue()) {
                if (NAME.match(currentFieldName)) {
                    name = parser2.text();
                    continue;
                }
                if (REASON.match(currentFieldName)) {
                    reason = parser2.text();
                    continue;
                }
                if (TIME.match(currentFieldName)) {
                    parser2.text();
                    continue;
                }
                if (TIME_NANOS.match(currentFieldName)) {
                    time = parser2.longValue();
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser2.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (CHILDREN.match(currentFieldName)) {
                    while ((token = parser2.nextToken()) != XContentParser.Token.END_ARRAY) {
                        children.add(CollectorResult.fromXContent(parser2));
                    }
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser2.getTokenLocation());
                continue;
            }
            XContentParserUtils.throwUnknownToken(token, parser2.getTokenLocation());
        }
        return new CollectorResult(name, reason, time, children);
    }
}

