/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.search.internal.ShardSearchRequest;

public final class AliasFilter
implements Writeable {
    private final String[] aliases;
    private final QueryBuilder filter;
    private final boolean reparseAliases;

    public AliasFilter(QueryBuilder filter, String ... aliases) {
        this.aliases = aliases == null ? Strings.EMPTY_ARRAY : aliases;
        this.filter = filter;
        this.reparseAliases = false;
    }

    public AliasFilter(StreamInput input) throws IOException {
        this.aliases = input.readStringArray();
        if (input.getVersion().onOrAfter(Version.V_5_1_1_UNRELEASED)) {
            this.filter = input.readOptionalNamedWriteable(QueryBuilder.class);
            this.reparseAliases = false;
        } else {
            this.reparseAliases = true;
            this.filter = null;
        }
    }

    private QueryBuilder reparseFilter(QueryRewriteContext context) {
        if (this.reparseAliases) {
            IndexMetaData indexMetaData = context.getIndexSettings().getIndexMetaData();
            CheckedFunction<byte[], Optional<QueryBuilder>, IOException> filterParser = bytes -> {
                try (XContentParser parser2 = XContentFactory.xContent(bytes).createParser(context.getXContentRegistry(), (byte[])bytes);){
                    Optional<QueryBuilder> optional = context.newParseContext(parser2).parseInnerQueryBuilder();
                    return optional;
                }
            };
            return ShardSearchRequest.parseAliasFilter(filterParser, indexMetaData, this.aliases);
        }
        return this.filter;
    }

    AliasFilter rewrite(QueryRewriteContext context) throws IOException {
        QueryBuilder queryBuilder = this.reparseFilter(context);
        if (queryBuilder != null) {
            return new AliasFilter(QueryBuilder.rewriteQuery(queryBuilder, context), this.aliases);
        }
        return new AliasFilter(this.filter, this.aliases);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.aliases);
        if (out.getVersion().onOrAfter(Version.V_5_1_1_UNRELEASED)) {
            out.writeOptionalNamedWriteable(this.filter);
        }
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public QueryBuilder getQueryBuilder() {
        if (this.reparseAliases) {
            throw new IllegalStateException("alias filter for aliases: " + Arrays.toString(this.aliases) + " must be rewritten first");
        }
        return this.filter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasFilter that = (AliasFilter)o;
        return this.reparseAliases == that.reparseAliases && Arrays.equals(this.aliases, that.aliases) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.aliases, this.filter, this.reparseAliases);
    }

    public String toString() {
        return "AliasFilter{aliases=" + Arrays.toString(this.aliases) + ", filter=" + this.filter + ", reparseAliases=" + this.reparseAliases + '}';
    }
}

