/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregationBuilder;

public abstract class BucketMetricsParser
implements PipelineAggregator.Parser {
    public static final ParseField FORMAT = new ParseField("format", new String[0]);

    @Override
    public final BucketMetricsPipelineAggregationBuilder<?> parse(String pipelineAggregatorName, QueryParseContext context) throws IOException {
        XContentParser.Token token;
        XContentParser parser2 = context.parser();
        String currentFieldName = null;
        String[] bucketsPaths = null;
        String format = null;
        BucketHelpers.GapPolicy gapPolicy = null;
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser2.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (FORMAT.match(currentFieldName)) {
                    format = parser2.text();
                    continue;
                }
                if (BUCKETS_PATH.match(currentFieldName)) {
                    bucketsPaths = new String[]{parser2.text()};
                    continue;
                }
                if (GAP_POLICY.match(currentFieldName)) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(context, parser2.text(), parser2.getTokenLocation());
                    continue;
                }
                this.parseToken(pipelineAggregatorName, parser2, context, currentFieldName, token, params);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (BUCKETS_PATH.match(currentFieldName)) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser2.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser2.text();
                        paths.add(path);
                    }
                    bucketsPaths = paths.toArray(new String[paths.size()]);
                    continue;
                }
                this.parseToken(pipelineAggregatorName, parser2, context, currentFieldName, token, params);
                continue;
            }
            this.parseToken(pipelineAggregatorName, parser2, context, currentFieldName, token, params);
        }
        if (bucketsPaths == null) {
            throw new ParsingException(parser2.getTokenLocation(), "Missing required field [" + BUCKETS_PATH.getPreferredName() + "] for aggregation [" + pipelineAggregatorName + "]", new Object[0]);
        }
        BucketMetricsPipelineAggregationBuilder<?> factory = this.buildFactory(pipelineAggregatorName, (String)bucketsPaths[0], params);
        if (format != null) {
            factory.format(format);
        }
        if (gapPolicy != null) {
            factory.gapPolicy(gapPolicy);
        }
        assert (factory != null);
        return factory;
    }

    protected abstract BucketMetricsPipelineAggregationBuilder<?> buildFactory(String var1, String var2, Map<String, Object> var3);

    protected boolean token(XContentParser parser2, QueryParseContext context, String field, XContentParser.Token token, Map<String, Object> params) throws IOException {
        return false;
    }

    private void parseToken(String aggregationName, XContentParser parser2, QueryParseContext context, String currentFieldName, XContentParser.Token currentToken, Map<String, Object> params) throws IOException {
        if (!this.token(parser2, context, currentFieldName, currentToken, params)) {
            throw new ParsingException(parser2.getTokenLocation(), "Unexpected token " + (Object)((Object)currentToken) + " [" + currentFieldName + "] in [" + aggregationName + "]", new Object[0]);
        }
    }
}

