/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.WeightFactorFunction;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.TypeFieldMapper;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.collapse.CollapseContext;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.slice.SliceBuilder;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

final class DefaultSearchContext
extends SearchContext {
    private final long id;
    private final ShardSearchRequest request;
    private final SearchShardTarget shardTarget;
    private final Counter timeEstimateCounter;
    private SearchType searchType;
    private final Engine.Searcher engineSearcher;
    private final BigArrays bigArrays;
    private final IndexShard indexShard;
    private final IndexService indexService;
    private final ContextIndexSearcher searcher;
    private final DfsSearchResult dfsResult;
    private final QuerySearchResult queryResult;
    private final FetchSearchResult fetchResult;
    private final float queryBoost;
    private TimeValue timeout;
    private int terminateAfter = 0;
    private List<String> groupStats;
    private ScrollContext scrollContext;
    private boolean explain;
    private boolean version = false;
    private StoredFieldsContext storedFields;
    private ScriptFieldsContext scriptFields;
    private FetchSourceContext fetchSourceContext;
    private DocValueFieldsContext docValueFieldsContext;
    private int from = -1;
    private int size = -1;
    private SortAndFormats sort;
    private Float minimumScore;
    private boolean trackScores = false;
    private FieldDoc searchAfter;
    private CollapseContext collapse;
    private boolean lowLevelCancellation;
    private SliceBuilder sliceBuilder;
    private SearchTask task;
    private ParsedQuery originalQuery;
    private Query query;
    private ParsedQuery postFilter;
    private Query aliasFilter;
    private int[] docIdsToLoad;
    private int docsIdsToLoadFrom;
    private int docsIdsToLoadSize;
    private SearchContextAggregations aggregations;
    private SearchContextHighlight highlight;
    private SuggestionSearchContext suggest;
    private List<RescoreSearchContext> rescore;
    private volatile long keepAlive;
    private final long originNanoTime = System.nanoTime();
    private volatile long lastAccessTime = -1L;
    private Profilers profilers;
    private final Map<String, SearchExtBuilder> searchExtBuilders = new HashMap<String, SearchExtBuilder>();
    private final Map<Class<?>, Collector> queryCollectors = new HashMap();
    private final QueryShardContext queryShardContext;
    private FetchPhase fetchPhase;

    DefaultSearchContext(long id, ShardSearchRequest request, SearchShardTarget shardTarget, Engine.Searcher engineSearcher, IndexService indexService, IndexShard indexShard, BigArrays bigArrays, Counter timeEstimateCounter, TimeValue timeout, FetchPhase fetchPhase) {
        this.id = id;
        this.request = request;
        this.fetchPhase = fetchPhase;
        this.searchType = request.searchType();
        this.shardTarget = shardTarget;
        this.engineSearcher = engineSearcher;
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.dfsResult = new DfsSearchResult(id, shardTarget);
        this.queryResult = new QuerySearchResult(id, shardTarget);
        this.fetchResult = new FetchSearchResult(id, shardTarget);
        this.indexShard = indexShard;
        this.indexService = indexService;
        this.searcher = new ContextIndexSearcher(engineSearcher, indexService.cache().query(), indexShard.getQueryCachingPolicy());
        this.timeEstimateCounter = timeEstimateCounter;
        this.timeout = timeout;
        this.queryShardContext = indexService.newQueryShardContext(request.shardId().id(), this.searcher.getIndexReader(), request::nowInMillis);
        this.queryShardContext.setTypes(request.types());
        this.queryBoost = request.indexBoost();
    }

    @Override
    public void doClose() {
        Releasables.close(this.searcher, this.engineSearcher);
    }

    @Override
    public void preProcess(boolean rewrite) {
        int maxResultWindow;
        long size;
        if (this.hasOnlySuggest()) {
            return;
        }
        long from = this.from() == -1 ? 0L : (long)this.from();
        long resultWindow = from + (size = this.size() == -1 ? 10L : (long)this.size());
        if (resultWindow > (long)(maxResultWindow = this.indexService.getIndexSettings().getMaxResultWindow())) {
            if (this.scrollContext == null) {
                throw new QueryPhaseExecutionException(this, "Result window is too large, from + size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. See the scroll api for a more efficient way to request large data sets. This limit can be set by changing the [" + IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
            }
            throw new QueryPhaseExecutionException(this, "Batch size is too large, size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. Scroll batch sizes cost as much memory as result windows so they are controlled by the [" + IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
        }
        if (this.rescore != null) {
            int maxWindow = this.indexService.getIndexSettings().getMaxRescoreWindow();
            for (RescoreSearchContext rescoreContext : this.rescore) {
                if (rescoreContext.window() <= maxWindow) continue;
                throw new QueryPhaseExecutionException(this, "Rescore window [" + rescoreContext.window() + "] is too large. It must be less than [" + maxWindow + "]. This prevents allocating massive heaps for storing the results to be rescored. This limit can be set by changing the [" + IndexSettings.MAX_RESCORE_WINDOW_SETTING.getKey() + "] index level setting.");
            }
        }
        if (this.sliceBuilder != null) {
            int sliceLimit = this.indexService.getIndexSettings().getMaxSlicesPerScroll();
            int numSlices = this.sliceBuilder.getMax();
            if (numSlices > sliceLimit) {
                throw new QueryPhaseExecutionException(this, "The number of slices [" + numSlices + "] is too large. It must be less than [" + sliceLimit + "]. This limit can be set by changing the [" + IndexSettings.MAX_SLICES_PER_SCROLL.getKey() + "] index level setting.");
            }
        }
        try {
            QueryBuilder queryBuilder = this.request.filteringAliases();
            this.aliasFilter = queryBuilder == null ? null : queryBuilder.toFilter(this.queryShardContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (this.query() == null) {
            this.parsedQuery(ParsedQuery.parsedMatchAllQuery());
        }
        if (this.queryBoost() != 1.0f) {
            this.parsedQuery(new ParsedQuery((Query)new FunctionScoreQuery(this.query(), new WeightFactorFunction(this.queryBoost)), this.parsedQuery()));
        }
        this.query = this.buildFilteredQuery(this.query);
        if (rewrite) {
            try {
                this.query = this.searcher.rewrite(this.query);
            }
            catch (IOException e) {
                throw new QueryPhaseExecutionException(this, "Failed to rewrite main query", (Throwable)e);
            }
        }
    }

    @Override
    public Query buildFilteredQuery(Query query) {
        ArrayList<Query> filters = new ArrayList<Query>();
        Query typeFilter = DefaultSearchContext.createTypeFilter(this.queryShardContext.getTypes());
        if (typeFilter != null) {
            filters.add(typeFilter);
        }
        if (this.mapperService().hasNested() && typeFilter == null && new NestedHelper(this.mapperService()).mightMatchNestedDocs(query) && (this.aliasFilter == null || new NestedHelper(this.mapperService()).mightMatchNestedDocs(this.aliasFilter))) {
            filters.add(Queries.newNonNestedFilter());
        }
        if (this.aliasFilter != null) {
            filters.add(this.aliasFilter);
        }
        if (this.sliceBuilder != null) {
            filters.add(this.sliceBuilder.toFilter(this.queryShardContext, this.shardTarget().getShardId().getId(), this.queryShardContext.getIndexSettings().getNumberOfShards()));
        }
        if (filters.isEmpty()) {
            return query;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(query, BooleanClause.Occur.MUST);
        for (Query filter : filters) {
            builder.add(filter, BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    private static Query createTypeFilter(String[] types) {
        if (types != null && types.length >= 1) {
            BytesRef[] typesBytes = new BytesRef[types.length];
            for (int i = 0; i < typesBytes.length; ++i) {
                typesBytes[i] = new BytesRef((CharSequence)types[i]);
            }
            return new TypeFieldMapper.TypesQuery(typesBytes);
        }
        return null;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String source() {
        return this.engineSearcher.source();
    }

    @Override
    public ShardSearchRequest request() {
        return this.request;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public int numberOfShards() {
        return this.request.numberOfShards();
    }

    @Override
    public float queryBoost() {
        return this.queryBoost;
    }

    @Override
    public long getOriginNanoTime() {
        return this.originNanoTime;
    }

    @Override
    public ScrollContext scrollContext() {
        return this.scrollContext;
    }

    @Override
    public SearchContext scrollContext(ScrollContext scrollContext) {
        this.scrollContext = scrollContext;
        return this;
    }

    @Override
    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    @Override
    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @Override
    public void addSearchExt(SearchExtBuilder searchExtBuilder) {
        this.searchExtBuilders.put(searchExtBuilder.getWriteableName(), searchExtBuilder);
    }

    @Override
    public SearchExtBuilder getSearchExt(String name) {
        return this.searchExtBuilders.get(name);
    }

    @Override
    public SearchContextHighlight highlight() {
        return this.highlight;
    }

    @Override
    public void highlight(SearchContextHighlight highlight) {
        this.highlight = highlight;
    }

    @Override
    public SuggestionSearchContext suggest() {
        return this.suggest;
    }

    @Override
    public void suggest(SuggestionSearchContext suggest) {
        this.suggest = suggest;
    }

    @Override
    public List<RescoreSearchContext> rescore() {
        if (this.rescore == null) {
            return Collections.emptyList();
        }
        return this.rescore;
    }

    @Override
    public void addRescore(RescoreSearchContext rescore) {
        if (this.rescore == null) {
            this.rescore = new ArrayList<RescoreSearchContext>();
        }
        this.rescore.add(rescore);
    }

    @Override
    public boolean hasScriptFields() {
        return this.scriptFields != null;
    }

    @Override
    public ScriptFieldsContext scriptFields() {
        if (this.scriptFields == null) {
            this.scriptFields = new ScriptFieldsContext();
        }
        return this.scriptFields;
    }

    @Override
    public boolean sourceRequested() {
        return this.fetchSourceContext != null && this.fetchSourceContext.fetchSource();
    }

    @Override
    public boolean hasFetchSourceContext() {
        return this.fetchSourceContext != null;
    }

    @Override
    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    @Override
    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    @Override
    public DocValueFieldsContext docValueFieldsContext() {
        return this.docValueFieldsContext;
    }

    @Override
    public SearchContext docValueFieldsContext(DocValueFieldsContext docValueFieldsContext) {
        this.docValueFieldsContext = docValueFieldsContext;
        return this;
    }

    @Override
    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    @Override
    public IndexShard indexShard() {
        return this.indexShard;
    }

    @Override
    public MapperService mapperService() {
        return this.indexService.mapperService();
    }

    @Override
    public SimilarityService similarityService() {
        return this.indexService.similarityService();
    }

    @Override
    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    @Override
    public BitsetFilterCache bitsetFilterCache() {
        return this.indexService.cache().bitsetFilterCache();
    }

    @Override
    public IndexFieldDataService fieldData() {
        return this.indexService.fieldData();
    }

    @Override
    public TimeValue timeout() {
        return this.timeout;
    }

    @Override
    public void timeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    @Override
    public int terminateAfter() {
        return this.terminateAfter;
    }

    @Override
    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    @Override
    public SearchContext minimumScore(float minimumScore) {
        this.minimumScore = Float.valueOf(minimumScore);
        return this;
    }

    @Override
    public Float minimumScore() {
        return this.minimumScore;
    }

    @Override
    public SearchContext sort(SortAndFormats sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public SortAndFormats sort() {
        return this.sort;
    }

    @Override
    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    @Override
    public boolean trackScores() {
        return this.trackScores;
    }

    @Override
    public SearchContext searchAfter(FieldDoc searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    @Override
    public boolean lowLevelCancellation() {
        return this.lowLevelCancellation;
    }

    public void lowLevelCancellation(boolean lowLevelCancellation) {
        this.lowLevelCancellation = lowLevelCancellation;
    }

    @Override
    public FieldDoc searchAfter() {
        return this.searchAfter;
    }

    @Override
    public SearchContext collapse(CollapseContext collapse) {
        this.collapse = collapse;
        return this;
    }

    @Override
    public CollapseContext collapse() {
        return this.collapse;
    }

    public SearchContext sliceBuilder(SliceBuilder sliceBuilder) {
        this.sliceBuilder = sliceBuilder;
        return this;
    }

    @Override
    public SearchContext parsedPostFilter(ParsedQuery postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    @Override
    public ParsedQuery parsedPostFilter() {
        return this.postFilter;
    }

    @Override
    public Query aliasFilter() {
        return this.aliasFilter;
    }

    @Override
    public SearchContext parsedQuery(ParsedQuery query) {
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    @Override
    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public int from() {
        return this.from;
    }

    @Override
    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public SearchContext size(int size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasStoredFields() {
        return this.storedFields != null && this.storedFields.fieldNames() != null;
    }

    @Override
    public boolean hasStoredFieldsContext() {
        return this.storedFields != null;
    }

    @Override
    public StoredFieldsContext storedFieldsContext() {
        return this.storedFields;
    }

    @Override
    public SearchContext storedFieldsContext(StoredFieldsContext storedFieldsContext) {
        this.storedFields = storedFieldsContext;
        return this;
    }

    @Override
    public boolean storedFieldsRequested() {
        return this.storedFields == null || this.storedFields.fetchFields();
    }

    @Override
    public boolean explain() {
        return this.explain;
    }

    @Override
    public void explain(boolean explain) {
        this.explain = explain;
    }

    @Override
    @Nullable
    public List<String> groupStats() {
        return this.groupStats;
    }

    @Override
    public void groupStats(List<String> groupStats) {
        this.groupStats = groupStats;
    }

    @Override
    public boolean version() {
        return this.version;
    }

    @Override
    public void version(boolean version2) {
        this.version = version2;
    }

    @Override
    public int[] docIdsToLoad() {
        return this.docIdsToLoad;
    }

    @Override
    public int docIdsToLoadFrom() {
        return this.docsIdsToLoadFrom;
    }

    @Override
    public int docIdsToLoadSize() {
        return this.docsIdsToLoadSize;
    }

    @Override
    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadFrom, int docsIdsToLoadSize) {
        this.docIdsToLoad = docIdsToLoad;
        this.docsIdsToLoadFrom = docsIdsToLoadFrom;
        this.docsIdsToLoadSize = docsIdsToLoadSize;
        return this;
    }

    @Override
    public void accessed(long accessTime) {
        this.lastAccessTime = accessTime;
    }

    @Override
    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long keepAlive() {
        return this.keepAlive;
    }

    @Override
    public void keepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public DfsSearchResult dfsResult() {
        return this.dfsResult;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    @Override
    public FetchPhase fetchPhase() {
        return this.fetchPhase;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    @Override
    public MappedFieldType smartNameFieldType(String name) {
        return this.mapperService().fullName(name);
    }

    @Override
    public ObjectMapper getObjectMapper(String name) {
        return this.mapperService().getObjectMapper(name);
    }

    @Override
    public Counter timeEstimateCounter() {
        return this.timeEstimateCounter;
    }

    @Override
    public Map<Class<?>, Collector> queryCollectors() {
        return this.queryCollectors;
    }

    @Override
    public QueryShardContext getQueryShardContext() {
        return this.queryShardContext;
    }

    @Override
    public Profilers getProfilers() {
        return this.profilers;
    }

    public void setProfilers(Profilers profilers) {
        this.profilers = profilers;
    }

    @Override
    public void setTask(SearchTask task) {
        this.task = task;
    }

    @Override
    public SearchTask getTask() {
        return this.task;
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }
}

