/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.search.Scroll;

public class RestSearchScrollAction
extends BaseRestHandler {
    public RestSearchScrollAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.GET, "/_search/scroll/{scroll_id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/scroll/{scroll_id}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String scrollId = request.param("scroll_id");
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest();
        searchScrollRequest.scrollId(scrollId);
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchScrollRequest.scroll(new Scroll(TimeValue.parseTimeValue(scroll, null, "scroll")));
        }
        request.withContentOrSourceParamParserOrNullLenient(xContentParser -> {
            if (xContentParser == null) {
                if (request.hasContent()) {
                    BytesReference body = request.getContentOrSourceParamOnly();
                    if (scrollId == null) {
                        String bodyScrollId = body.utf8ToString();
                        searchScrollRequest.scrollId(bodyScrollId);
                    }
                }
            } else {
                try {
                    RestSearchScrollAction.buildFromContent(xContentParser, searchScrollRequest);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to parse request body", e);
                }
            }
        });
        return channel -> client.searchScroll(searchScrollRequest, new RestStatusToXContentListener<SearchResponse>((RestChannel)channel));
    }

    @Override
    public boolean supportsPlainText() {
        return true;
    }

    public static void buildFromContent(XContentParser parser2, SearchScrollRequest searchScrollRequest) throws IOException {
        XContentParser.Token token;
        if (parser2.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Malformed content, must start with an object");
        }
        String currentFieldName = null;
        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser2.currentName();
                continue;
            }
            if ("scroll_id".equals(currentFieldName) && token == XContentParser.Token.VALUE_STRING) {
                searchScrollRequest.scrollId(parser2.text());
                continue;
            }
            if ("scroll".equals(currentFieldName) && token == XContentParser.Token.VALUE_STRING) {
                searchScrollRequest.scroll(new Scroll(TimeValue.parseTimeValue(parser2.text(), null, "scroll")));
                continue;
            }
            throw new IllegalArgumentException("Unknown parameter [" + currentFieldName + "] in request body or parameter is of the wrong type[" + (Object)((Object)token) + "] ");
        }
    }
}

