/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestUtils;

public abstract class RestRequest
implements ToXContent.Params {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(RestRequest.class));
    private static final Pattern TCHAR_PATTERN = Pattern.compile("[a-zA-z0-9!#$%&'*+\\-.\\^_`|~]+");
    private final NamedXContentRegistry xContentRegistry;
    private final Map<String, String> params;
    private final Map<String, List<String>> headers;
    private final String rawPath;
    private final Set<String> consumedParams = new HashSet<String>();
    private final SetOnce<XContentType> xContentType = new SetOnce();

    public RestRequest(NamedXContentRegistry xContentRegistry, String uri, Map<String, List<String>> headers) {
        this.xContentRegistry = xContentRegistry;
        HashMap<String, String> params = new HashMap<String, String>();
        int pathEndPos = uri.indexOf(63);
        if (pathEndPos < 0) {
            this.rawPath = uri;
        } else {
            this.rawPath = uri.substring(0, pathEndPos);
            RestUtils.decodeQueryString(uri, pathEndPos + 1, params);
        }
        this.params = params;
        this.headers = Collections.unmodifiableMap(headers);
        List<String> contentType = this.getAllHeaderValues("Content-Type");
        XContentType xContentType = RestRequest.parseContentType(contentType);
        if (xContentType != null) {
            this.xContentType.set((Object)xContentType);
        }
    }

    public RestRequest(NamedXContentRegistry xContentRegistry, Map<String, String> params, String path, Map<String, List<String>> headers) {
        this.xContentRegistry = xContentRegistry;
        this.params = params;
        this.rawPath = path;
        this.headers = Collections.unmodifiableMap(headers);
        List<String> contentType = this.getAllHeaderValues("Content-Type");
        XContentType xContentType = RestRequest.parseContentType(contentType);
        if (xContentType != null) {
            this.xContentType.set((Object)xContentType);
        }
    }

    public abstract Method method();

    public abstract String uri();

    public String rawPath() {
        return this.rawPath;
    }

    public final String path() {
        return RestUtils.decodeComponent(this.rawPath());
    }

    public abstract boolean hasContent();

    public abstract BytesReference content();

    public final String header(String name) {
        List<String> values = this.headers.get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public final List<String> getAllHeaderValues(String name) {
        List<String> values = this.headers.get(name);
        if (values != null) {
            return Collections.unmodifiableList(values);
        }
        return null;
    }

    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Nullable
    public final XContentType getXContentType() {
        return (XContentType)this.xContentType.get();
    }

    final void setXContentType(XContentType xContentType) {
        this.xContentType.set((Object)xContentType);
    }

    @Nullable
    public SocketAddress getRemoteAddress() {
        return null;
    }

    @Nullable
    public SocketAddress getLocalAddress() {
        return null;
    }

    public final boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    @Override
    public final String param(String key) {
        this.consumedParams.add(key);
        return this.params.get(key);
    }

    @Override
    public final String param(String key, String defaultValue) {
        this.consumedParams.add(key);
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, String> params() {
        return this.params;
    }

    List<String> consumedParams() {
        return this.consumedParams.stream().collect(Collectors.toList());
    }

    List<String> unconsumedParams() {
        return this.params.keySet().stream().filter(p -> !this.consumedParams.contains(p)).collect(Collectors.toList());
    }

    public float paramAsFloat(String key, float defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse float parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public int paramAsInt(String key, int defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public long paramAsLong(String key, long defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse long parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public boolean paramAsBoolean(String key, boolean defaultValue) {
        return this.paramAsBoolean(key, (Boolean)defaultValue);
    }

    @Override
    public Boolean paramAsBoolean(String key, Boolean defaultValue) {
        String rawParam = this.param(key);
        if (rawParam != null && rawParam.length() == 0) {
            return true;
        }
        if (rawParam != null && !Booleans.isStrictlyBoolean(rawParam)) {
            DEPRECATION_LOGGER.deprecated("Expected a boolean [true/false] for request parameter [{}] but got [{}]", key, rawParam);
        }
        return Booleans.parseBoolean(rawParam, defaultValue);
    }

    public TimeValue paramAsTime(String key, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.param(key), defaultValue, key);
    }

    public ByteSizeValue paramAsSize(String key, ByteSizeValue defaultValue) {
        return ByteSizeValue.parseBytesSizeValue(this.param(key), defaultValue, key);
    }

    public String[] paramAsStringArray(String key, String[] defaultValue) {
        String value = this.param(key);
        if (value == null) {
            return defaultValue;
        }
        return Strings.splitStringByCommaToArray(value);
    }

    public String[] paramAsStringArrayOrEmptyIfAll(String key) {
        String[] params = this.paramAsStringArray(key, Strings.EMPTY_ARRAY);
        if (Strings.isAllOrWildcard(params)) {
            return Strings.EMPTY_ARRAY;
        }
        return params;
    }

    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public final XContentParser contentParser() throws IOException {
        BytesReference content = this.content();
        if (content.length() == 0) {
            throw new ElasticsearchParseException("Body required", new Object[0]);
        }
        if (this.xContentType.get() == null) {
            throw new IllegalStateException("unknown content type");
        }
        return ((XContentType)this.xContentType.get()).xContent().createParser(this.xContentRegistry, content);
    }

    public final void applyContentParser(CheckedConsumer<XContentParser, IOException> applyParser) throws IOException {
        if (this.hasContent()) {
            try (XContentParser parser2 = this.contentParser();){
                applyParser.accept(parser2);
            }
        }
    }

    public final boolean hasContentOrSourceParam() {
        return this.hasContent() || this.hasParam("source");
    }

    public final XContentParser contentOrSourceParamParser() throws IOException {
        Tuple<XContentType, BytesReference> tuple = this.contentOrSourceParam();
        BytesReference content = tuple.v2();
        if (content.length() == 0) {
            throw new ElasticsearchParseException("Body required", new Object[0]);
        }
        return tuple.v1().xContent().createParser(this.xContentRegistry, content);
    }

    public final void withContentOrSourceParamParserOrNull(CheckedConsumer<XContentParser, IOException> withParser) throws IOException {
        Tuple<XContentType, BytesReference> tuple = this.contentOrSourceParam();
        BytesReference content = tuple.v2();
        XContentType xContentType = tuple.v1();
        if (content.length() > 0) {
            try (XContentParser parser2 = xContentType.xContent().createParser(this.xContentRegistry, content);){
                withParser.accept(parser2);
            }
        } else {
            withParser.accept(null);
        }
    }

    public final Tuple<XContentType, BytesReference> contentOrSourceParam() {
        if (this.hasContent()) {
            if (this.xContentType.get() == null) {
                throw new IllegalStateException("unknown content type");
            }
            return new Tuple<Object, BytesReference>(this.xContentType.get(), this.content());
        }
        String source = this.param("source");
        String typeParam = this.param("source_content_type");
        if (source != null) {
            XContentType xContentType;
            BytesArray bytes = new BytesArray(source);
            if (typeParam != null) {
                xContentType = RestRequest.parseContentType(Collections.singletonList(typeParam));
            } else {
                DEPRECATION_LOGGER.deprecated("Deprecated use of the [source] parameter without the [source_content_type] parameter. Use the [source_content_type] parameter to specify the content type of the source such as [application/json]", new Object[0]);
                xContentType = XContentFactory.xContentType(bytes);
            }
            if (xContentType == null) {
                throw new IllegalStateException("could not determine source content type");
            }
            return new Tuple<XContentType, BytesReference>(xContentType, bytes);
        }
        return new Tuple<XContentType, BytesReference>(XContentType.JSON, BytesArray.EMPTY);
    }

    @Deprecated
    public final void withContentOrSourceParamParserOrNullLenient(CheckedConsumer<XContentParser, IOException> withParser) throws IOException {
        if (this.hasContent() && this.xContentType.get() == null) {
            withParser.accept(null);
        } else {
            Tuple<XContentType, BytesReference> tuple = this.contentOrSourceParam();
            BytesReference content = tuple.v2();
            XContentType xContentType = tuple.v1();
            if (content.length() > 0) {
                try (XContentParser parser2 = xContentType.xContent().createParser(this.xContentRegistry, content);){
                    withParser.accept(parser2);
                }
            } else {
                withParser.accept(null);
            }
        }
    }

    @Deprecated
    public final BytesReference getContentOrSourceParamOnly() {
        if (this.hasContent()) {
            return this.content();
        }
        String source = this.param("source");
        if (source != null) {
            return new BytesArray(source);
        }
        return BytesArray.EMPTY;
    }

    private static XContentType parseContentType(List<String> header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        if (header.size() > 1) {
            throw new IllegalArgumentException("only one Content-Type header should be provided");
        }
        String rawContentType = header.get(0);
        String[] elements = rawContentType.split("[ \t]*;");
        if (elements.length > 0) {
            String[] splitMediaType = elements[0].split("/");
            if (splitMediaType.length == 2 && TCHAR_PATTERN.matcher(splitMediaType[0]).matches() && TCHAR_PATTERN.matcher(splitMediaType[1].trim()).matches()) {
                return XContentType.fromMediaType(elements[0]);
            }
            throw new IllegalArgumentException("invalid Content-Type header [" + rawContentType + "]");
        }
        throw new IllegalArgumentException("empty Content-Type header");
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD;

    }
}

