/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class BytesRestResponse
extends RestResponse {
    public static final String TEXT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    private static final String STATUS = "status";
    private final RestStatus status;
    private final BytesReference content;
    private final String contentType;
    private static final Logger SUPPRESSED_ERROR_LOGGER = ESLoggerFactory.getLogger("rest.suppressed");

    public BytesRestResponse(RestStatus status, XContentBuilder builder) {
        this(status, builder.contentType().mediaType(), builder.bytes());
    }

    public BytesRestResponse(RestStatus status, String content) {
        this(status, TEXT_CONTENT_TYPE, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, String content) {
        this(status, contentType, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, byte[] content) {
        this(status, contentType, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, BytesReference content) {
        this.status = status;
        this.content = content;
        this.contentType = contentType;
    }

    public BytesRestResponse(RestChannel channel, Exception e) throws IOException {
        this(channel, ExceptionsHelper.status(e), e);
    }

    public BytesRestResponse(RestChannel channel, RestStatus status, Exception e) throws IOException {
        this.status = status;
        if (channel.request().method() == RestRequest.Method.HEAD) {
            this.content = BytesArray.EMPTY;
            this.contentType = TEXT_CONTENT_TYPE;
        } else {
            try (XContentBuilder builder = BytesRestResponse.build(channel, status, e);){
                this.content = builder.bytes();
                this.contentType = builder.contentType().mediaType();
            }
        }
        if (e instanceof ElasticsearchException) {
            this.copyHeaders((ElasticsearchException)e);
        }
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    private static XContentBuilder build(RestChannel channel, RestStatus status, Exception e) throws IOException {
        ToXContent.Params params = channel.request();
        if (params.paramAsBoolean("error_trace", false)) {
            params = new ToXContent.DelegatingMapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"), params);
        } else if (e != null) {
            Supplier messageSupplier = () -> new ParameterizedMessage("path: {}, params: {}", (Object)channel.request().rawPath(), channel.request().params());
            if (status.getStatus() < 500) {
                SUPPRESSED_ERROR_LOGGER.debug(messageSupplier, (Throwable)e);
            } else {
                SUPPRESSED_ERROR_LOGGER.warn(messageSupplier, (Throwable)e);
            }
        }
        XContentBuilder builder = channel.newErrorBuilder().startObject();
        ElasticsearchException.generateFailureXContent(builder, params, e, channel.detailedErrorsEnabled());
        builder.field(STATUS, status.getStatus());
        builder.endObject();
        return builder;
    }

    static BytesRestResponse createSimpleErrorResponse(RestStatus status, String errorMessage) throws IOException {
        return new BytesRestResponse(status, JsonXContent.contentBuilder().startObject().field("error", errorMessage).field(STATUS, status.getStatus()).endObject());
    }

    public static ElasticsearchStatusException errorFromXContent(XContentParser parser2) throws IOException {
        XContentParser.Token token = parser2.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser2::getTokenLocation);
        Throwable exception = null;
        RestStatus status = null;
        String currentFieldName = null;
        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser2.currentName();
            }
            if (STATUS.equals(currentFieldName)) {
                if (token == XContentParser.Token.FIELD_NAME) continue;
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, parser2::getTokenLocation);
                status = RestStatus.fromCode(parser2.intValue());
                continue;
            }
            exception = ElasticsearchException.failureFromXContent(parser2);
        }
        if (exception == null) {
            throw new IllegalStateException("Failed to parse elasticsearch status exception: no exception was found");
        }
        ElasticsearchStatusException result = new ElasticsearchStatusException(exception.getMessage(), status, exception.getCause(), new Object[0]);
        for (String header : ((ElasticsearchException)exception).getHeaderKeys()) {
            result.addHeader(header, ((ElasticsearchException)exception).getHeader(header));
        }
        for (String metadata : ((ElasticsearchException)exception).getMetadataKeys()) {
            result.addMetadata(metadata, ((ElasticsearchException)exception).getMetadata(metadata));
        }
        return result;
    }
}

