/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.uri;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.url.URLBlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.URIPattern;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;

public class URLRepository
extends BlobStoreRepository {
    public static final String TYPE = "url";
    public static final Setting<List<String>> SUPPORTED_PROTOCOLS_SETTING = Setting.listSetting("repositories.url.supported_protocols", Arrays.asList("http", "https", "ftp", "file", "jar"), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<URIPattern>> ALLOWED_URLS_SETTING = Setting.listSetting("repositories.url.allowed_urls", Collections.emptyList(), URIPattern::new, Setting.Property.NodeScope);
    public static final Setting<URL> URL_SETTING = new Setting<URL>("url", "http:", URLRepository::parseURL, Setting.Property.NodeScope);
    public static final Setting<URL> REPOSITORIES_URL_SETTING = new Setting<URL>("repositories.url.url", s2 -> s2.get("repositories.uri.url", "http:"), URLRepository::parseURL, Setting.Property.NodeScope);
    private final List<String> supportedProtocols;
    private final URIPattern[] urlWhiteList;
    private final Environment environment;
    private final URLBlobStore blobStore;
    private final BlobPath basePath;

    public URLRepository(RepositoryMetaData metadata, Environment environment, NamedXContentRegistry namedXContentRegistry) throws IOException {
        super(metadata, environment.settings(), namedXContentRegistry);
        if (!URL_SETTING.exists(metadata.settings()) && !REPOSITORIES_URL_SETTING.exists(this.settings)) {
            throw new RepositoryException(metadata.name(), "missing url");
        }
        this.supportedProtocols = SUPPORTED_PROTOCOLS_SETTING.get(this.settings);
        this.urlWhiteList = ALLOWED_URLS_SETTING.get(this.settings).toArray(new URIPattern[0]);
        this.environment = environment;
        URL url = URL_SETTING.exists(metadata.settings()) ? URL_SETTING.get(metadata.settings()) : REPOSITORIES_URL_SETTING.get(this.settings);
        URL normalizedURL = this.checkURL(url);
        this.blobStore = new URLBlobStore(this.settings, normalizedURL);
        this.basePath = BlobPath.cleanPath();
    }

    @Override
    protected BlobStore blobStore() {
        return this.blobStore;
    }

    @Override
    protected BlobPath basePath() {
        return this.basePath;
    }

    private URL checkURL(URL url) {
        String protocol = url.getProtocol();
        if (protocol == null) {
            throw new RepositoryException(this.getMetadata().name(), "unknown url protocol from URL [" + url + "]");
        }
        for (String supportedProtocol : this.supportedProtocols) {
            if (!supportedProtocol.equals(protocol)) continue;
            try {
                if (URIPattern.match(this.urlWhiteList, url.toURI())) {
                    return url;
                }
            }
            catch (URISyntaxException ex) {
                this.logger.warn("cannot parse the specified url [{}]", (Object)url);
                throw new RepositoryException(this.getMetadata().name(), "cannot parse the specified url [" + url + "]");
            }
            URL normalizedUrl = this.environment.resolveRepoURL(url);
            if (normalizedUrl == null) {
                this.logger.warn("The specified url [{}] doesn't start with any repository paths specified by the path.repo setting or by {} setting: [{}] ", (Object)url, (Object)ALLOWED_URLS_SETTING.getKey(), (Object)this.environment.repoFiles());
                throw new RepositoryException(this.getMetadata().name(), "file url [" + url + "] doesn't match any of the locations specified by path.repo or " + ALLOWED_URLS_SETTING.getKey());
            }
            return normalizedUrl;
        }
        throw new RepositoryException(this.getMetadata().name(), "unsupported url protocol [" + protocol + "] from URL [" + url + "]");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private static URL parseURL(String s2) {
        try {
            return new URL(s2);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to parse URL repository setting", e);
        }
    }
}

