/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.ttl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.indices.IndicesService;

public class IndicesTTLService
extends AbstractLifecycleComponent {
    public static final Setting<TimeValue> INDICES_TTL_INTERVAL_SETTING = Setting.positiveTimeSetting("indices.ttl.interval", TimeValue.timeValueSeconds(60L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final TransportBulkAction bulkAction;
    private final int bulkSize;
    private PurgerThread purgerThread;

    @Inject
    public IndicesTTLService(Settings settings, ClusterService clusterService, IndicesService indicesService, ClusterSettings clusterSettings, TransportBulkAction bulkAction) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        TimeValue interval = INDICES_TTL_INTERVAL_SETTING.get(settings);
        this.bulkAction = bulkAction;
        this.bulkSize = this.settings.getAsInt("indices.ttl.bulk_size", 10000);
        this.purgerThread = new PurgerThread(EsExecutors.threadName(settings, "[ttl_expire]"), interval);
        clusterSettings.addSettingsUpdateConsumer(INDICES_TTL_INTERVAL_SETTING, this.purgerThread::resetInterval);
    }

    @Override
    protected void doStart() {
        this.purgerThread.start();
    }

    @Override
    protected void doStop() {
        try {
            this.purgerThread.shutdown();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void doClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeShards(List<IndexShard> shardsToPurge) {
        for (IndexShard shardToPurge : shardsToPurge) {
            Query query = shardToPurge.mapperService().fullName("_ttl").rangeQuery(null, System.currentTimeMillis(), false, true, null);
            try (Engine.Searcher searcher = shardToPurge.acquireSearcher("indices_ttl");){
                this.logger.debug("[{}][{}] purging shard", (Object)shardToPurge.routingEntry().index(), (Object)shardToPurge.routingEntry().id());
                ExpiredDocsCollector expiredDocsCollector = new ExpiredDocsCollector();
                searcher.searcher().search(query, (Collector)expiredDocsCollector);
                List<DocToPurge> docsToPurge = expiredDocsCollector.getDocsToPurge();
                BulkRequest bulkRequest = new BulkRequest();
                for (DocToPurge docToPurge : docsToPurge) {
                    bulkRequest.add(((DeleteRequest)new DeleteRequest().index(shardToPurge.routingEntry().getIndexName())).type(docToPurge.type).id(docToPurge.id).version(docToPurge.version).routing(docToPurge.routing));
                    bulkRequest = this.processBulkIfNeeded(bulkRequest, false);
                }
                this.processBulkIfNeeded(bulkRequest, true);
            }
        }
    }

    private BulkRequest processBulkIfNeeded(BulkRequest bulkRequest, boolean force) {
        if (force && bulkRequest.numberOfActions() > 0 || bulkRequest.numberOfActions() >= this.bulkSize) {
            try {
                this.bulkAction.executeBulk(bulkRequest, new ActionListener<BulkResponse>(){

                    @Override
                    public void onResponse(BulkResponse bulkResponse) {
                        if (bulkResponse.hasFailures()) {
                            int failedItems = 0;
                            for (BulkItemResponse response : bulkResponse) {
                                if (!response.isFailed()) continue;
                                ++failedItems;
                            }
                            if (IndicesTTLService.this.logger.isTraceEnabled()) {
                                IndicesTTLService.this.logger.trace("bulk deletion failures for [{}]/[{}] items, failure message: [{}]", (Object)failedItems, (Object)bulkResponse.getItems().length, (Object)bulkResponse.buildFailureMessage());
                            } else {
                                IndicesTTLService.this.logger.error("bulk deletion failures for [{}]/[{}] items", (Object)failedItems, (Object)bulkResponse.getItems().length);
                            }
                        } else {
                            IndicesTTLService.this.logger.trace("bulk deletion took {}ms", (Object)bulkResponse.getTookInMillis());
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        if (IndicesTTLService.this.logger.isTraceEnabled()) {
                            IndicesTTLService.this.logger.trace("failed to execute bulk", (Throwable)e);
                        } else {
                            IndicesTTLService.this.logger.warn("failed to execute bulk: ", (Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                this.logger.warn("failed to process bulk", (Throwable)e);
            }
            bulkRequest = new BulkRequest();
        }
        return bulkRequest;
    }

    private static final class Notifier {
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        private volatile TimeValue timeout;

        Notifier(TimeValue timeout) {
            assert (timeout != null);
            this.timeout = timeout;
        }

        public void await() {
            this.lock.lock();
            try {
                this.condition.await(this.timeout.millis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.lock.unlock();
            }
        }

        public void setTimeout(TimeValue timeout) {
            assert (timeout != null);
            this.timeout = timeout;
            this.doNotify();
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public void doNotify() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private class ExpiredDocsCollector
    extends SimpleCollector {
        private LeafReaderContext context;
        private List<DocToPurge> docsToPurge = new ArrayList<DocToPurge>();
        private NumericDocValues versions;

        ExpiredDocsCollector() {
        }

        public void setScorer(Scorer scorer) {
        }

        public boolean needsScores() {
            return false;
        }

        public void collect(int doc) {
            try {
                FieldsVisitor fieldsVisitor = new FieldsVisitor(false);
                this.context.reader().document(doc, (StoredFieldVisitor)fieldsVisitor);
                Uid uid = fieldsVisitor.uid();
                long version2 = this.versions == null ? -1L : this.versions.get(doc);
                this.docsToPurge.add(new DocToPurge(uid.type(), uid.id(), version2, fieldsVisitor.routing()));
            }
            catch (Exception e) {
                IndicesTTLService.this.logger.trace("failed to collect doc", (Throwable)e);
            }
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.context = context;
            this.versions = context.reader().getNumericDocValues("_version");
        }

        public List<DocToPurge> getDocsToPurge() {
            return this.docsToPurge;
        }
    }

    private static class DocToPurge {
        public final String type;
        public final String id;
        public final long version;
        public final String routing;

        DocToPurge(String type, String id, long version2, String routing) {
            this.type = type;
            this.id = id;
            this.version = version2;
            this.routing = routing;
        }
    }

    private class PurgerThread
    extends Thread {
        private final AtomicBoolean running;
        private final Notifier notifier;
        private final CountDownLatch shutdownLatch;

        PurgerThread(String name, TimeValue interval) {
            super(name);
            this.running = new AtomicBoolean(true);
            this.shutdownLatch = new CountDownLatch(1);
            this.setDaemon(true);
            this.notifier = new Notifier(interval);
        }

        public void shutdown() throws InterruptedException {
            if (this.running.compareAndSet(true, false)) {
                this.notifier.doNotify();
                this.shutdownLatch.await();
            }
        }

        public void resetInterval(TimeValue interval) {
            this.notifier.setTimeout(interval);
        }

        @Override
        public void run() {
            try {
                while (this.running.get()) {
                    block6: {
                        try {
                            List<IndexShard> shardsToPurge = this.getShardsToPurge();
                            IndicesTTLService.this.purgeShards(shardsToPurge);
                        }
                        catch (Exception e) {
                            if (!this.running.get()) break block6;
                            IndicesTTLService.this.logger.warn("failed to execute ttl purge", (Throwable)e);
                        }
                    }
                    if (!this.running.get()) continue;
                    this.notifier.await();
                }
            }
            finally {
                this.shutdownLatch.countDown();
            }
        }

        private List<IndexShard> getShardsToPurge() {
            ArrayList<IndexShard> shardsToPurge = new ArrayList<IndexShard>();
            MetaData metaData = IndicesTTLService.this.clusterService.state().metaData();
            for (IndexService indexService : IndicesTTLService.this.indicesService) {
                IndexMetaData indexMetaData = metaData.index(indexService.index());
                if (indexMetaData == null || indexService.getIndexSettings().isTTLPurgeDisabled()) continue;
                boolean hasTTLEnabled = false;
                for (String type : indexService.mapperService().types()) {
                    DocumentMapper documentType = indexService.mapperService().documentMapper(type);
                    if (!documentType.TTLFieldMapper().enabled()) continue;
                    hasTTLEnabled = true;
                    break;
                }
                if (!hasTTLEnabled) continue;
                for (IndexShard indexShard : indexService) {
                    if (indexShard.state() != IndexShardState.STARTED || !indexShard.routingEntry().primary() || !indexShard.routingEntry().started()) continue;
                    shardsToPurge.add(indexShard);
                }
            }
            return shardsToPurge;
        }

        public TimeValue getInterval() {
            return this.notifier.getTimeout();
        }
    }
}

