/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.ckb.SoraniAnalyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lt.LithuanianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.elasticsearch.Version;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.analysis.PatternAnalyzer;
import org.elasticsearch.index.analysis.SnowballAnalyzer;
import org.elasticsearch.index.analysis.StandardHtmlStripAnalyzer;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public enum PreBuiltAnalyzers {
    STANDARD(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version2) {
            StandardAnalyzer a = new StandardAnalyzer(CharArraySet.EMPTY_SET);
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    DEFAULT(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version2) {
            return STANDARD.getAnalyzer(version2);
        }
    }
    ,
    KEYWORD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Analyzer create(Version version2) {
            return new KeywordAnalyzer();
        }
    }
    ,
    STOP{

        @Override
        protected Analyzer create(Version version2) {
            StopAnalyzer a = new StopAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    WHITESPACE{

        @Override
        protected Analyzer create(Version version2) {
            WhitespaceAnalyzer a = new WhitespaceAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    SIMPLE{

        @Override
        protected Analyzer create(Version version2) {
            SimpleAnalyzer a = new SimpleAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    CLASSIC{

        @Override
        protected Analyzer create(Version version2) {
            ClassicAnalyzer a = new ClassicAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    SNOWBALL{

        @Override
        protected Analyzer create(Version version2) {
            SnowballAnalyzer analyzer = new SnowballAnalyzer("English", StopAnalyzer.ENGLISH_STOP_WORDS_SET);
            analyzer.setVersion(version2.luceneVersion);
            return analyzer;
        }
    }
    ,
    PATTERN(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version2) {
            return new PatternAnalyzer(Regex.compile("\\W+", null), true, CharArraySet.EMPTY_SET);
        }
    }
    ,
    STANDARD_HTML_STRIP(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version2) {
            StandardHtmlStripAnalyzer analyzer = new StandardHtmlStripAnalyzer(CharArraySet.EMPTY_SET);
            analyzer.setVersion(version2.luceneVersion);
            return analyzer;
        }
    }
    ,
    ARABIC{

        @Override
        protected Analyzer create(Version version2) {
            ArabicAnalyzer a = new ArabicAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    ARMENIAN{

        @Override
        protected Analyzer create(Version version2) {
            ArmenianAnalyzer a = new ArmenianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    BASQUE{

        @Override
        protected Analyzer create(Version version2) {
            BasqueAnalyzer a = new BasqueAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    BRAZILIAN{

        @Override
        protected Analyzer create(Version version2) {
            BrazilianAnalyzer a = new BrazilianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    BULGARIAN{

        @Override
        protected Analyzer create(Version version2) {
            BulgarianAnalyzer a = new BulgarianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    CATALAN{

        @Override
        protected Analyzer create(Version version2) {
            CatalanAnalyzer a = new CatalanAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    CHINESE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Analyzer create(Version version2) {
            StandardAnalyzer a = new StandardAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    CJK{

        @Override
        protected Analyzer create(Version version2) {
            CJKAnalyzer a = new CJKAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    CZECH{

        @Override
        protected Analyzer create(Version version2) {
            CzechAnalyzer a = new CzechAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    DUTCH{

        @Override
        protected Analyzer create(Version version2) {
            DutchAnalyzer a = new DutchAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    DANISH{

        @Override
        protected Analyzer create(Version version2) {
            DanishAnalyzer a = new DanishAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    ENGLISH{

        @Override
        protected Analyzer create(Version version2) {
            EnglishAnalyzer a = new EnglishAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    FINNISH{

        @Override
        protected Analyzer create(Version version2) {
            FinnishAnalyzer a = new FinnishAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    FRENCH{

        @Override
        protected Analyzer create(Version version2) {
            FrenchAnalyzer a = new FrenchAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    GALICIAN{

        @Override
        protected Analyzer create(Version version2) {
            GalicianAnalyzer a = new GalicianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    GERMAN{

        @Override
        protected Analyzer create(Version version2) {
            GermanAnalyzer a = new GermanAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    GREEK{

        @Override
        protected Analyzer create(Version version2) {
            GreekAnalyzer a = new GreekAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    HINDI{

        @Override
        protected Analyzer create(Version version2) {
            HindiAnalyzer a = new HindiAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    HUNGARIAN{

        @Override
        protected Analyzer create(Version version2) {
            HungarianAnalyzer a = new HungarianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    INDONESIAN{

        @Override
        protected Analyzer create(Version version2) {
            IndonesianAnalyzer a = new IndonesianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    IRISH{

        @Override
        protected Analyzer create(Version version2) {
            IrishAnalyzer a = new IrishAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    ITALIAN{

        @Override
        protected Analyzer create(Version version2) {
            ItalianAnalyzer a = new ItalianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    LATVIAN{

        @Override
        protected Analyzer create(Version version2) {
            LatvianAnalyzer a = new LatvianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    LITHUANIAN{

        @Override
        protected Analyzer create(Version version2) {
            LithuanianAnalyzer a = new LithuanianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    NORWEGIAN{

        @Override
        protected Analyzer create(Version version2) {
            NorwegianAnalyzer a = new NorwegianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    PERSIAN{

        @Override
        protected Analyzer create(Version version2) {
            PersianAnalyzer a = new PersianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    PORTUGUESE{

        @Override
        protected Analyzer create(Version version2) {
            PortugueseAnalyzer a = new PortugueseAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    ROMANIAN{

        @Override
        protected Analyzer create(Version version2) {
            RomanianAnalyzer a = new RomanianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    RUSSIAN{

        @Override
        protected Analyzer create(Version version2) {
            RussianAnalyzer a = new RussianAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    SORANI{

        @Override
        protected Analyzer create(Version version2) {
            SoraniAnalyzer a = new SoraniAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    SPANISH{

        @Override
        protected Analyzer create(Version version2) {
            SpanishAnalyzer a = new SpanishAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    SWEDISH{

        @Override
        protected Analyzer create(Version version2) {
            SwedishAnalyzer a = new SwedishAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    TURKISH{

        @Override
        protected Analyzer create(Version version2) {
            TurkishAnalyzer a = new TurkishAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    }
    ,
    THAI{

        @Override
        protected Analyzer create(Version version2) {
            ThaiAnalyzer a = new ThaiAnalyzer();
            a.setVersion(version2.luceneVersion);
            return a;
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<Analyzer> cache;

    protected abstract Analyzer create(Version var1);

    private PreBuiltAnalyzers() {
        this(PreBuiltCacheFactory.CachingStrategy.LUCENE);
    }

    private PreBuiltAnalyzers(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    PreBuiltCacheFactory.PreBuiltCache<Analyzer> getCache() {
        return this.cache;
    }

    public synchronized Analyzer getAnalyzer(Version version2) {
        Analyzer analyzer = this.cache.get(version2);
        if (analyzer == null) {
            analyzer = this.create(version2);
            this.cache.put(version2, analyzer);
        }
        return analyzer;
    }

    public static PreBuiltAnalyzers getOrDefault(String name, PreBuiltAnalyzers defaultAnalyzer) {
        try {
            return PreBuiltAnalyzers.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultAnalyzer;
        }
    }
}

