/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.mapper.BaseGeoPointFieldMapper;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.search.geo.LegacyIndexedGeoBoundingBoxQuery;

@Deprecated
public class LegacyGeoDistanceRangeQuery
extends Query {
    private final double lat;
    private final double lon;
    private final double inclusiveLowerPoint;
    private final double inclusiveUpperPoint;
    private final GeoDistance geoDistance;
    private final Query boundingBoxFilter;
    private final Rectangle bbox;
    private final IndexGeoPointFieldData indexFieldData;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LegacyGeoDistanceRangeQuery(GeoPoint point, Double lowerVal, Double upperVal, boolean includeLower, boolean includeUpper, GeoDistance geoDistance, BaseGeoPointFieldMapper.LegacyGeoPointFieldType fieldType, IndexGeoPointFieldData indexFieldData, String optimizeBbox, QueryShardContext context) {
        long i;
        double f;
        this.lat = point.lat();
        this.lon = point.lon();
        this.geoDistance = geoDistance;
        this.indexFieldData = indexFieldData;
        if (lowerVal != null) {
            f = lowerVal;
            i = NumericUtils.doubleToSortableLong((double)f);
            this.inclusiveLowerPoint = NumericUtils.sortableLongToDouble((long)(includeLower ? i : i + 1L));
        } else {
            this.inclusiveLowerPoint = Double.NEGATIVE_INFINITY;
        }
        if (upperVal != null) {
            f = upperVal;
            i = NumericUtils.doubleToSortableLong((double)f);
            this.inclusiveUpperPoint = NumericUtils.sortableLongToDouble((long)(includeUpper ? i : i - 1L));
        } else {
            this.inclusiveUpperPoint = Double.POSITIVE_INFINITY;
            optimizeBbox = null;
        }
        if (optimizeBbox != null && !"none".equals(optimizeBbox)) {
            this.bbox = Rectangle.fromPointDistance((double)this.lat, (double)this.lon, (double)this.inclusiveUpperPoint);
            if ("memory".equals(optimizeBbox)) {
                this.boundingBoxFilter = null;
                return;
            } else {
                if (!"indexed".equals(optimizeBbox)) throw new IllegalArgumentException("type [" + optimizeBbox + "] for bounding box optimization not supported");
                this.boundingBoxFilter = LegacyIndexedGeoBoundingBoxQuery.create(this.bbox, fieldType, context);
            }
            return;
        } else {
            this.bbox = null;
            this.boundingBoxFilter = null;
        }
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public double minInclusiveDistance() {
        return this.inclusiveLowerPoint;
    }

    public double maxInclusiveDistance() {
        return this.inclusiveUpperPoint;
    }

    public String fieldName() {
        return this.indexFieldData.getFieldName();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return super.rewrite(reader);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight boundingBoxWeight = this.boundingBoxFilter != null ? searcher.createNormalizedWeight(this.boundingBoxFilter, false) : null;
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSetIterator approximation;
                if (boundingBoxWeight != null) {
                    Scorer s2 = boundingBoxWeight.scorer(context);
                    if (s2 == null) {
                        return null;
                    }
                    approximation = s2.iterator();
                } else {
                    approximation = DocIdSetIterator.all((int)context.reader().maxDoc());
                }
                final MultiGeoPointValues values = ((AtomicGeoPointFieldData)LegacyGeoDistanceRangeQuery.this.indexFieldData.load(context)).getGeoPointValues();
                TwoPhaseIterator twoPhaseIterator = new TwoPhaseIterator(approximation){

                    public boolean matches() throws IOException {
                        int doc = this.approximation.docID();
                        values.setDocument(doc);
                        int length = values.count();
                        for (int i = 0; i < length; ++i) {
                            double d;
                            GeoPoint point = values.valueAt(i);
                            if (LegacyGeoDistanceRangeQuery.this.bbox != null && !GeoUtils.rectangleContainsPoint(LegacyGeoDistanceRangeQuery.this.bbox, point.lat(), point.lon()) || !((d = LegacyGeoDistanceRangeQuery.this.geoDistance.calculate(LegacyGeoDistanceRangeQuery.this.lat, LegacyGeoDistanceRangeQuery.this.lon, point.lat(), point.lon(), DistanceUnit.DEFAULT)) >= LegacyGeoDistanceRangeQuery.this.inclusiveLowerPoint) || !(d <= LegacyGeoDistanceRangeQuery.this.inclusiveUpperPoint)) continue;
                            return true;
                        }
                        return false;
                    }

                    public float matchCost() {
                        if (LegacyGeoDistanceRangeQuery.this.bbox != null) {
                            return values.count();
                        }
                        return 4.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), twoPhaseIterator);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        LegacyGeoDistanceRangeQuery filter = (LegacyGeoDistanceRangeQuery)((Object)o);
        if (Double.compare(filter.inclusiveLowerPoint, this.inclusiveLowerPoint) != 0) {
            return false;
        }
        if (Double.compare(filter.inclusiveUpperPoint, this.inclusiveUpperPoint) != 0) {
            return false;
        }
        if (Double.compare(filter.lat, this.lat) != 0) {
            return false;
        }
        if (Double.compare(filter.lon, this.lon) != 0) {
            return false;
        }
        if (!this.indexFieldData.getFieldName().equals(filter.indexFieldData.getFieldName())) {
            return false;
        }
        if (this.geoDistance != filter.geoDistance) {
            return false;
        }
        if (this.boundingBoxFilter == null && filter.boundingBoxFilter != null) {
            return false;
        }
        if (this.boundingBoxFilter != null && !this.boundingBoxFilter.equals((Object)filter.boundingBoxFilter)) {
            return false;
        }
        if (this.bbox == null && filter.bbox != null) {
            return false;
        }
        return this.bbox == null || this.bbox.equals((Object)filter.bbox);
    }

    public String toString(String field) {
        return "GeoDistanceRangeQuery(" + this.indexFieldData.getFieldName() + ", " + this.geoDistance + ", [" + this.inclusiveLowerPoint + " - " + this.inclusiveUpperPoint + "], " + this.lat + ", " + this.lon + ")";
    }

    public int hashCode() {
        int result = this.classHash();
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        result = 31 * result + Long.hashCode(temp);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + Long.hashCode(temp);
        temp = this.inclusiveLowerPoint != 0.0 ? Double.doubleToLongBits(this.inclusiveLowerPoint) : 0L;
        result = 31 * result + Long.hashCode(temp);
        temp = this.inclusiveUpperPoint != 0.0 ? Double.doubleToLongBits(this.inclusiveUpperPoint) : 0L;
        result = 31 * result + Long.hashCode(temp);
        result = 31 * result + (this.geoDistance != null ? this.geoDistance.hashCode() : 0);
        result = 31 * result + this.indexFieldData.getFieldName().hashCode();
        result = 31 * result + Objects.hash(this.boundingBoxFilter, this.bbox);
        return result;
    }
}

