/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;

public class GeoPolygonQuery
extends Query {
    private final GeoPoint[] points;
    private final IndexGeoPointFieldData indexFieldData;

    public GeoPolygonQuery(IndexGeoPointFieldData indexFieldData, GeoPoint ... points) {
        this.points = points;
        this.indexFieldData = indexFieldData;
    }

    public GeoPoint[] points() {
        return this.points;
    }

    public String fieldName() {
        return this.indexFieldData.getFieldName();
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new RandomAccessWeight(this){

            protected Bits getMatchingDocs(LeafReaderContext context) throws IOException {
                final int maxDoc = context.reader().maxDoc();
                final MultiGeoPointValues values = ((AtomicGeoPointFieldData)GeoPolygonQuery.this.indexFieldData.load(context)).getGeoPointValues();
                return new Bits(){

                    private boolean pointInPolygon(GeoPoint[] points, double lat, double lon) {
                        boolean inPoly = false;
                        for (int i = 1; i < points.length; ++i) {
                            if (!(points[i].lon() < lon && points[i - 1].lon() >= lon) && (!(points[i - 1].lon() < lon) || !(points[i].lon() >= lon)) || !(points[i].lat() + (lon - points[i].lon()) / (points[i - 1].lon() - points[i].lon()) * (points[i - 1].lat() - points[i].lat()) < lat)) continue;
                            inPoly = !inPoly;
                        }
                        return inPoly;
                    }

                    public boolean get(int doc) {
                        values.setDocument(doc);
                        int length = values.count();
                        for (int i = 0; i < length; ++i) {
                            GeoPoint point = values.valueAt(i);
                            if (!this.pointInPolygon(GeoPolygonQuery.this.points, point.lat(), point.lon())) continue;
                            return true;
                        }
                        return false;
                    }

                    public int length() {
                        return maxDoc;
                    }
                };
            }
        };
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder("GeoPolygonQuery(");
        sb.append(this.indexFieldData.getFieldName());
        sb.append(", ").append(Arrays.toString(this.points)).append(')');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        GeoPolygonQuery that = (GeoPolygonQuery)((Object)obj);
        return this.indexFieldData.getFieldName().equals(that.indexFieldData.getFieldName()) && Arrays.equals(this.points, that.points);
    }

    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + this.indexFieldData.getFieldName().hashCode();
        h2 = 31 * h2 + Arrays.hashCode(this.points);
        return h2;
    }
}

