/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.function.RandomScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;

public class RandomScoreFunctionBuilder
extends ScoreFunctionBuilder<RandomScoreFunctionBuilder> {
    public static final String NAME = "random_score";
    private Integer seed;

    public RandomScoreFunctionBuilder() {
    }

    public RandomScoreFunctionBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.seed = in.readInt();
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.seed != null) {
            out.writeBoolean(true);
            out.writeInt(this.seed);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public RandomScoreFunctionBuilder seed(int seed) {
        this.seed = seed;
        return this;
    }

    public RandomScoreFunctionBuilder seed(long seed) {
        this.seed = RandomScoreFunctionBuilder.hash(seed);
        return this;
    }

    public RandomScoreFunctionBuilder seed(String seed) {
        if (seed == null) {
            throw new IllegalArgumentException("random_score function: seed must not be null");
        }
        this.seed = seed.hashCode();
        return this;
    }

    public Integer getSeed() {
        return this.seed;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        if (this.seed != null) {
            builder.field("seed", this.seed);
        }
        builder.endObject();
    }

    @Override
    protected boolean doEquals(RandomScoreFunctionBuilder functionBuilder) {
        return Objects.equals(this.seed, functionBuilder.seed);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.seed);
    }

    @Override
    protected ScoreFunction doToFunction(QueryShardContext context) {
        MappedFieldType fieldType = context.getMapperService().fullName("_uid");
        if (fieldType == null) {
            return new RandomScoreFunction();
        }
        int salt = context.index().getName().hashCode() << 10 | context.getShardId();
        Object uidFieldData = context.getForField(fieldType);
        return new RandomScoreFunction(this.seed == null ? RandomScoreFunctionBuilder.hash(context.nowInMillis()) : this.seed, salt, (IndexFieldData<?>)uidFieldData);
    }

    private static int hash(long value) {
        return Long.hashCode(value);
    }

    public static RandomScoreFunctionBuilder fromXContent(QueryParseContext parseContext) throws IOException, ParsingException {
        XContentParser.Token token;
        XContentParser parser2 = parseContext.parser();
        RandomScoreFunctionBuilder randomScoreFunctionBuilder = new RandomScoreFunctionBuilder();
        String currentFieldName = null;
        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser2.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("seed".equals(currentFieldName)) {
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (parser2.numberType() == XContentParser.NumberType.INT) {
                        randomScoreFunctionBuilder.seed(parser2.intValue());
                        continue;
                    }
                    if (parser2.numberType() == XContentParser.NumberType.LONG) {
                        randomScoreFunctionBuilder.seed(parser2.longValue());
                        continue;
                    }
                    throw new ParsingException(parser2.getTokenLocation(), "random_score seed must be an int, long or string, not '" + token.toString() + "'", new Object[0]);
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    randomScoreFunctionBuilder.seed(parser2.text());
                    continue;
                }
                throw new ParsingException(parser2.getTokenLocation(), "random_score seed must be an int/long or string, not '" + token.toString() + "'", new Object[0]);
            }
            throw new ParsingException(parser2.getTokenLocation(), "random_score query does not support [" + currentFieldName + "]", new Object[0]);
        }
        return randomScoreFunctionBuilder;
    }
}

