/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.ShapesAvailability;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public class GeoShapeQueryBuilder
extends AbstractQueryBuilder<GeoShapeQueryBuilder> {
    public static final String NAME = "geo_shape";
    public static final String DEFAULT_SHAPE_INDEX_NAME = "shapes";
    public static final String DEFAULT_SHAPE_FIELD_NAME = "shape";
    public static final ShapeRelation DEFAULT_SHAPE_RELATION = ShapeRelation.INTERSECTS;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField SHAPE_FIELD = new ParseField("shape", new String[0]);
    private static final ParseField STRATEGY_FIELD = new ParseField("strategy", new String[0]);
    private static final ParseField RELATION_FIELD = new ParseField("relation", new String[0]);
    private static final ParseField INDEXED_SHAPE_FIELD = new ParseField("indexed_shape", new String[0]);
    private static final ParseField SHAPE_ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField SHAPE_TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField SHAPE_INDEX_FIELD = new ParseField("index", new String[0]);
    private static final ParseField SHAPE_PATH_FIELD = new ParseField("path", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private final ShapeBuilder shape;
    private SpatialStrategy strategy;
    private final String indexedShapeId;
    private final String indexedShapeType;
    private String indexedShapeIndex = "shapes";
    private String indexedShapePath = "shape";
    private ShapeRelation relation = DEFAULT_SHAPE_RELATION;
    private boolean ignoreUnmapped = false;

    public GeoShapeQueryBuilder(String fieldName, ShapeBuilder shape) {
        this(fieldName, shape, null, null);
    }

    public GeoShapeQueryBuilder(String fieldName, String indexedShapeId, String indexedShapeType) {
        this(fieldName, null, indexedShapeId, indexedShapeType);
    }

    private GeoShapeQueryBuilder(String fieldName, ShapeBuilder shape, String indexedShapeId, String indexedShapeType) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is required");
        }
        if (shape == null && indexedShapeId == null) {
            throw new IllegalArgumentException("either shapeBytes or indexedShapeId and indexedShapeType are required");
        }
        if (indexedShapeId != null && indexedShapeType == null) {
            throw new IllegalArgumentException("indexedShapeType is required if indexedShapeId is specified");
        }
        this.fieldName = fieldName;
        this.shape = shape;
        this.indexedShapeId = indexedShapeId;
        this.indexedShapeType = indexedShapeType;
    }

    public GeoShapeQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        if (in.readBoolean()) {
            this.shape = in.readNamedWriteable(ShapeBuilder.class);
            this.indexedShapeId = null;
            this.indexedShapeType = null;
        } else {
            this.shape = null;
            this.indexedShapeId = in.readOptionalString();
            this.indexedShapeType = in.readOptionalString();
            this.indexedShapeIndex = in.readOptionalString();
            this.indexedShapePath = in.readOptionalString();
        }
        this.relation = ShapeRelation.readFromStream(in);
        this.strategy = in.readOptionalWriteable(SpatialStrategy::readFromStream);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        boolean hasShape = this.shape != null;
        out.writeBoolean(hasShape);
        if (hasShape) {
            out.writeNamedWriteable(this.shape);
        } else {
            out.writeOptionalString(this.indexedShapeId);
            out.writeOptionalString(this.indexedShapeType);
            out.writeOptionalString(this.indexedShapeIndex);
            out.writeOptionalString(this.indexedShapePath);
        }
        this.relation.writeTo(out);
        out.writeOptionalWriteable(this.strategy);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public ShapeBuilder shape() {
        return this.shape;
    }

    public String indexedShapeId() {
        return this.indexedShapeId;
    }

    public String indexedShapeType() {
        return this.indexedShapeType;
    }

    public GeoShapeQueryBuilder strategy(SpatialStrategy strategy) {
        if (strategy != null && strategy == SpatialStrategy.TERM && this.relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("strategy [" + strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + this.relation.getRelationName() + "]");
        }
        this.strategy = strategy;
        return this;
    }

    public SpatialStrategy strategy() {
        return this.strategy;
    }

    public GeoShapeQueryBuilder indexedShapeIndex(String indexedShapeIndex) {
        this.indexedShapeIndex = indexedShapeIndex;
        return this;
    }

    public String indexedShapeIndex() {
        return this.indexedShapeIndex;
    }

    public GeoShapeQueryBuilder indexedShapePath(String indexedShapePath) {
        this.indexedShapePath = indexedShapePath;
        return this;
    }

    public String indexedShapePath() {
        return this.indexedShapePath;
    }

    public GeoShapeQueryBuilder relation(ShapeRelation relation) {
        if (relation == null) {
            throw new IllegalArgumentException("No Shape Relation defined");
        }
        if (this.strategy != null && this.strategy == SpatialStrategy.TERM && relation != ShapeRelation.INTERSECTS) {
            throw new IllegalArgumentException("current strategy [" + this.strategy.getStrategyName() + "] only supports relation [" + ShapeRelation.INTERSECTS.getRelationName() + "] found relation [" + relation.getRelationName() + "]");
        }
        this.relation = relation;
        return this;
    }

    public ShapeRelation relation() {
        return this.relation;
    }

    public GeoShapeQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) {
        ConstantScoreQuery query;
        if (this.shape == null) {
            throw new UnsupportedOperationException("query must be rewritten first");
        }
        ShapeBuilder shapeToQuery = this.shape;
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "failed to find geo_shape field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof GeoShapeFieldMapper.GeoShapeFieldType)) {
            throw new QueryShardException(context, "Field [" + this.fieldName + "] is not a geo_shape", new Object[0]);
        }
        GeoShapeFieldMapper.GeoShapeFieldType shapeFieldType = (GeoShapeFieldMapper.GeoShapeFieldType)fieldType;
        PrefixTreeStrategy strategy = shapeFieldType.defaultStrategy();
        if (this.strategy != null) {
            strategy = shapeFieldType.resolveStrategy(this.strategy);
        }
        if (strategy instanceof RecursivePrefixTreeStrategy && this.relation == ShapeRelation.DISJOINT) {
            BooleanQuery.Builder bool = new BooleanQuery.Builder();
            Query exists = ExistsQueryBuilder.newFilter(context, this.fieldName);
            Query intersects = strategy.makeQuery(GeoShapeQueryBuilder.getArgs(shapeToQuery, ShapeRelation.INTERSECTS));
            bool.add(exists, BooleanClause.Occur.MUST);
            bool.add(intersects, BooleanClause.Occur.MUST_NOT);
            query = new ConstantScoreQuery((Query)bool.build());
        } else {
            query = new ConstantScoreQuery(strategy.makeQuery(GeoShapeQueryBuilder.getArgs(shapeToQuery, this.relation)));
        }
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ShapeBuilder fetch(Client client, GetRequest getRequest, String path) throws IOException {
        if (!ShapesAvailability.JTS_AVAILABLE) {
            throw new IllegalStateException("JTS not available");
        }
        getRequest.preference("_local");
        getRequest.operationThreaded(false);
        GetResponse response = client.get(getRequest).actionGet();
        if (!response.isExists()) {
            throw new IllegalArgumentException("Shape with ID [" + getRequest.id() + "] in type [" + getRequest.type() + "] not found");
        }
        if (response.isSourceEmpty()) {
            throw new IllegalArgumentException("Shape with ID [" + getRequest.id() + "] in type [" + getRequest.type() + "] source disabled");
        }
        String[] pathElements = path.split("\\.");
        int currentPathSlot = 0;
        try (XContentParser parser2 = XContentHelper.createParser(NamedXContentRegistry.EMPTY, response.getSourceAsBytesRef());){
            XContentParser.Token currentToken;
            while ((currentToken = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (currentToken != XContentParser.Token.FIELD_NAME) continue;
                if (pathElements[currentPathSlot].equals(parser2.currentName())) {
                    parser2.nextToken();
                    if (++currentPathSlot != pathElements.length) continue;
                    ShapeBuilder shapeBuilder = ShapeBuilder.parse(parser2);
                    return shapeBuilder;
                }
                parser2.nextToken();
                parser2.skipChildren();
            }
            throw new IllegalStateException("Shape with name [" + getRequest.id() + "] found but missing " + path + " field");
        }
    }

    public static SpatialArgs getArgs(ShapeBuilder shape, ShapeRelation relation) {
        switch (relation) {
            case DISJOINT: {
                return new SpatialArgs(SpatialOperation.IsDisjointTo, shape.build());
            }
            case INTERSECTS: {
                return new SpatialArgs(SpatialOperation.Intersects, shape.build());
            }
            case WITHIN: {
                return new SpatialArgs(SpatialOperation.IsWithin, shape.build());
            }
            case CONTAINS: {
                return new SpatialArgs(SpatialOperation.Contains, shape.build());
            }
        }
        throw new IllegalArgumentException("invalid relation [" + relation + "]");
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        if (this.strategy != null) {
            builder.field(STRATEGY_FIELD.getPreferredName(), this.strategy.getStrategyName());
        }
        if (this.shape != null) {
            builder.field(SHAPE_FIELD.getPreferredName());
            this.shape.toXContent(builder, params);
        } else {
            builder.startObject(INDEXED_SHAPE_FIELD.getPreferredName()).field(SHAPE_ID_FIELD.getPreferredName(), this.indexedShapeId).field(SHAPE_TYPE_FIELD.getPreferredName(), this.indexedShapeType);
            if (this.indexedShapeIndex != null) {
                builder.field(SHAPE_INDEX_FIELD.getPreferredName(), this.indexedShapeIndex);
            }
            if (this.indexedShapePath != null) {
                builder.field(SHAPE_PATH_FIELD.getPreferredName(), this.indexedShapePath);
            }
            builder.endObject();
        }
        if (this.relation != null) {
            builder.field(RELATION_FIELD.getPreferredName(), this.relation.getRelationName());
        }
        builder.endObject();
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<GeoShapeQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser2 = parseContext.parser();
        String fieldName = null;
        ShapeRelation shapeRelation = null;
        SpatialStrategy strategy = null;
        ShapeBuilder shape = null;
        String id = null;
        String type = null;
        String index = null;
        String shapePath = null;
        String currentFieldName = null;
        float boost = 1.0f;
        String queryName = null;
        boolean ignoreUnmapped = false;
        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser2.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (fieldName != null) {
                    throw new ParsingException(parser2.getTokenLocation(), "[geo_shape] point specified twice. [" + currentFieldName + "]", new Object[0]);
                }
                fieldName = currentFieldName;
                while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    currentFieldName = parser2.currentName();
                    token = parser2.nextToken();
                    if (SHAPE_FIELD.match(currentFieldName)) {
                        shape = ShapeBuilder.parse(parser2);
                        continue;
                    }
                    if (STRATEGY_FIELD.match(currentFieldName)) {
                        String strategyName = parser2.text();
                        strategy = SpatialStrategy.fromString(strategyName);
                        if (strategy != null) continue;
                        throw new ParsingException(parser2.getTokenLocation(), "Unknown strategy [" + strategyName + " ]", new Object[0]);
                    }
                    if (RELATION_FIELD.match(currentFieldName)) {
                        shapeRelation = ShapeRelation.getRelationByName(parser2.text());
                        if (shapeRelation != null) continue;
                        throw new ParsingException(parser2.getTokenLocation(), "Unknown shape operation [" + parser2.text() + " ]", new Object[0]);
                    }
                    if (INDEXED_SHAPE_FIELD.match(currentFieldName)) {
                        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser2.currentName();
                                continue;
                            }
                            if (token.isValue()) {
                                if (SHAPE_ID_FIELD.match(currentFieldName)) {
                                    id = parser2.text();
                                    continue;
                                }
                                if (SHAPE_TYPE_FIELD.match(currentFieldName)) {
                                    type = parser2.text();
                                    continue;
                                }
                                if (SHAPE_INDEX_FIELD.match(currentFieldName)) {
                                    index = parser2.text();
                                    continue;
                                }
                                if (!SHAPE_PATH_FIELD.match(currentFieldName)) continue;
                                shapePath = parser2.text();
                                continue;
                            }
                            throw new ParsingException(parser2.getTokenLocation(), "[geo_shape] unknown token [" + (Object)((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
                        }
                        continue;
                    }
                    throw new ParsingException(parser2.getTokenLocation(), "[geo_shape] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser2.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser2.text();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName)) {
                ignoreUnmapped = parser2.booleanValue();
                continue;
            }
            throw new ParsingException(parser2.getTokenLocation(), "[geo_shape] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        GeoShapeQueryBuilder builder = shape != null ? new GeoShapeQueryBuilder(fieldName, shape) : new GeoShapeQueryBuilder(fieldName, id, type);
        if (index != null) {
            builder.indexedShapeIndex(index);
        }
        if (shapePath != null) {
            builder.indexedShapePath(shapePath);
        }
        if (shapeRelation != null) {
            builder.relation(shapeRelation);
        }
        if (strategy != null) {
            builder.strategy(strategy);
        }
        if (queryName != null) {
            builder.queryName(queryName);
        }
        builder.boost(boost);
        builder.ignoreUnmapped(ignoreUnmapped);
        return Optional.of(builder);
    }

    @Override
    protected boolean doEquals(GeoShapeQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.indexedShapeId, other.indexedShapeId) && Objects.equals(this.indexedShapeIndex, other.indexedShapeIndex) && Objects.equals(this.indexedShapePath, other.indexedShapePath) && Objects.equals(this.indexedShapeType, other.indexedShapeType) && Objects.equals(this.relation, other.relation) && Objects.equals(this.shape, other.shape) && Objects.equals(this.strategy, other.strategy) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.indexedShapeId, this.indexedShapeIndex, this.indexedShapePath, this.indexedShapeType, this.relation, this.shape, this.strategy, this.ignoreUnmapped);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        if (this.shape == null) {
            GetRequest getRequest = new GetRequest(this.indexedShapeIndex, this.indexedShapeType, this.indexedShapeId);
            ShapeBuilder shape = this.fetch(queryShardContext.getClient(), getRequest, this.indexedShapePath);
            return new GeoShapeQueryBuilder(this.fieldName, shape).relation(this.relation).strategy(this.strategy);
        }
        return this;
    }
}

