/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointDistanceQuery;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.mapper.BaseGeoPointFieldMapper;
import org.elasticsearch.index.mapper.LatLonPointFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.QueryValidationException;
import org.elasticsearch.index.search.geo.LegacyGeoDistanceRangeQuery;

public class GeoDistanceQueryBuilder
extends AbstractQueryBuilder<GeoDistanceQueryBuilder> {
    public static final String NAME = "geo_distance";
    public static final boolean DEFAULT_NORMALIZE_LAT = true;
    public static final boolean DEFAULT_NORMALIZE_LON = true;
    public static final DistanceUnit DEFAULT_DISTANCE_UNIT = DistanceUnit.DEFAULT;
    public static final GeoDistance DEFAULT_GEO_DISTANCE = GeoDistance.ARC;
    @Deprecated
    public static final String DEFAULT_OPTIMIZE_BBOX = "memory";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField VALIDATION_METHOD_FIELD = new ParseField("validation_method", new String[0]);
    private static final ParseField IGNORE_MALFORMED_FIELD = new ParseField("ignore_malformed", new String[0]).withAllDeprecated("validation_method");
    private static final ParseField COERCE_FIELD = new ParseField("coerce", "normalize").withAllDeprecated("validation_method");
    @Deprecated
    private static final ParseField OPTIMIZE_BBOX_FIELD = new ParseField("optimize_bbox", new String[0]).withAllDeprecated("no replacement: `optimize_bbox` is no longer supported due to recent improvements");
    private static final ParseField DISTANCE_TYPE_FIELD = new ParseField("distance_type", new String[0]);
    private static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    private static final ParseField DISTANCE_FIELD = new ParseField("distance", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private double distance;
    private GeoPoint center = new GeoPoint(Double.NaN, Double.NaN);
    private GeoDistance geoDistance = GeoDistance.ARC;
    private String optimizeBbox = null;
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;
    private boolean ignoreUnmapped = false;

    public GeoDistanceQueryBuilder(String fieldName) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("fieldName must not be null or empty");
        }
        this.fieldName = fieldName;
    }

    public GeoDistanceQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.distance = in.readDouble();
        this.validationMethod = GeoValidationMethod.readFromStream(in);
        this.center = in.readGeoPoint();
        this.optimizeBbox = in.readOptionalString();
        this.geoDistance = GeoDistance.readFromStream(in);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeDouble(this.distance);
        this.validationMethod.writeTo(out);
        out.writeGeoPoint(this.center);
        out.writeOptionalString(this.optimizeBbox);
        this.geoDistance.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoDistanceQueryBuilder point(GeoPoint point) {
        if (point == null) {
            throw new IllegalArgumentException("center point must not be null");
        }
        this.center = point;
        return this;
    }

    public GeoDistanceQueryBuilder point(double lat, double lon) {
        this.center = new GeoPoint(lat, lon);
        return this;
    }

    public GeoPoint point() {
        return this.center;
    }

    public GeoDistanceQueryBuilder distance(String distance) {
        return this.distance(distance, DistanceUnit.DEFAULT);
    }

    public GeoDistanceQueryBuilder distance(String distance, DistanceUnit unit) {
        if (Strings.isEmpty(distance)) {
            throw new IllegalArgumentException("distance must not be null or empty");
        }
        if (unit == null) {
            throw new IllegalArgumentException("distance unit must not be null");
        }
        double newDistance = DistanceUnit.parse(distance, unit, DistanceUnit.DEFAULT);
        if (newDistance <= 0.0) {
            throw new IllegalArgumentException("distance must be greater than zero");
        }
        this.distance = newDistance;
        return this;
    }

    public GeoDistanceQueryBuilder distance(double distance, DistanceUnit unit) {
        return this.distance(Double.toString(distance), unit);
    }

    public double distance() {
        return this.distance;
    }

    public GeoDistanceQueryBuilder geohash(String geohash) {
        if (Strings.isEmpty(geohash)) {
            throw new IllegalArgumentException("geohash must not be null or empty");
        }
        this.center.resetFromGeoHash(geohash);
        return this;
    }

    public GeoDistanceQueryBuilder geoDistance(GeoDistance geoDistance) {
        if (geoDistance == null) {
            throw new IllegalArgumentException("geoDistance must not be null");
        }
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    @Deprecated
    public GeoDistanceQueryBuilder optimizeBbox(String optimizeBbox) {
        this.optimizeBbox = optimizeBbox;
        return this;
    }

    @Deprecated
    public String optimizeBbox() {
        return this.optimizeBbox;
    }

    public void setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
    }

    public GeoValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public GeoDistanceQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected Query doToQuery(QueryShardContext shardContext) throws IOException {
        MappedFieldType fieldType = shardContext.fieldMapper(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(shardContext, "failed to find geo_point field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof BaseGeoPointFieldMapper.GeoPointFieldType)) {
            throw new QueryShardException(shardContext, "field [" + this.fieldName + "] is not a geo_point field", new Object[0]);
        }
        Version indexVersionCreated = shardContext.indexVersionCreated();
        QueryValidationException exception = this.checkLatLon(shardContext.indexVersionCreated().before(Version.V_2_0_0));
        if (exception != null) {
            throw new QueryShardException(shardContext, "couldn't validate latitude/ longitude values", exception, new Object[0]);
        }
        if (indexVersionCreated.onOrAfter(Version.V_2_2_0) || GeoValidationMethod.isCoerce(this.validationMethod)) {
            GeoUtils.normalizePoint(this.center, true, true);
        }
        if (indexVersionCreated.onOrAfter(LatLonPointFieldMapper.LAT_LON_FIELD_VERSION)) {
            Query query = LatLonPoint.newDistanceQuery((String)fieldType.name(), (double)this.center.lat(), (double)this.center.lon(), (double)this.distance);
            if (fieldType.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newDistanceQuery((String)fieldType.name(), (double)this.center.lat(), (double)this.center.lon(), (double)this.distance);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }
        if (indexVersionCreated.before(Version.V_2_2_0)) {
            BaseGeoPointFieldMapper.LegacyGeoPointFieldType geoFieldType = (BaseGeoPointFieldMapper.LegacyGeoPointFieldType)fieldType;
            IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)shardContext.getForField(fieldType);
            String bboxOptimization = Strings.isEmpty(this.optimizeBbox) ? DEFAULT_OPTIMIZE_BBOX : this.optimizeBbox;
            return new LegacyGeoDistanceRangeQuery(this.center, null, this.distance, true, false, this.geoDistance, geoFieldType, indexFieldData, bboxOptimization, shardContext);
        }
        GeoPointField.TermEncoding encoding = indexVersionCreated.before(Version.V_2_3_0) ? GeoPointField.TermEncoding.NUMERIC : GeoPointField.TermEncoding.PREFIX;
        double normDistance = this.distance;
        if (indexVersionCreated.before(Version.V_5_0_0_alpha4)) {
            normDistance = GeoUtils.maxRadialDistance(this.center, normDistance);
        }
        return new GeoPointDistanceQuery(fieldType.name(), encoding, this.center.lat(), this.center.lon(), normDistance);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray(this.fieldName).value(this.center.lon()).value(this.center.lat()).endArray();
        builder.field(DISTANCE_FIELD.getPreferredName(), this.distance);
        builder.field(DISTANCE_TYPE_FIELD.getPreferredName(), this.geoDistance.name().toLowerCase(Locale.ROOT));
        if (!Strings.isEmpty(this.optimizeBbox)) {
            builder.field(OPTIMIZE_BBOX_FIELD.getPreferredName(), this.optimizeBbox);
        }
        builder.field(VALIDATION_METHOD_FIELD.getPreferredName(), this.validationMethod);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<GeoDistanceQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser2 = parseContext.parser();
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        GeoPoint point = new GeoPoint(Double.NaN, Double.NaN);
        String fieldName = null;
        Object vDistance = null;
        DistanceUnit unit = DEFAULT_DISTANCE_UNIT;
        GeoDistance geoDistance = DEFAULT_GEO_DISTANCE;
        String optimizeBbox = null;
        boolean coerce = GeoValidationMethod.DEFAULT_LENIENT_PARSING;
        boolean ignoreMalformed = GeoValidationMethod.DEFAULT_LENIENT_PARSING;
        GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser2.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_ARRAY) {
                fieldName = currentFieldName;
                GeoUtils.parseGeoPoint(parser2, point);
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                GeoDistanceQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser2.getTokenLocation(), fieldName, currentFieldName);
                String currentName = parser2.currentName();
                fieldName = currentFieldName;
                while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentName = parser2.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if (currentName.equals("lat")) {
                        point.resetLat(parser2.doubleValue());
                        continue;
                    }
                    if (currentName.equals("lon")) {
                        point.resetLon(parser2.doubleValue());
                        continue;
                    }
                    if (currentName.equals("geohash")) {
                        point.resetFromGeoHash(parser2.text());
                        continue;
                    }
                    throw new ParsingException(parser2.getTokenLocation(), "[geo_distance] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (DISTANCE_FIELD.match(currentFieldName)) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    vDistance = parser2.text();
                    continue;
                }
                vDistance = parser2.numberValue();
                continue;
            }
            if (UNIT_FIELD.match(currentFieldName)) {
                unit = DistanceUnit.fromString(parser2.text());
                continue;
            }
            if (DISTANCE_TYPE_FIELD.match(currentFieldName)) {
                geoDistance = GeoDistance.fromString(parser2.text());
                continue;
            }
            if (currentFieldName.endsWith(".lat")) {
                point.resetLat(parser2.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lat".length());
                continue;
            }
            if (currentFieldName.endsWith(".lon")) {
                point.resetLon(parser2.doubleValue());
                fieldName = currentFieldName.substring(0, currentFieldName.length() - ".lon".length());
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser2.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser2.floatValue();
                continue;
            }
            if (OPTIMIZE_BBOX_FIELD.match(currentFieldName)) {
                optimizeBbox = parser2.textOrNull();
                continue;
            }
            if (COERCE_FIELD.match(currentFieldName)) {
                coerce = parser2.booleanValue();
                if (!coerce) continue;
                ignoreMalformed = true;
                continue;
            }
            if (IGNORE_MALFORMED_FIELD.match(currentFieldName)) {
                ignoreMalformed = parser2.booleanValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName)) {
                ignoreUnmapped = parser2.booleanValue();
                continue;
            }
            if (VALIDATION_METHOD_FIELD.match(currentFieldName)) {
                validationMethod = GeoValidationMethod.fromString(parser2.text());
                continue;
            }
            if (fieldName == null) {
                point.resetFromString(parser2.text());
                fieldName = currentFieldName;
                continue;
            }
            throw new ParsingException(parser2.getTokenLocation(), "[geo_distance] field name already set to [" + fieldName + "] but found [" + currentFieldName + "]", new Object[0]);
        }
        if (vDistance == null) {
            throw new ParsingException(parser2.getTokenLocation(), "geo_distance requires 'distance' to be specified", new Object[0]);
        }
        GeoDistanceQueryBuilder qb = new GeoDistanceQueryBuilder(fieldName);
        if (vDistance instanceof Number) {
            qb.distance(((Number)vDistance).doubleValue(), unit);
        } else {
            qb.distance((String)vDistance, unit);
        }
        qb.point(point);
        if (validationMethod != null) {
            qb.setValidationMethod(validationMethod);
        } else {
            qb.setValidationMethod(GeoValidationMethod.infer(coerce, ignoreMalformed));
        }
        qb.optimizeBbox(optimizeBbox);
        qb.geoDistance(geoDistance);
        qb.boost(boost);
        qb.queryName(queryName);
        qb.ignoreUnmapped(ignoreUnmapped);
        return Optional.of(qb);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.center, this.geoDistance, this.optimizeBbox, this.distance, this.validationMethod, this.ignoreUnmapped);
    }

    @Override
    protected boolean doEquals(GeoDistanceQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && this.distance == other.distance && Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.center, other.center) && Objects.equals(this.optimizeBbox, other.optimizeBbox) && Objects.equals(this.geoDistance, other.geoDistance) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    private QueryValidationException checkLatLon(boolean indexCreatedBeforeV2_0) {
        if (GeoValidationMethod.isIgnoreMalformed(this.validationMethod) || indexCreatedBeforeV2_0) {
            return null;
        }
        QueryValidationException validationException = null;
        if (!GeoUtils.isValidLatitude(this.center.getLat())) {
            validationException = this.addValidationError("center point latitude is invalid: " + this.center.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude(this.center.getLon())) {
            validationException = this.addValidationError("center point longitude is invalid: " + this.center.getLon(), validationException);
        }
        return validationException;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

