/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.FieldMaskingSpanQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class FieldMaskingSpanQueryBuilder
extends AbstractQueryBuilder<FieldMaskingSpanQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "field_masking_span";
    private static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private final SpanQueryBuilder queryBuilder;
    private final String fieldName;

    public FieldMaskingSpanQueryBuilder(SpanQueryBuilder queryBuilder, String fieldName) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner clause [query] cannot be null.");
        }
        this.queryBuilder = queryBuilder;
        this.fieldName = fieldName;
    }

    public FieldMaskingSpanQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryBuilder = (SpanQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.fieldName = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.queryBuilder);
        out.writeString(this.fieldName);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public SpanQueryBuilder innerQuery() {
        return this.queryBuilder;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.queryBuilder.toXContent(builder, params);
        builder.field(FIELD_FIELD.getPreferredName(), this.fieldName);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<FieldMaskingSpanQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser2 = parseContext.parser();
        float boost = 1.0f;
        SpanQueryBuilder inner = null;
        String field = null;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser2.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName)) {
                    Optional<QueryBuilder> query = parseContext.parseInnerQueryBuilder();
                    if (!query.isPresent() || !(query.get() instanceof SpanQueryBuilder)) {
                        throw new ParsingException(parser2.getTokenLocation(), "[field_masking_span] query must be of type span query", new Object[0]);
                    }
                    inner = (SpanQueryBuilder)query.get();
                    continue;
                }
                throw new ParsingException(parser2.getTokenLocation(), "[field_masking_span] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser2.floatValue();
                continue;
            }
            if (FIELD_FIELD.match(currentFieldName)) {
                field = parser2.text();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser2.text();
                continue;
            }
            throw new ParsingException(parser2.getTokenLocation(), "[field_masking_span] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (inner == null) {
            throw new ParsingException(parser2.getTokenLocation(), "field_masking_span must have [query] span query clause", new Object[0]);
        }
        if (field == null) {
            throw new ParsingException(parser2.getTokenLocation(), "field_masking_span must have [field] set for it", new Object[0]);
        }
        FieldMaskingSpanQueryBuilder queryBuilder = new FieldMaskingSpanQueryBuilder(inner, field);
        queryBuilder.boost(boost);
        queryBuilder.queryName(queryName);
        return Optional.of(queryBuilder);
    }

    protected SpanQuery doToQuery(QueryShardContext context) throws IOException {
        String fieldInQuery = this.fieldName;
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType != null) {
            fieldInQuery = fieldType.name();
        }
        Query innerQuery = this.queryBuilder.toQuery(context);
        assert (innerQuery instanceof SpanQuery);
        return new FieldMaskingSpanQuery((SpanQuery)innerQuery, fieldInQuery);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.queryBuilder, this.fieldName);
    }

    @Override
    protected boolean doEquals(FieldMaskingSpanQueryBuilder other) {
        return Objects.equals(this.queryBuilder, other.queryBuilder) && Objects.equals(this.fieldName, other.fieldName);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

