/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TypeParsers;

public class StringFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "string";
    private static final int POSITION_INCREMENT_GAP_USE_ANALYZER = -1;
    private static final Set<String> SUPPORTED_PARAMETERS_FOR_AUTO_UPGRADE_TO_KEYWORD = new HashSet<String>(Arrays.asList("type", "index", "store", "doc_values", "omit_norms", "norms", "fields", "copy_to", "fielddata", "include_in_all", "ignore_above"));
    private static final Set<String> SUPPORTED_PARAMETERS_FOR_AUTO_UPGRADE_TO_TEXT = new HashSet<String>(Arrays.asList("type", "index", "store", "doc_values", "omit_norms", "norms", "fields", "copy_to", "fielddata", "include_in_all", "analyzer", "search_analyzer", "search_quote_analyzer", "index_options", "position_increment_gap"));
    private Boolean includeInAll;
    private int positionIncrementGap;
    private int ignoreAbove;

    protected StringFieldMapper(String simpleName, StringFieldType fieldType, MappedFieldType defaultFieldType, int positionIncrementGap, int ignoreAbove, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        if (Version.indexCreated(indexSettings).onOrAfter(Version.V_5_0_0_alpha1)) {
            throw new IllegalArgumentException("The [string] type is removed in 5.0. You should now use either a [text] or [keyword] field instead for field [" + fieldType.name() + "]");
        }
        if (fieldType.tokenized() && fieldType.indexOptions() != IndexOptions.NONE && this.fieldType().hasDocValues()) {
            throw new MapperParsingException("Field [" + fieldType.name() + "] cannot be analyzed and have doc values");
        }
        if (fieldType.hasDocValues() && (fieldType.fielddataMinFrequency() != Defaults.FIELDDATA_MIN_FREQUENCY || fieldType.fielddataMaxFrequency() != Defaults.FIELDDATA_MAX_FREQUENCY || fieldType.fielddataMinSegmentSize() != Defaults.FIELDDATA_MIN_SEGMENT_SIZE)) {
            throw new MapperParsingException("Field [" + fieldType.name() + "] cannot have doc values and use fielddata filtering");
        }
        this.positionIncrementGap = positionIncrementGap;
        this.ignoreAbove = ignoreAbove;
        this.includeInAll = includeInAll;
    }

    @Override
    protected StringFieldMapper clone() {
        return (StringFieldMapper)super.clone();
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    public int getPositionIncrementGap() {
        return this.positionIncrementGap;
    }

    public int getIgnoreAbove() {
        return this.ignoreAbove;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        ValueAndBoost valueAndBoost = StringFieldMapper.parseCreateFieldForString(context, this.fieldType().nullValueAsString(), this.fieldType().boost());
        if (valueAndBoost.value() == null) {
            return;
        }
        if (this.ignoreAbove > 0 && valueAndBoost.value().length() > this.ignoreAbove) {
            return;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.fieldType().name(), valueAndBoost.value(), valueAndBoost.boost());
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            Field field = new Field(this.fieldType().name(), valueAndBoost.value(), (FieldType)this.fieldType());
            if (valueAndBoost.boost() != 1.0f && Version.indexCreated(context.indexSettings()).before(Version.V_5_0_0_alpha1)) {
                field.setBoost(valueAndBoost.boost());
            }
            fields.add((IndexableField)field);
        }
        if (this.fieldType().hasDocValues()) {
            fields.add((IndexableField)new SortedSetDocValuesField(this.fieldType().name(), new BytesRef((CharSequence)valueAndBoost.value())));
        }
    }

    public static ValueAndBoost parseCreateFieldForString(ParseContext context, String nullValue, float defaultBoost) throws IOException {
        if (context.externalValueSet()) {
            return new ValueAndBoost(context.externalValue().toString(), defaultBoost);
        }
        XContentParser parser2 = context.parser();
        if (parser2.currentToken() == XContentParser.Token.VALUE_NULL) {
            return new ValueAndBoost(nullValue, defaultBoost);
        }
        if (parser2.currentToken() == XContentParser.Token.START_OBJECT && Version.indexCreated(context.indexSettings()).before(Version.V_5_0_0_alpha1)) {
            XContentParser.Token token;
            String currentFieldName = null;
            String value = nullValue;
            float boost = defaultBoost;
            while ((token = parser2.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser2.currentName();
                    continue;
                }
                if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                    value = parser2.textOrNull();
                    continue;
                }
                if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                    boost = parser2.floatValue();
                    continue;
                }
                throw new IllegalArgumentException("unknown property [" + currentFieldName + "]");
            }
            return new ValueAndBoost(value, boost);
        }
        return new ValueAndBoost(parser2.textOrNull(), defaultBoost);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        this.includeInAll = ((StringFieldMapper)mergeWith).includeInAll;
        this.ignoreAbove = ((StringFieldMapper)mergeWith).ignoreAbove;
    }

    @Override
    protected String indexTokenizeOption(boolean indexed, boolean tokenized) {
        if (!indexed) {
            return "no";
        }
        if (tokenized) {
            return "analyzed";
        }
        return "not_analyzed";
    }

    @Override
    public StringFieldType fieldType() {
        return (StringFieldType)super.fieldType();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        this.doXContentAnalyzers(builder, includeDefaults);
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
        if (includeDefaults || this.positionIncrementGap != -1) {
            builder.field("position_increment_gap", this.positionIncrementGap);
        }
        if (includeDefaults || this.ignoreAbove != -1) {
            builder.field("ignore_above", this.ignoreAbove);
        }
        if (includeDefaults || this.fieldType().fielddata() != ((StringFieldType)this.defaultFieldType).fielddata()) {
            builder.field("fielddata", this.fieldType().fielddata());
        }
        if (this.fieldType().fielddata() && (includeDefaults || this.fieldType().fielddataMinFrequency() != Defaults.FIELDDATA_MIN_FREQUENCY || this.fieldType().fielddataMaxFrequency() != Defaults.FIELDDATA_MAX_FREQUENCY || this.fieldType().fielddataMinSegmentSize() != Defaults.FIELDDATA_MIN_SEGMENT_SIZE)) {
            builder.startObject("fielddata_frequency_filter");
            if (includeDefaults || this.fieldType().fielddataMinFrequency() != Defaults.FIELDDATA_MIN_FREQUENCY) {
                builder.field("min", this.fieldType().fielddataMinFrequency());
            }
            if (includeDefaults || this.fieldType().fielddataMaxFrequency() != Defaults.FIELDDATA_MAX_FREQUENCY) {
                builder.field("max", this.fieldType().fielddataMaxFrequency());
            }
            if (includeDefaults || this.fieldType().fielddataMinSegmentSize() != Defaults.FIELDDATA_MIN_SEGMENT_SIZE) {
                builder.field("min_segment_size", this.fieldType().fielddataMinSegmentSize());
            }
            builder.endObject();
        }
    }

    public static class ValueAndBoost {
        private final String value;
        private final float boost;

        public ValueAndBoost(String value, float boost) {
            this.value = value;
            this.boost = boost;
        }

        public String value() {
            return this.value;
        }

        public float boost() {
            return this.boost;
        }
    }

    public static final class StringFieldType
    extends org.elasticsearch.index.mapper.StringFieldType {
        private boolean fielddata;
        private double fielddataMinFrequency;
        private double fielddataMaxFrequency;
        private int fielddataMinSegmentSize;

        public StringFieldType() {
            this.fielddata = true;
            this.fielddataMinFrequency = Defaults.FIELDDATA_MIN_FREQUENCY;
            this.fielddataMaxFrequency = Defaults.FIELDDATA_MAX_FREQUENCY;
            this.fielddataMinSegmentSize = Defaults.FIELDDATA_MIN_SEGMENT_SIZE;
        }

        protected StringFieldType(StringFieldType ref) {
            super(ref);
            this.fielddata = ref.fielddata;
            this.fielddataMinFrequency = ref.fielddataMinFrequency;
            this.fielddataMaxFrequency = ref.fielddataMaxFrequency;
            this.fielddataMinSegmentSize = ref.fielddataMinSegmentSize;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            StringFieldType that = (StringFieldType)((Object)o);
            return this.fielddata == that.fielddata && this.fielddataMinFrequency == that.fielddataMinFrequency && this.fielddataMaxFrequency == that.fielddataMaxFrequency && this.fielddataMinSegmentSize == that.fielddataMinSegmentSize;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fielddata, this.fielddataMinFrequency, this.fielddataMaxFrequency, this.fielddataMinSegmentSize);
        }

        @Override
        public StringFieldType clone() {
            return new StringFieldType(this);
        }

        @Override
        public String typeName() {
            return StringFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType other, List<String> conflicts, boolean strict) {
            super.checkCompatibility(other, conflicts, strict);
            StringFieldType otherType = (StringFieldType)other;
            if (strict) {
                if (this.fielddata() != otherType.fielddata()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata] across all types.");
                }
                if (this.fielddataMinFrequency() != otherType.fielddataMinFrequency()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata_frequency_filter.min] across all types.");
                }
                if (this.fielddataMaxFrequency() != otherType.fielddataMaxFrequency()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata_frequency_filter.max] across all types.");
                }
                if (this.fielddataMinSegmentSize() != otherType.fielddataMinSegmentSize()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata_frequency_filter.min_segment_size] across all types.");
                }
            }
        }

        public boolean fielddata() {
            return this.fielddata;
        }

        public void setFielddata(boolean fielddata) {
            this.checkIfFrozen();
            this.fielddata = fielddata;
        }

        public double fielddataMinFrequency() {
            return this.fielddataMinFrequency;
        }

        public void setFielddataMinFrequency(double fielddataMinFrequency) {
            this.checkIfFrozen();
            this.fielddataMinFrequency = fielddataMinFrequency;
        }

        public double fielddataMaxFrequency() {
            return this.fielddataMaxFrequency;
        }

        public void setFielddataMaxFrequency(double fielddataMaxFrequency) {
            this.checkIfFrozen();
            this.fielddataMaxFrequency = fielddataMaxFrequency;
        }

        public int fielddataMinSegmentSize() {
            return this.fielddataMinSegmentSize;
        }

        public void setFielddataMinSegmentSize(int fielddataMinSegmentSize) {
            this.checkIfFrozen();
            this.fielddataMinSegmentSize = fielddataMinSegmentSize;
        }

        @Override
        public Query nullValueQuery() {
            if (this.nullValue() == null) {
                return null;
            }
            return this.termQuery(this.nullValue(), null);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            if (this.hasDocValues()) {
                return new DocValuesIndexFieldData.Builder();
            }
            if (this.fielddata) {
                return new PagedBytesIndexFieldData.Builder(this.fielddataMinFrequency, this.fielddataMaxFrequency, this.fielddataMinSegmentSize);
            }
            throw new IllegalArgumentException("Fielddata is disabled on analyzed string fields by default. Set fielddata=true on [" + this.name() + "] in order to load fielddata in memory by uninverting the inverted index. Note that this can however use significant memory.");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private final DeprecationLogger deprecationLogger;

        public TypeParser() {
            Logger logger = Loggers.getLogger(this.getClass());
            this.deprecationLogger = new DeprecationLogger(logger);
        }

        public Mapper.Builder parse(String fieldName, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Object fielddataObject;
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_5_0_0_alpha1)) {
                Set autoUpgradeParameters;
                Object index = node.get("index");
                if (!Arrays.asList(null, "no", "not_analyzed", "analyzed").contains(index)) {
                    throw new IllegalArgumentException("Can't parse [index] value [" + index + "] for field [" + fieldName + "], expected [no], [not_analyzed] or [analyzed]");
                }
                boolean keyword = index != null && !"analyzed".equals(index);
                Set set = autoUpgradeParameters = keyword ? SUPPORTED_PARAMETERS_FOR_AUTO_UPGRADE_TO_KEYWORD : SUPPORTED_PARAMETERS_FOR_AUTO_UPGRADE_TO_TEXT;
                if (autoUpgradeParameters.containsAll(node.keySet())) {
                    Object fielddataO;
                    Object omitNorms;
                    this.deprecationLogger.deprecated("The [string] field is deprecated, please use [text] or [keyword] instead on [{}]", fieldName);
                    node.put("index", !"no".equals(index));
                    Object norms = node.remove("norms");
                    if (norms instanceof Map) {
                        norms = ((Map)norms).get("enabled");
                    }
                    if (norms != null) {
                        node.put("norms", TypeParsers.nodeBooleanValue(fieldName, "norms", norms));
                    }
                    if ((omitNorms = node.remove("omit_norms")) != null) {
                        node.put("norms", !TypeParsers.nodeBooleanValue(fieldName, "omit_norms", omitNorms));
                    }
                    if ((fielddataO = node.get("fielddata")) instanceof Map) {
                        Map fielddata = (Map)fielddataO;
                        if (!keyword) {
                            node.put("fielddata", !"disabled".equals(fielddata.get("format")));
                            Map fielddataFilter = (Map)fielddata.get("filter");
                            if (fielddataFilter != null) {
                                Map frequencyFilter = (Map)fielddataFilter.get("frequency");
                                frequencyFilter.keySet().retainAll(Arrays.asList("min", "max", "min_segment_size"));
                                node.put("fielddata_frequency_filter", frequencyFilter);
                            }
                        } else {
                            node.remove("fielddata");
                        }
                        Object loading = fielddata.get("loading");
                        if (loading != null) {
                            node.put("eager_global_ordinals", "eager_global_ordinals".equals(loading));
                        }
                    }
                    if (keyword) {
                        return new KeywordFieldMapper.TypeParser().parse(fieldName, node, parserContext);
                    }
                    return new TextFieldMapper.TypeParser().parse(fieldName, node, parserContext);
                }
                HashSet<String> unsupportedParameters = new HashSet<String>(node.keySet());
                unsupportedParameters.removeAll(autoUpgradeParameters);
                throw new IllegalArgumentException("The [string] type is removed in 5.0 and automatic upgrade failed because parameters " + unsupportedParameters + " are not supported for automatic upgrades. You should now use either a [text] or [keyword] field instead for field [" + fieldName + "]");
            }
            Builder builder = new Builder(fieldName);
            Object index = node.remove("index");
            if (index != null) {
                String normalizedIndex;
                switch (normalizedIndex = index.toString()) {
                    case "analyzed": {
                        builder.tokenized(true);
                        node.put("index", true);
                        break;
                    }
                    case "not_analyzed": {
                        builder.tokenized(false);
                        node.put("index", true);
                        break;
                    }
                    case "no": {
                        node.put("index", false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Can't parse [index] value [" + index + "] for field [" + fieldName + "], expected [no], [not_analyzed] or [analyzed]");
                    }
                }
            }
            if ((fielddataObject = node.get("fielddata")) instanceof Map) {
                Map fielddataFilter;
                Map fielddata = (Map)fielddataObject;
                Object loading = fielddata.get("loading");
                if (loading != null) {
                    node.put("eager_global_ordinals", "eager_global_ordinals".equals(loading));
                }
                if ((fielddataFilter = (Map)fielddata.get("filter")) != null) {
                    Map frequencyFilter = (Map)fielddataFilter.get("frequency");
                    frequencyFilter.keySet().retainAll(Arrays.asList("min", "max", "min_segment_size"));
                    node.put("fielddata_frequency_filter", frequencyFilter);
                }
                node.put("fielddata", !"disabled".equals(fielddata.get("format")));
            }
            TypeParsers.parseTextField(builder, fieldName, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("position_increment_gap")) {
                    int newPositionIncrementGap = XContentMapValues.nodeIntegerValue(propNode, -1);
                    if (newPositionIncrementGap < 0) {
                        throw new MapperParsingException("positions_increment_gap less than 0 aren't allowed.");
                    }
                    builder.positionIncrementGap(newPositionIncrementGap);
                    if (builder.fieldType().indexAnalyzer() == null) {
                        builder.fieldType().setIndexAnalyzer(parserContext.getIndexAnalyzers().getDefaultIndexAnalyzer());
                    }
                    if (builder.fieldType().searchAnalyzer() == null) {
                        builder.fieldType().setSearchAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchAnalyzer());
                    }
                    if (builder.fieldType().searchQuoteAnalyzer() == null) {
                        builder.fieldType().setSearchQuoteAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchQuoteAnalyzer());
                    }
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_above")) {
                    builder.ignoreAbove(XContentMapValues.nodeIntegerValue(propNode, -1));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("fielddata")) {
                    builder.fielddata(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("eager_global_ordinals")) {
                    builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("fielddata_frequency_filter")) continue;
                Map frequencyFilter = (Map)propNode;
                double minFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("min"), 0.0);
                double maxFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("max"), 2.147483647E9);
                int minSegmentSize = XContentMapValues.nodeIntegerValue(frequencyFilter.remove("min_segment_size"), 0);
                builder.fielddataFrequencyFilter(minFrequency, maxFrequency, minSegmentSize);
                DocumentMapperParser.checkNoRemainingFields(propName, frequencyFilter, parserContext.indexVersionCreated());
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, StringFieldMapper> {
        private final DeprecationLogger deprecationLogger;
        protected String nullValue = Defaults.NULL_VALUE;
        protected int positionIncrementGap = -1;
        protected int ignoreAbove = -1;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
            Logger logger = Loggers.getLogger(this.getClass());
            this.deprecationLogger = new DeprecationLogger(logger);
        }

        @Override
        public StringFieldType fieldType() {
            return (StringFieldType)super.fieldType();
        }

        @Override
        public Builder searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            super.searchAnalyzer(searchAnalyzer);
            return this;
        }

        public Builder positionIncrementGap(int positionIncrementGap) {
            this.positionIncrementGap = positionIncrementGap;
            return this;
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        public Builder fielddata(boolean fielddata) {
            this.fieldType().setFielddata(fielddata);
            return (Builder)this.builder;
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.fieldType().setEagerGlobalOrdinals(eagerGlobalOrdinals);
            return (Builder)this.builder;
        }

        public Builder fielddataFrequencyFilter(double minFreq, double maxFreq, int minSegmentSize) {
            this.fieldType().setFielddataMinFrequency(minFreq);
            this.fieldType().setFielddataMaxFrequency(maxFreq);
            this.fieldType().setFielddataMinSegmentSize(minSegmentSize);
            return (Builder)this.builder;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            if (this.fieldType().hasDocValues() && this.fieldType().fielddata()) {
                this.fieldType().setFielddata(false);
            }
        }

        @Override
        public StringFieldMapper build(Mapper.BuilderContext context) {
            if (this.fieldType.indexOptions() != IndexOptions.NONE && !this.fieldType.tokenized()) {
                this.defaultFieldType.setOmitNorms(true);
                this.defaultFieldType.setIndexOptions(IndexOptions.DOCS);
                if (!this.omitNormsSet && this.fieldType.boost() == 1.0f) {
                    this.fieldType.setOmitNorms(true);
                }
                if (!this.indexOptionsSet) {
                    this.fieldType.setIndexOptions(IndexOptions.DOCS);
                }
            }
            if (this.positionIncrementGap != -1) {
                if (this.fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    if (context.indexCreatedVersion().onOrAfter(Version.V_5_0_0_alpha1)) {
                        throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without positions enabled");
                    }
                    this.deprecationLogger.deprecated("setting position_increment_gap on field [{}] without positions enabled is deprecated and will be ignored", this.name);
                } else {
                    this.fieldType.setIndexAnalyzer(new NamedAnalyzer(this.fieldType.indexAnalyzer(), this.positionIncrementGap));
                    this.fieldType.setSearchAnalyzer(new NamedAnalyzer(this.fieldType.searchAnalyzer(), this.positionIncrementGap));
                    this.fieldType.setSearchQuoteAnalyzer(new NamedAnalyzer(this.fieldType.searchQuoteAnalyzer(), this.positionIncrementGap));
                }
            }
            this.setupFieldType(context);
            return new StringFieldMapper(this.name, this.fieldType(), this.defaultFieldType, this.positionIncrementGap, this.ignoreAbove, this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static double FIELDDATA_MIN_FREQUENCY = 0.0;
        public static double FIELDDATA_MAX_FREQUENCY = 2.147483647E9;
        public static int FIELDDATA_MIN_SEGMENT_SIZE = 0;
        public static final MappedFieldType FIELD_TYPE = new StringFieldType();
        public static final String NULL_VALUE;
        public static final int IGNORE_ABOVE = -1;

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

